/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.nativefst;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.segment.local.utils.nativefst.FST;
import org.apache.pinot.segment.local.utils.nativefst.FSTFlags;

public final class ConstantArcSizeFST
extends FST {
    public static final int TARGET_ADDRESS_SIZE = 4;
    public static final int FLAGS_SIZE = 1;
    public static final int LABEL_SIZE = 1;
    public static final int ARC_SIZE = 6;
    public static final int FLAGS_OFFSET = 0;
    public static final int LABEL_OFFSET = 1;
    public static final int ADDRESS_OFFSET = 2;
    public static final int BIT_ARC_FINAL = 2;
    public static final int BIT_ARC_LAST = 1;
    public static final int TERMINAL_STATE = 0;
    private final int _epsilon;
    private final byte[] _data;
    private Map<Integer, Integer> _outputSymbols;

    public ConstantArcSizeFST(byte[] data, int epsilon, Map<Integer, Integer> outputSymbols) {
        this._epsilon = epsilon;
        this._data = data;
        this._outputSymbols = outputSymbols;
    }

    @Override
    public int getRootNode() {
        return this.getEndNode(this.getFirstArc(this._epsilon));
    }

    @Override
    public int getFirstArc(int node) {
        return node;
    }

    @Override
    public int getArc(int node, byte label) {
        int arc = this.getFirstArc(node);
        while (arc != 0) {
            if (this.getArcLabel(arc) == label) {
                return arc;
            }
            arc = this.getNextArc(arc);
        }
        return 0;
    }

    @Override
    public int getNextArc(int arc) {
        if (this.isArcLast(arc)) {
            return 0;
        }
        return arc + 6;
    }

    @Override
    public byte getArcLabel(int arc) {
        return this._data[arc + 1];
    }

    @Override
    public int getOutputSymbol(int arc) {
        return this._outputSymbols.get(arc);
    }

    private int getArcTarget(int arc) {
        return this._data[arc += 2] << 24 | (this._data[arc + 1] & 0xFF) << 16 | (this._data[arc + 2] & 0xFF) << 8 | this._data[arc + 3] & 0xFF;
    }

    @Override
    public boolean isArcFinal(int arc) {
        return (this._data[arc + 0] & 2) != 0;
    }

    @Override
    public boolean isArcTerminal(int arc) {
        return this.getArcTarget(arc) == 0;
    }

    @Override
    public boolean isArcLast(int arc) {
        return (this._data[arc + 0] & 1) != 0;
    }

    @Override
    public int getEndNode(int arc) {
        return this.getArcTarget(arc);
    }

    @Override
    public Set<FSTFlags> getFlags() {
        return Collections.emptySet();
    }
}

