/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.nativefst.automaton;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.pinot.segment.local.utils.nativefst.automaton.Automaton;
import org.apache.pinot.segment.local.utils.nativefst.automaton.AutomatonProvider;
import org.apache.pinot.segment.local.utils.nativefst.automaton.BasicAutomata;
import org.apache.pinot.segment.local.utils.nativefst.automaton.BasicOperations;

public class RegExp {
    public static final int INTERSECTION = 1;
    public static final int COMPLEMENT = 2;
    public static final int EMPTY = 4;
    public static final int ANYSTRING = 8;
    public static final int AUTOMATON = 16;
    public static final int INTERVAL = 32;
    public static final int ALL = 65535;
    public static final int NONE = 0;
    private static boolean _allowMutation = false;
    Kind _kind;
    RegExp _exp1;
    RegExp _exp2;
    String _processedString;
    char _char;
    int _min;
    int _max;
    int _digits;
    char _from;
    char _to;
    String _inputString;
    int _flags;
    int _pos;

    RegExp() {
    }

    public RegExp(String inputString) throws IllegalArgumentException {
        this(inputString, 65535);
    }

    public RegExp(String inputString, int syntaxFlags) throws IllegalArgumentException {
        RegExp e;
        this._inputString = inputString;
        this._flags = syntaxFlags;
        if (inputString.length() == 0) {
            e = RegExp.makeString("");
        } else {
            e = this.parseUnionExp();
            if (this._pos < this._inputString.length()) {
                throw new IllegalArgumentException("end-of-string expected at position " + this._pos);
            }
        }
        this._kind = e._kind;
        this._exp1 = e._exp1;
        this._exp2 = e._exp2;
        this._processedString = e._processedString;
        this._char = e._char;
        this._min = e._min;
        this._max = e._max;
        this._digits = e._digits;
        this._from = e._from;
        this._to = e._to;
        this._inputString = null;
    }

    static RegExp makeUnion(RegExp exp1, RegExp exp2) {
        RegExp r = new RegExp();
        r._kind = Kind.REGEXP_UNION;
        r._exp1 = exp1;
        r._exp2 = exp2;
        return r;
    }

    static RegExp makeConcatenation(RegExp exp1, RegExp exp2) {
        if (!(exp1._kind != Kind.REGEXP_CHAR && exp1._kind != Kind.REGEXP_STRING || exp2._kind != Kind.REGEXP_CHAR && exp2._kind != Kind.REGEXP_STRING)) {
            return RegExp.makeString(exp1, exp2);
        }
        RegExp r = new RegExp();
        r._kind = Kind.REGEXP_CONCATENATION;
        if (!(exp1._kind != Kind.REGEXP_CONCATENATION || exp1._exp2._kind != Kind.REGEXP_CHAR && exp1._exp2._kind != Kind.REGEXP_STRING || exp2._kind != Kind.REGEXP_CHAR && exp2._kind != Kind.REGEXP_STRING)) {
            r._exp1 = exp1._exp1;
            r._exp2 = RegExp.makeString(exp1._exp2, exp2);
        } else if (!(exp1._kind != Kind.REGEXP_CHAR && exp1._kind != Kind.REGEXP_STRING || exp2._kind != Kind.REGEXP_CONCATENATION || exp2._exp1._kind != Kind.REGEXP_CHAR && exp2._exp1._kind != Kind.REGEXP_STRING)) {
            r._exp1 = RegExp.makeString(exp1, exp2._exp1);
            r._exp2 = exp2._exp2;
        } else {
            r._exp1 = exp1;
            r._exp2 = exp2;
        }
        return r;
    }

    private static RegExp makeString(RegExp exp1, RegExp exp2) {
        StringBuilder b = new StringBuilder();
        if (exp1._kind == Kind.REGEXP_STRING) {
            b.append(exp1._processedString);
        } else {
            b.append(exp1._char);
        }
        if (exp2._kind == Kind.REGEXP_STRING) {
            b.append(exp2._processedString);
        } else {
            b.append(exp2._char);
        }
        return RegExp.makeString(b.toString());
    }

    static RegExp makeIntersection(RegExp exp1, RegExp exp2) {
        RegExp r = new RegExp();
        r._kind = Kind.REGEXP_INTERSECTION;
        r._exp1 = exp1;
        r._exp2 = exp2;
        return r;
    }

    static RegExp makeOptional(RegExp exp) {
        RegExp r = new RegExp();
        r._kind = Kind.REGEXP_OPTIONAL;
        r._exp1 = exp;
        return r;
    }

    static RegExp makeRepeat(RegExp exp) {
        RegExp r = new RegExp();
        r._kind = Kind.REGEXP_REPEAT;
        r._exp1 = exp;
        return r;
    }

    static RegExp makeRepeat(RegExp exp, int min) {
        RegExp r = new RegExp();
        r._kind = Kind.REGEXP_REPEAT_MIN;
        r._exp1 = exp;
        r._min = min;
        return r;
    }

    static RegExp makeRepeat(RegExp exp, int min, int max) {
        RegExp r = new RegExp();
        r._kind = Kind.REGEXP_REPEAT_MINMAX;
        r._exp1 = exp;
        r._min = min;
        r._max = max;
        return r;
    }

    static RegExp makeComplement(RegExp exp) {
        RegExp r = new RegExp();
        r._kind = Kind.REGEXP_COMPLEMENT;
        r._exp1 = exp;
        return r;
    }

    static RegExp makeChar(char c) {
        RegExp r = new RegExp();
        r._kind = Kind.REGEXP_CHAR;
        r._char = c;
        return r;
    }

    static RegExp makeCharRange(char from, char to) {
        RegExp r = new RegExp();
        r._kind = Kind.REGEXP_CHAR_RANGE;
        r._from = from;
        r._to = to;
        return r;
    }

    static RegExp makeAnyChar() {
        RegExp r = new RegExp();
        r._kind = Kind.REGEXP_ANYCHAR;
        return r;
    }

    static RegExp makeEmpty() {
        RegExp r = new RegExp();
        r._kind = Kind.REGEXP_EMPTY;
        return r;
    }

    static RegExp makeString(String s) {
        RegExp r = new RegExp();
        r._kind = Kind.REGEXP_STRING;
        r._processedString = s;
        return r;
    }

    static RegExp makeAnyString() {
        RegExp r = new RegExp();
        r._kind = Kind.REGEXP_ANYSTRING;
        return r;
    }

    static RegExp makeAutomaton(String s) {
        RegExp r = new RegExp();
        r._kind = Kind.REGEXP_AUTOMATON;
        r._processedString = s;
        return r;
    }

    static RegExp makeInterval(int min, int max, int digits) {
        RegExp r = new RegExp();
        r._kind = Kind.REGEXP_INTERVAL;
        r._min = min;
        r._max = max;
        r._digits = digits;
        return r;
    }

    public Automaton toAutomaton() {
        return this.toAutomatonAllowMutate(null, null, false);
    }

    private Automaton toAutomatonAllowMutate(Map<String, Automaton> automata, AutomatonProvider automatonProvider, boolean minimize) throws IllegalArgumentException {
        boolean b = false;
        if (_allowMutation) {
            b = Automaton.setAllowMutate(true);
        }
        Automaton a = this.toAutomaton(automata, automatonProvider, minimize);
        if (_allowMutation) {
            Automaton.setAllowMutate(b);
        }
        return a;
    }

    private Automaton toAutomaton(Map<String, Automaton> automata, AutomatonProvider automatonProvider, boolean minimize) throws IllegalArgumentException {
        Automaton a = null;
        switch (this._kind) {
            case REGEXP_UNION: {
                ArrayList<Automaton> list = new ArrayList<Automaton>();
                this.findLeaves(this._exp1, Kind.REGEXP_UNION, list, automata, automatonProvider, minimize);
                this.findLeaves(this._exp2, Kind.REGEXP_UNION, list, automata, automatonProvider, minimize);
                a = BasicOperations.union(list);
                if (!minimize) break;
                a.minimize();
                break;
            }
            case REGEXP_CONCATENATION: {
                ArrayList<Automaton> list = new ArrayList<Automaton>();
                this.findLeaves(this._exp1, Kind.REGEXP_CONCATENATION, list, automata, automatonProvider, minimize);
                this.findLeaves(this._exp2, Kind.REGEXP_CONCATENATION, list, automata, automatonProvider, minimize);
                a = BasicOperations.concatenate(list);
                if (!minimize) break;
                a.minimize();
                break;
            }
            case REGEXP_INTERSECTION: {
                a = this._exp1.toAutomaton(automata, automatonProvider, minimize).intersection(this._exp2.toAutomaton(automata, automatonProvider, minimize));
                if (!minimize) break;
                a.minimize();
                break;
            }
            case REGEXP_OPTIONAL: {
                a = this._exp1.toAutomaton(automata, automatonProvider, minimize).optional();
                if (!minimize) break;
                a.minimize();
                break;
            }
            case REGEXP_REPEAT: {
                a = this._exp1.toAutomaton(automata, automatonProvider, minimize).repeat();
                if (!minimize) break;
                a.minimize();
                break;
            }
            case REGEXP_REPEAT_MIN: {
                a = this._exp1.toAutomaton(automata, automatonProvider, minimize).repeat(this._min);
                if (!minimize) break;
                a.minimize();
                break;
            }
            case REGEXP_REPEAT_MINMAX: {
                a = this._exp1.toAutomaton(automata, automatonProvider, minimize).repeat(this._min, this._max);
                if (!minimize) break;
                a.minimize();
                break;
            }
            case REGEXP_COMPLEMENT: {
                a = this._exp1.toAutomaton(automata, automatonProvider, minimize).complement();
                if (!minimize) break;
                a.minimize();
                break;
            }
            case REGEXP_CHAR: {
                a = BasicAutomata.makeChar(this._char);
                break;
            }
            case REGEXP_CHAR_RANGE: {
                a = BasicAutomata.makeCharRange(this._from, this._to);
                break;
            }
            case REGEXP_ANYCHAR: {
                a = BasicAutomata.makeAnyChar();
                break;
            }
            case REGEXP_EMPTY: {
                a = BasicAutomata.makeEmpty();
                break;
            }
            case REGEXP_STRING: {
                a = BasicAutomata.makeString(this._processedString);
                break;
            }
            case REGEXP_ANYSTRING: {
                a = BasicAutomata.makeAnyString();
                break;
            }
            case REGEXP_AUTOMATON: {
                Automaton aa = null;
                if (automata != null) {
                    aa = automata.get(this._processedString);
                }
                if (aa == null && automatonProvider != null) {
                    try {
                        aa = automatonProvider.getAutomaton(this._processedString);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                if (aa == null) {
                    throw new IllegalArgumentException("'" + this._processedString + "' not found");
                }
                a = aa.clone();
                break;
            }
            case REGEXP_INTERVAL: {
                a = BasicAutomata.makeInterval(this._min, this._max, this._digits);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown regexp state");
            }
        }
        return a;
    }

    private void findLeaves(RegExp exp, Kind kind, List<Automaton> list, Map<String, Automaton> automata, AutomatonProvider automatonProvider, boolean minimize) {
        if (exp._kind == kind) {
            this.findLeaves(exp._exp1, kind, list, automata, automatonProvider, minimize);
            this.findLeaves(exp._exp2, kind, list, automata, automatonProvider, minimize);
        } else {
            list.add(exp.toAutomaton(automata, automatonProvider, minimize));
        }
    }

    public String toString() {
        return this.toStringBuilder(new StringBuilder()).toString();
    }

    StringBuilder toStringBuilder(StringBuilder b) {
        switch (this._kind) {
            case REGEXP_UNION: {
                b.append("(");
                this._exp1.toStringBuilder(b);
                b.append("|");
                this._exp2.toStringBuilder(b);
                b.append(")");
                break;
            }
            case REGEXP_CONCATENATION: {
                this._exp1.toStringBuilder(b);
                this._exp2.toStringBuilder(b);
                break;
            }
            case REGEXP_INTERSECTION: {
                b.append("(");
                this._exp1.toStringBuilder(b);
                b.append("&");
                this._exp2.toStringBuilder(b);
                b.append(")");
                break;
            }
            case REGEXP_OPTIONAL: {
                b.append("(");
                this._exp1.toStringBuilder(b);
                b.append(")?");
                break;
            }
            case REGEXP_REPEAT: {
                b.append("(");
                this._exp1.toStringBuilder(b);
                b.append(")*");
                break;
            }
            case REGEXP_REPEAT_MIN: {
                b.append("(");
                this._exp1.toStringBuilder(b);
                b.append("){").append(this._min).append(",}");
                break;
            }
            case REGEXP_REPEAT_MINMAX: {
                b.append("(");
                this._exp1.toStringBuilder(b);
                b.append("){").append(this._min).append(",").append(this._max).append("}");
                break;
            }
            case REGEXP_COMPLEMENT: {
                b.append("~(");
                this._exp1.toStringBuilder(b);
                b.append(")");
                break;
            }
            case REGEXP_CHAR: {
                this.appendChar(this._char, b);
                break;
            }
            case REGEXP_CHAR_RANGE: {
                b.append("[\\").append(this._from).append("-\\").append(this._to).append("]");
                break;
            }
            case REGEXP_ANYCHAR: {
                b.append(".");
                break;
            }
            case REGEXP_EMPTY: {
                b.append("#");
                break;
            }
            case REGEXP_STRING: {
                if (this._processedString.indexOf(34) == -1) {
                    b.append("\"").append(this._processedString).append("\"");
                    break;
                }
                for (int i = 0; i < this._processedString.length(); ++i) {
                    this.appendChar(this._processedString.charAt(i), b);
                }
                break;
            }
            case REGEXP_ANYSTRING: {
                b.append("@");
                break;
            }
            case REGEXP_AUTOMATON: {
                b.append("<").append(this._processedString).append(">");
                break;
            }
            case REGEXP_INTERVAL: {
                int i;
                String s1 = Integer.toString(this._min);
                String s2 = Integer.toString(this._max);
                b.append("<");
                if (this._digits > 0) {
                    for (i = s1.length(); i < this._digits; ++i) {
                        b.append('0');
                    }
                }
                b.append(s1).append("-");
                if (this._digits > 0) {
                    for (i = s2.length(); i < this._digits; ++i) {
                        b.append('0');
                    }
                }
                b.append(s2).append(">");
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state");
            }
        }
        return b;
    }

    private void appendChar(char c, StringBuilder b) {
        if ("|&?*+{},![]^-.#@\"()<>\\".indexOf(c) != -1) {
            b.append("\\");
        }
        b.append(c);
    }

    private boolean peek(String s) {
        return this.more() && s.indexOf(this._inputString.charAt(this._pos)) != -1;
    }

    private boolean match(char c) {
        if (this._pos >= this._inputString.length()) {
            return false;
        }
        if (this._inputString.charAt(this._pos) == c) {
            ++this._pos;
            return true;
        }
        return false;
    }

    private boolean more() {
        return this._pos < this._inputString.length();
    }

    private char next() throws IllegalArgumentException {
        if (!this.more()) {
            throw new IllegalArgumentException("unexpected end-of-string");
        }
        return this._inputString.charAt(this._pos++);
    }

    private boolean check(int flag) {
        return (this._flags & flag) != 0;
    }

    final RegExp parseUnionExp() throws IllegalArgumentException {
        RegExp e = this.parseInterExp();
        if (this.match('|')) {
            e = RegExp.makeUnion(e, this.parseUnionExp());
        }
        return e;
    }

    final RegExp parseInterExp() throws IllegalArgumentException {
        RegExp e = this.parseConcatExp();
        if (this.check(1) && this.match('&')) {
            e = RegExp.makeIntersection(e, this.parseInterExp());
        }
        return e;
    }

    final RegExp parseConcatExp() throws IllegalArgumentException {
        RegExp e = this.parseRepeatExp();
        if (!(!this.more() || this.peek(")|") || this.check(1) && this.peek("&"))) {
            e = RegExp.makeConcatenation(e, this.parseConcatExp());
        }
        return e;
    }

    final RegExp parseRepeatExp() throws IllegalArgumentException {
        RegExp e = this.parseComplExp();
        while (this.peek("?*+{")) {
            if (this.match('?')) {
                e = RegExp.makeOptional(e);
                continue;
            }
            if (this.match('*')) {
                e = RegExp.makeRepeat(e);
                continue;
            }
            if (this.match('+')) {
                e = RegExp.makeRepeat(e, 1);
                continue;
            }
            if (!this.match('{')) continue;
            int start = this._pos;
            while (this.peek("0123456789")) {
                this.next();
            }
            if (start == this._pos) {
                throw new IllegalArgumentException("integer expected at position " + this._pos);
            }
            int n = Integer.parseInt(this._inputString.substring(start, this._pos));
            int m = -1;
            if (this.match(',')) {
                start = this._pos;
                while (this.peek("0123456789")) {
                    this.next();
                }
                if (start != this._pos) {
                    m = Integer.parseInt(this._inputString.substring(start, this._pos));
                }
            } else {
                m = n;
            }
            if (!this.match('}')) {
                throw new IllegalArgumentException("expected '}' at position " + this._pos);
            }
            if (m == -1) {
                e = RegExp.makeRepeat(e, n);
                continue;
            }
            e = RegExp.makeRepeat(e, n, m);
        }
        return e;
    }

    final RegExp parseComplExp() throws IllegalArgumentException {
        if (this.check(2) && this.match('~')) {
            return RegExp.makeComplement(this.parseComplExp());
        }
        return this.parseCharClassExp();
    }

    final RegExp parseCharClassExp() throws IllegalArgumentException {
        if (this.match('[')) {
            boolean negate = false;
            if (this.match('^')) {
                negate = true;
            }
            RegExp e = this.parseCharClasses();
            if (negate) {
                e = RegExp.makeIntersection(RegExp.makeAnyChar(), RegExp.makeComplement(e));
            }
            if (!this.match(']')) {
                throw new IllegalArgumentException("expected ']' at position " + this._pos);
            }
            return e;
        }
        return this.parseSimpleExp();
    }

    final RegExp parseCharClasses() throws IllegalArgumentException {
        RegExp e = this.parseCharClass();
        while (this.more() && !this.peek("]")) {
            e = RegExp.makeUnion(e, this.parseCharClass());
        }
        return e;
    }

    final RegExp parseCharClass() throws IllegalArgumentException {
        char c = this.parseCharExp();
        if (this.match('-')) {
            if (this.peek("]")) {
                return RegExp.makeUnion(RegExp.makeChar(c), RegExp.makeChar('-'));
            }
            return RegExp.makeCharRange(c, this.parseCharExp());
        }
        return RegExp.makeChar(c);
    }

    final RegExp parseSimpleExp() throws IllegalArgumentException {
        if (this.match('.')) {
            return RegExp.makeAnyChar();
        }
        if (this.check(4) && this.match('#')) {
            return RegExp.makeEmpty();
        }
        if (this.check(8) && this.match('@')) {
            return RegExp.makeAnyString();
        }
        if (this.match('\"')) {
            int start = this._pos;
            while (this.more() && !this.peek("\"")) {
                this.next();
            }
            if (!this.match('\"')) {
                throw new IllegalArgumentException("expected '\"' at position " + this._pos);
            }
            return RegExp.makeString(this._inputString.substring(start, this._pos - 1));
        }
        if (this.match('(')) {
            if (this.match(')')) {
                return RegExp.makeString("");
            }
            RegExp e = this.parseUnionExp();
            if (!this.match(')')) {
                throw new IllegalArgumentException("expected ')' at position " + this._pos);
            }
            return e;
        }
        if ((this.check(16) || this.check(32)) && this.match('<')) {
            int start = this._pos;
            while (this.more() && !this.peek(">")) {
                this.next();
            }
            if (!this.match('>')) {
                throw new IllegalArgumentException("expected '>' at position " + this._pos);
            }
            String s = this._inputString.substring(start, this._pos - 1);
            int i = s.indexOf(45);
            if (i == -1) {
                if (!this.check(16)) {
                    throw new IllegalArgumentException("interval syntax error at position " + (this._pos - 1));
                }
                return RegExp.makeAutomaton(s);
            }
            if (!this.check(32)) {
                throw new IllegalArgumentException("illegal identifier at position " + (this._pos - 1));
            }
            try {
                if (i == 0 || i == s.length() - 1 || i != s.lastIndexOf(45)) {
                    throw new NumberFormatException();
                }
                String smin = s.substring(0, i);
                String smax = s.substring(i + 1);
                int imin = Integer.parseInt(smin);
                int imax = Integer.parseInt(smax);
                int digits = smin.length() == smax.length() ? smin.length() : 0;
                if (imin > imax) {
                    int t = imin;
                    imin = imax;
                    imax = t;
                }
                return RegExp.makeInterval(imin, imax, digits);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("interval syntax error at position " + (this._pos - 1));
            }
        }
        return RegExp.makeChar(this.parseCharExp());
    }

    final char parseCharExp() throws IllegalArgumentException {
        this.match('\\');
        return this.next();
    }

    static enum Kind {
        REGEXP_UNION,
        REGEXP_CONCATENATION,
        REGEXP_INTERSECTION,
        REGEXP_OPTIONAL,
        REGEXP_REPEAT,
        REGEXP_REPEAT_MIN,
        REGEXP_REPEAT_MINMAX,
        REGEXP_COMPLEMENT,
        REGEXP_CHAR,
        REGEXP_CHAR_RANGE,
        REGEXP_ANYCHAR,
        REGEXP_EMPTY,
        REGEXP_STRING,
        REGEXP_ANYSTRING,
        REGEXP_AUTOMATON,
        REGEXP_INTERVAL;

    }
}

