/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.distinctcount;

import com.dynatrace.hash4j.distinctcount.DistinctCountUtil;
import com.dynatrace.hash4j.distinctcount.DistinctCounter;
import com.dynatrace.hash4j.distinctcount.StateChangeObserver;
import com.dynatrace.hash4j.distinctcount.UltraLogLog;
import com.dynatrace.hash4j.util.PackedArray;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Objects;

public final class HyperLogLog
implements DistinctCounter<HyperLogLog, Estimator> {
    private static final VarHandle INT_HANDLE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    public static final Estimator CORRECTED_RAW_ESTIMATOR = new CorrectedRawEstimator();
    public static final Estimator MAXIMUM_LIKELIHOOD_ESTIMATOR = new MaximumLikelihoodEstimator();
    public static final Estimator DEFAULT_ESTIMATOR = CORRECTED_RAW_ESTIMATOR;
    private static final PackedArray.PackedArrayHandler ARRAY_HANDLER = PackedArray.getHandler(6);
    static final int MIN_P = 3;
    static final int MAX_P = 26;
    private static final int MIN_STATE_SIZE = ARRAY_HANDLER.numBytes(8);
    private static final int MAX_STATE_SIZE = ARRAY_HANDLER.numBytes(0x4000000);
    private final int p;
    private final byte[] state;

    private static int getInt(byte[] b, int off) {
        return INT_HANDLE.get(b, off);
    }

    private static void setInt(byte[] b, int off, int v) {
        INT_HANDLE.set(b, off, v);
    }

    private HyperLogLog(int p) {
        this.state = ARRAY_HANDLER.create(1 << p);
        this.p = p;
    }

    private HyperLogLog(byte[] state) {
        this.state = state;
        this.p = HyperLogLog.calculateP(state.length);
    }

    private HyperLogLog(byte[] state, int p) {
        this.state = state;
        this.p = p;
    }

    public static HyperLogLog create(int p) {
        DistinctCountUtil.checkPrecisionParameter(p, 3, 26);
        return new HyperLogLog(p);
    }

    public static HyperLogLog create(UltraLogLog ullSketch) {
        int p = ullSketch.getP();
        DistinctCountUtil.checkPrecisionParameter(p, 3, 26);
        byte[] ullState = ullSketch.getState();
        return new HyperLogLog(ARRAY_HANDLER.create(i -> Math.max(0, ((ullState[i] & 0xFF) >>> 2) + 2 - p), 1 << p), p);
    }

    public static HyperLogLog wrap(byte[] state) {
        Objects.requireNonNull(state, "null argument");
        if (state.length > MAX_STATE_SIZE || state.length < MIN_STATE_SIZE || !DistinctCountUtil.isUnsignedPowerOfTwo(HyperLogLog.mul4DivideBy3(state.length))) {
            throw DistinctCountUtil.getUnexpectedStateLengthException();
        }
        return new HyperLogLog(state);
    }

    private static int mul4DivideBy3(int x) {
        return (int)(0x2AAAAAAACL * (long)x >> 33);
    }

    @Override
    public HyperLogLog copy() {
        return new HyperLogLog(Arrays.copyOf(this.state, this.state.length), this.p);
    }

    @Override
    public HyperLogLog downsize(int p) {
        DistinctCountUtil.checkPrecisionParameter(p, 3, 26);
        if (p >= this.p) {
            return this.copy();
        }
        return new HyperLogLog(p).add(this);
    }

    public static HyperLogLog merge(HyperLogLog sketch1, HyperLogLog sketch2) {
        Objects.requireNonNull(sketch1, "first sketch was null");
        Objects.requireNonNull(sketch2, "second sketch was null");
        if (sketch1.p <= sketch2.p) {
            return sketch1.copy().add(sketch2);
        }
        return sketch2.copy().add(sketch1);
    }

    @Override
    public byte[] getState() {
        return this.state;
    }

    @Override
    public int getP() {
        return this.p;
    }

    static int calculateP(int stateLength) {
        return 30 - Long.numberOfLeadingZeros(0x2AAAAAAACL * (long)stateLength);
    }

    @Override
    public HyperLogLog add(long hashValue) {
        this.add(hashValue, null);
        return this;
    }

    @Override
    public HyperLogLog addToken(int token) {
        return this.add(DistinctCountUtil.reconstructHash1(token));
    }

    public static int computeToken(long hashValue) {
        return DistinctCountUtil.computeToken1(hashValue);
    }

    @Override
    public HyperLogLog add(long hashValue, StateChangeObserver stateChangeObserver) {
        int idx = (int)(hashValue >>> -this.p);
        int newValue = Long.numberOfLeadingZeros((hashValue ^ 0xFFFFFFFFFFFFFFFFL) << this.p ^ 0xFFFFFFFFFFFFFFFFL) + 1;
        int oldValue = (int)ARRAY_HANDLER.update(this.state, idx, newValue, Math::max);
        if (stateChangeObserver != null && newValue > oldValue) {
            double stateChangeProbabilityDecrement = (double)(this.getScaledRegisterChangeProbability(oldValue) - this.getScaledRegisterChangeProbability(newValue)) * 5.421010862427522E-20;
            stateChangeObserver.stateChanged(stateChangeProbabilityDecrement);
        }
        return this;
    }

    @Override
    public HyperLogLog addToken(int token, StateChangeObserver stateChangeObserver) {
        return this.add(DistinctCountUtil.reconstructHash1(token), stateChangeObserver);
    }

    private long getScaledRegisterChangeProbability(int registerValue) {
        return 0x4000000000000000L >>> this.p - 2 + registerValue;
    }

    @Override
    public HyperLogLog add(HyperLogLog other) {
        Objects.requireNonNull(other, "null argument");
        byte[] otherData = other.state;
        if (other.p < this.p) {
            throw new IllegalArgumentException("other has smaller precision");
        }
        if (other.p == this.p) {
            int off = 0;
            while (off + 6 <= this.state.length) {
                int s0 = HyperLogLog.getInt(this.state, off);
                int s1 = HyperLogLog.getInt(this.state, off + 2);
                int sOther0 = HyperLogLog.getInt(other.state, off);
                int sOther1 = HyperLogLog.getInt(other.state, off + 2);
                int r0 = Math.max(s0 & 0x3F, sOther0 & 0x3F);
                int r1 = Math.max(s0 >>> 6 & 0x3F, sOther0 >>> 6 & 0x3F);
                int r2 = Math.max(s0 >>> 12 & 0x3F, sOther0 >>> 12 & 0x3F);
                int r3 = Math.max(s0 >>> 18 & 0x3F, sOther0 >>> 18 & 0x3F);
                int r4 = Math.max(s1 >>> 8 & 0x3F, sOther1 >>> 8 & 0x3F);
                int r5 = Math.max(s1 >>> 14 & 0x3F, sOther1 >>> 14 & 0x3F);
                int r6 = Math.max(s1 >>> 20 & 0x3F, sOther1 >>> 20 & 0x3F);
                int r7 = Math.max(s1 >>> 26 & 0x3F, sOther1 >>> 26 & 0x3F);
                HyperLogLog.setInt(this.state, off + 2, r5 << 14 | r6 << 20 | r7 << 26);
                HyperLogLog.setInt(this.state, off, r0 | r1 << 6 | r2 << 12 | r3 << 18 | r4 << 24 | r5 << 30);
                off += 6;
            }
        } else {
            int deltaP = other.p - this.p;
            int j = 0;
            for (int i = 0; i < 1 << this.p; ++i) {
                int oldR;
                int r = oldR = (int)ARRAY_HANDLER.get(this.state, i);
                int otherR = (int)ARRAY_HANDLER.get(otherData, j);
                if (otherR != 0 && (otherR += deltaP) > r) {
                    r = otherR;
                }
                ++j;
                for (long k = 1L; k < 1L << deltaP; ++k) {
                    int nlz = Long.numberOfLeadingZeros(k) - 64 + deltaP;
                    if (nlz >= r && ARRAY_HANDLER.get(otherData, j) != 0L) {
                        r = nlz + 1;
                    }
                    ++j;
                }
                if (oldR >= r) continue;
                ARRAY_HANDLER.set(this.state, i, r);
            }
        }
        return this;
    }

    @Override
    public double getDistinctCountEstimate() {
        return DEFAULT_ESTIMATOR.estimate(this);
    }

    @Override
    public double getDistinctCountEstimate(Estimator estimator) {
        return estimator.estimate(this);
    }

    @Override
    public double getStateChangeProbability() {
        long sum = 0L;
        int off = 0;
        while (off + 6 <= this.state.length) {
            int s0 = HyperLogLog.getInt(this.state, off);
            int s1 = HyperLogLog.getInt(this.state, off + 2);
            sum += this.getScaledRegisterChangeProbability(s0);
            sum += this.getScaledRegisterChangeProbability(s0 >>> 6);
            sum += this.getScaledRegisterChangeProbability(s0 >>> 12);
            sum += this.getScaledRegisterChangeProbability(s0 >>> 18);
            sum += this.getScaledRegisterChangeProbability(s1 >>> 8);
            sum += this.getScaledRegisterChangeProbability(s1 >>> 14);
            sum += this.getScaledRegisterChangeProbability(s1 >>> 20);
            sum += this.getScaledRegisterChangeProbability(s1 >>> 26);
            off += 6;
        }
        if (sum == 0L && this.state[0] == 0) {
            return 1.0;
        }
        return DistinctCountUtil.unsignedLongToDouble(sum) * 5.421010862427522E-20;
    }

    @Override
    public HyperLogLog reset() {
        ARRAY_HANDLER.clear(this.state);
        return this;
    }

    private static final class MaximumLikelihoodEstimator
    implements Estimator {
        private static final double INV_SQRT_FISHER_INFORMATION = 1.0367047097785012;
        private static final double ML_EQUATION_SOLVER_EPS = 0.0010367047097785012;
        private static final double ML_BIAS_CORRECTION_CONSTANT = 1.01015908095854;

        private MaximumLikelihoodEstimator() {
        }

        @Override
        public double estimate(HyperLogLog hyperLogLog) {
            byte[] state = hyperLogLog.state;
            int p = hyperLogLog.p;
            long agg = 0L;
            int[] c = new int[64];
            long inc = 1L << -p;
            int off = 0;
            while (off + 6 <= state.length) {
                int s0 = HyperLogLog.getInt(state, off);
                int s1 = HyperLogLog.getInt(state, off + 2);
                int r0 = s0 & 0x3F;
                int r1 = s0 >>> 6 & 0x3F;
                int r2 = s0 >>> 12 & 0x3F;
                int r3 = s0 >>> 18 & 0x3F;
                int r4 = s1 >>> 8 & 0x3F;
                int r5 = s1 >>> 14 & 0x3F;
                int r6 = s1 >>> 20 & 0x3F;
                int r7 = s1 >>> 26 & 0x3F;
                agg += inc >>> r0;
                agg += inc >>> r1;
                agg += inc >>> r2;
                agg += inc >>> r3;
                agg += inc >>> r4;
                agg += inc >>> r5;
                agg += inc >>> r6;
                agg += inc >>> r7;
                int n = r0;
                c[n] = c[n] + 1;
                int n2 = r1;
                c[n2] = c[n2] + 1;
                int n3 = r2;
                c[n3] = c[n3] + 1;
                int n4 = r3;
                c[n4] = c[n4] + 1;
                int n5 = r4;
                c[n5] = c[n5] + 1;
                int n6 = r5;
                c[n6] = c[n6] + 1;
                int n7 = r6;
                c[n7] = c[n7] + 1;
                int n8 = r7;
                c[n8] = c[n8] + 1;
                off += 6;
            }
            int m = 1 << p;
            if (c[0] == m) {
                return 0.0;
            }
            c[0] = 0;
            int n = 64 - p;
            c[n] = c[n] + c[65 - p];
            double a = DistinctCountUtil.unsignedLongToDouble(agg) * (double)m * 5.421010862427522E-20;
            return (double)m * DistinctCountUtil.solveMaximumLikelihoodEquation(a, c, 64 - p, 0.0010367047097785012 / Math.sqrt(m)) / (1.0 + 1.01015908095854 / (double)m);
        }
    }

    static final class CorrectedRawEstimator
    implements Estimator {
        private static final double ONE_THIRD = 0.3333333333333333;
        static final double[] ESTIMATION_FACTORS = new double[]{40.67760431873907, 172.99391414703106, 714.5560640781132, 2905.6322537477818, 11719.723738552972, 47075.733045730056, 188699.0930713932, 755591.1970832772, 3023956.9501793, 1.2099014641293615E7, 4.8402434765532516E7, 1.9362249398321322E8, 7.745154882959671E8, 3.098112980431337E9, 1.2392553978741665E10, 4.9570420031520744E10, 1.982820883617127E11, 7.931291699206317E11, 3.1725183126326094E12, 1.2690076516433127E13, 5.076031259754041E13, 2.0304126345377997E14, 8.12165079942359E14, 3.248660372023916E15};

        private CorrectedRawEstimator() {
        }

        static double sigma(double x) {
            double oldSum;
            if (x <= 0.0) {
                return 0.0;
            }
            if (x >= 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            double z = 1.0;
            double sum = 0.0;
            while ((oldSum = sum) < (sum += (x *= x) * (z += z))) {
            }
            return sum;
        }

        static double tau(double x) {
            double oneMinusX;
            double zPrime;
            if (x <= 0.0 || x >= 1.0) {
                return 0.0;
            }
            double y = 1.0;
            double z = 1.0 - x;
            while ((zPrime = z) > (z -= (oneMinusX = 1.0 - (x = Math.sqrt(x))) * oneMinusX * (y *= 0.5))) {
            }
            return z * 0.3333333333333333;
        }

        @Override
        public double estimate(HyperLogLog hyperLogLog) {
            byte[] state = hyperLogLog.state;
            int p = hyperLogLog.p;
            int c0 = 0;
            int cMax = 0;
            long agg = 0L;
            int maxR = 65 - p;
            long inc = 1L << -p;
            int off = 0;
            while (off + 6 <= state.length) {
                int s0 = HyperLogLog.getInt(state, off);
                int s1 = HyperLogLog.getInt(state, off + 2);
                int r0 = s0 & 0x3F;
                int r1 = s0 >>> 6 & 0x3F;
                int r2 = s0 >>> 12 & 0x3F;
                int r3 = s0 >>> 18 & 0x3F;
                int r4 = s1 >>> 8 & 0x3F;
                int r5 = s1 >>> 14 & 0x3F;
                int r6 = s1 >>> 20 & 0x3F;
                int r7 = s1 >>> 26 & 0x3F;
                agg += inc >>> r0;
                agg += inc >>> r1;
                agg += inc >>> r2;
                agg += inc >>> r3;
                agg += inc >>> r4;
                agg += inc >>> r5;
                agg += inc >>> r6;
                agg += inc >>> r7;
                if (r0 >= maxR) {
                    ++cMax;
                }
                if (r1 >= maxR) {
                    ++cMax;
                }
                if (r2 >= maxR) {
                    ++cMax;
                }
                if (r3 >= maxR) {
                    ++cMax;
                }
                if (r4 >= maxR) {
                    ++cMax;
                }
                if (r5 >= maxR) {
                    ++cMax;
                }
                if (r6 >= maxR) {
                    ++cMax;
                }
                if (r7 >= maxR) {
                    ++cMax;
                }
                if (r0 == 0) {
                    ++c0;
                }
                if (r1 == 0) {
                    ++c0;
                }
                if (r2 == 0) {
                    ++c0;
                }
                if (r3 == 0) {
                    ++c0;
                }
                if (r4 == 0) {
                    ++c0;
                }
                if (r5 == 0) {
                    ++c0;
                }
                if (r6 == 0) {
                    ++c0;
                }
                if (r7 == 0) {
                    ++c0;
                }
                off += 6;
            }
            double sum = 0.0;
            double m = 1 << p;
            if (cMax > 0) {
                sum += Double.longBitsToDouble(0x3FF0000000000000L - (32L - (long)p << 53)) * CorrectedRawEstimator.tau(1.0 - (double)cMax / m);
            }
            sum += DistinctCountUtil.unsignedLongToDouble(agg) * m * 5.421010862427522E-20;
            if (c0 > 0) {
                sum += m * CorrectedRawEstimator.sigma((double)c0 / m);
            }
            return ESTIMATION_FACTORS[p - 3] / sum;
        }
    }

    public static interface Estimator
    extends DistinctCounter.Estimator<HyperLogLog> {
    }
}

