/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.file;

import com.dynatrace.hash4j.file.AbstractFileHasher128;
import com.dynatrace.hash4j.file.FileHasher128;
import com.dynatrace.hash4j.hashing.HashStream128;
import com.dynatrace.hash4j.hashing.HashValue128;
import com.dynatrace.hash4j.hashing.Hashing;
import com.dynatrace.hash4j.util.Preconditions;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

class Imohash1_0_2
extends AbstractFileHasher128 {
    static final long DEFAULT_SAMPLE_THRESHOLD = 131072L;
    static final int DEFAULT_SAMPLE_SIZE = 16384;
    private static final int BUFFER_SIZE = 4096;
    private final HashStream128 hashStream;
    private final long sampleThreshold;
    private final int sampleSize;
    private final byte[] buffer;

    private Imohash1_0_2(int sampleSize, long sampleThreshold) {
        Preconditions.checkArgument(sampleSize >= 0);
        Preconditions.checkArgument((long)sampleSize * 4L <= sampleThreshold);
        this.sampleThreshold = sampleThreshold;
        this.sampleSize = sampleSize;
        this.hashStream = Hashing.murmur3_128().hashStream();
        this.buffer = new byte[4096];
    }

    static FileHasher128 create() {
        return new Imohash1_0_2(16384, 131072L);
    }

    static FileHasher128 create(int sampleSize, long sampleThreshold) {
        return new Imohash1_0_2(sampleSize, sampleThreshold);
    }

    private void processBytes(long numBytes, InputStream stream, HashStream128 hashStream) throws IOException {
        long numBytesRead;
        int bufferPos = 0;
        for (long numBytesRemaining = numBytes; numBytesRemaining > 0L; numBytesRemaining -= numBytesRead) {
            int numBytesToRead = this.buffer.length - bufferPos;
            if ((long)numBytesToRead > numBytesRemaining) {
                numBytesToRead = (int)numBytesRemaining;
            }
            if ((numBytesRead = (long)stream.read(this.buffer, bufferPos, numBytesToRead)) >= 0L) continue;
            throw new EOFException();
        }
        if (bufferPos > 0) {
            hashStream.putBytes(this.buffer, 0, bufferPos);
        }
    }

    private void skipBytes(InputStream stream, long numBytes) throws IOException {
        long numBytesRemaining = numBytes;
        while (numBytesRemaining > 0L) {
            long numBytesSkipped = stream.skip(numBytesRemaining);
            if (numBytesSkipped == 0L) {
                if (stream.read() < 0) {
                    throw new EOFException();
                }
                --numBytesRemaining;
                continue;
            }
            if (numBytesSkipped <= numBytesRemaining) {
                numBytesRemaining -= numBytesSkipped;
                continue;
            }
            throw new IOException("more bytes skipped than requested");
        }
    }

    @Override
    public HashValue128 hashInputStreamTo128Bits(InputStream inputStream, long length) throws IOException {
        Preconditions.checkArgument(length >= 0L);
        this.hashStream.reset();
        if (length < this.sampleThreshold || this.sampleSize < 1) {
            this.processBytes(length, inputStream, this.hashStream);
        } else {
            this.processBytes(this.sampleSize, inputStream, this.hashStream);
            this.skipBytes(inputStream, length / 2L - (long)this.sampleSize);
            this.processBytes(this.sampleSize, inputStream, this.hashStream);
            this.skipBytes(inputStream, length - length / 2L - 2L * (long)this.sampleSize);
            this.processBytes(this.sampleSize, inputStream, this.hashStream);
        }
        HashValue128 hash = this.hashStream.get();
        long leastSignificantBits = Long.reverseBytes(hash.getLeastSignificantBits());
        long mostSignificantBits = Long.reverseBytes(hash.getMostSignificantBits());
        long l = length;
        long leastSignificantBitsUpdateValue = 0L;
        long leastSignificantBitsUpdateMask = -1L;
        int shift = 0;
        while (l >= 128L) {
            leastSignificantBitsUpdateValue |= ((l | 0x80L) & 0xFFL) << shift;
            leastSignificantBitsUpdateMask <<= 8;
            l >>= 7;
            shift += 8;
        }
        if (shift < 64) {
            leastSignificantBitsUpdateValue |= (l & 0xFFL) << shift;
            leastSignificantBitsUpdateMask <<= 8;
        } else {
            long mostSignificantBitsUpdateValue = l & 0xFFL;
            long mostSignificantBitsUpdateMask = -256L;
            mostSignificantBits &= mostSignificantBitsUpdateMask;
            mostSignificantBits |= mostSignificantBitsUpdateValue;
        }
        leastSignificantBits &= leastSignificantBitsUpdateMask;
        return new HashValue128(mostSignificantBits, leastSignificantBits |= leastSignificantBitsUpdateValue);
    }
}

