/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.HashFunnel;
import com.dynatrace.hash4j.hashing.HashStream;
import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.Hasher64;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.RandomAccess;
import java.util.UUID;
import java.util.function.ToLongFunction;

abstract class AbstractHashStream
implements HashStream {
    private static final int SOFT_MAX_ARRAY_LENGTH = 0x7FFFFFF7;

    AbstractHashStream() {
    }

    @Override
    public HashStream putBoolean(boolean v) {
        this.putByte((byte)(v ? 1 : 0));
        return this;
    }

    @Override
    public HashStream putBooleans(boolean[] x) {
        return this.putBooleans(x, 0, x.length);
    }

    @Override
    public HashStream putBooleans(boolean[] x, int off, int len) {
        for (int i = 0; i < len; ++i) {
            this.putBoolean(x[off + i]);
        }
        return this;
    }

    @Override
    public HashStream putBooleanArray(boolean[] x) {
        return this.putBooleans(x).putInt(x.length);
    }

    @Override
    public HashStream putBytes(byte[] b) {
        this.putBytes(b, 0, b.length);
        return this;
    }

    @Override
    public HashStream putBytes(byte[] b, int off, int len) {
        for (int i = 0; i < len; ++i) {
            this.putByte(b[off + i]);
        }
        return this;
    }

    @Override
    public HashStream putByteArray(byte[] x) {
        return this.putBytes(x).putInt(x.length);
    }

    @Override
    public HashStream putChar(char v) {
        this.putShort((short)v);
        return this;
    }

    @Override
    public HashStream putChars(char[] x) {
        return this.putChars(x, 0, x.length);
    }

    @Override
    public HashStream putChars(char[] x, int off, int len) {
        for (int i = 0; i < len; ++i) {
            this.putChar(x[off + i]);
        }
        return this;
    }

    @Override
    public HashStream putChars(CharSequence s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.putChar(s.charAt(i));
        }
        return this;
    }

    @Override
    public HashStream putCharArray(char[] x) {
        return this.putChars(x).putInt(x.length);
    }

    @Override
    public HashStream putString(String s) {
        this.putChars(s);
        this.putInt(s.length());
        return this;
    }

    @Override
    public HashStream putShort(short v) {
        this.putByte((byte)v);
        this.putByte((byte)(v >>> 8));
        return this;
    }

    @Override
    public HashStream putShortArray(short[] x) {
        return this.putShorts(x).putInt(x.length);
    }

    @Override
    public HashStream putShorts(short[] x) {
        return this.putShorts(x, 0, x.length);
    }

    @Override
    public HashStream putShorts(short[] x, int off, int len) {
        for (int i = 0; i < len; ++i) {
            this.putShort(x[off + i]);
        }
        return this;
    }

    @Override
    public HashStream putInt(int v) {
        this.putByte((byte)v);
        this.putByte((byte)(v >>> 8));
        this.putByte((byte)(v >>> 16));
        this.putByte((byte)(v >>> 24));
        return this;
    }

    @Override
    public HashStream putIntArray(int[] x) {
        return this.putInts(x).putInt(x.length);
    }

    @Override
    public HashStream putInts(int[] x) {
        return this.putInts(x, 0, x.length);
    }

    @Override
    public HashStream putInts(int[] x, int off, int len) {
        for (int i = 0; i < len; ++i) {
            this.putInt(x[off + i]);
        }
        return this;
    }

    @Override
    public HashStream putLong(long v) {
        this.putInt((int)v);
        this.putInt((int)(v >> 32));
        return this;
    }

    @Override
    public HashStream putLongArray(long[] x) {
        return this.putLongs(x).putInt(x.length);
    }

    @Override
    public HashStream putLongs(long[] x) {
        return this.putLongs(x, 0, x.length);
    }

    @Override
    public HashStream putLongs(long[] x, int off, int len) {
        for (int i = 0; i < len; ++i) {
            this.putLong(x[off + i]);
        }
        return this;
    }

    @Override
    public HashStream putFloat(float v) {
        this.putInt(Float.floatToRawIntBits(v));
        return this;
    }

    @Override
    public HashStream putFloats(float[] x) {
        return this.putFloats(x, 0, x.length);
    }

    @Override
    public HashStream putFloats(float[] x, int off, int len) {
        for (int i = 0; i < len; ++i) {
            this.putFloat(x[off + i]);
        }
        return this;
    }

    @Override
    public HashStream putFloatArray(float[] x) {
        return this.putFloats(x).putInt(x.length);
    }

    @Override
    public HashStream putDouble(double v) {
        this.putLong(Double.doubleToRawLongBits(v));
        return this;
    }

    @Override
    public HashStream putDoubleArray(double[] x) {
        return this.putDoubles(x).putInt(x.length);
    }

    @Override
    public HashStream putDoubles(double[] x) {
        return this.putDoubles(x, 0, x.length);
    }

    @Override
    public HashStream putDoubles(double[] x, int off, int len) {
        for (int i = 0; i < len; ++i) {
            this.putDouble(x[off + i]);
        }
        return this;
    }

    @Override
    public HashStream putUUID(UUID uuid) {
        this.putLong(uuid.getLeastSignificantBits());
        this.putLong(uuid.getMostSignificantBits());
        return this;
    }

    @Override
    public <T> HashStream put(T data, HashFunnel<T> funnel) {
        funnel.put(data, this);
        return this;
    }

    @Override
    public <T> HashStream putNullable(T data, HashFunnel<T> funnel) {
        if (data != null) {
            funnel.put(data, this);
            this.putBoolean(true);
        } else {
            this.putBoolean(false);
        }
        return this;
    }

    @Override
    public <T> HashStream putOrderedIterable(Iterable<T> data, HashFunnel<? super T> funnel) {
        int counter = 0;
        for (T d : data) {
            this.put((Object)d, (HashFunnel)funnel);
            ++counter;
        }
        this.putInt(counter);
        return this;
    }

    @Override
    public <T> HashStream putUnorderedIterable(Iterable<T> data, HashFunnel<? super T> funnel, Hasher64 hasher) {
        return this.putUnorderedIterable(data, funnel, hasher.hashStream());
    }

    private <T> HashStream putUnorderedIterable(Iterable<T> data, HashFunnel<? super T> funnel, HashStream64 hashStream) {
        return this.putUnorderedIterable((Iterable)data, (T x) -> hashStream.reset().put(x, funnel).getAsLong());
    }

    @Override
    public <T> HashStream putUnorderedIterable(Iterable<T> data, ToLongFunction<? super T> elementHashFunction) {
        Objects.requireNonNull(data);
        Objects.requireNonNull(elementHashFunction);
        if (data instanceof Collection) {
            if (data instanceof RandomAccess && data instanceof List) {
                this.putUnorderedRandomAccessList((List)data, elementHashFunction);
            } else {
                this.putUnorderedCollection((Collection)data, elementHashFunction);
            }
        } else {
            long[] elementHashes = new long[8];
            int counter = 0;
            for (T d : data) {
                if (counter >= elementHashes.length) {
                    elementHashes = Arrays.copyOf(elementHashes, AbstractHashStream.increaseArraySize(elementHashes.length));
                }
                elementHashes[counter] = elementHashFunction.applyAsLong(d);
                ++counter;
            }
            Arrays.sort(elementHashes, 0, counter);
            this.putLongs(elementHashes, 0, counter);
            this.putInt(counter);
        }
        return this;
    }

    static int increaseArraySize(int currentSize) {
        if (currentSize <= 0x3FFFFFFB) {
            return currentSize << 1;
        }
        if (currentSize < 0x7FFFFFF7) {
            return 0x7FFFFFF7;
        }
        if (currentSize < Integer.MAX_VALUE) {
            return currentSize + 1;
        }
        throw new OutOfMemoryError();
    }

    private void putSorted(long l0, long l1) {
        if (l1 <= l0) {
            long t = l0;
            l0 = l1;
            l1 = t;
        }
        this.putLong(l0);
        this.putLong(l1);
    }

    private void putSorted(long l0, long l1, long l2) {
        long t;
        if (l0 > l1) {
            t = l0;
            l0 = l1;
            l1 = t;
        }
        if (l0 > l2) {
            t = l0;
            l0 = l2;
            l2 = t;
        }
        if (l1 > l2) {
            t = l1;
            l1 = l2;
            l2 = t;
        }
        this.putLong(l0);
        this.putLong(l1);
        this.putLong(l2);
    }

    private void putSorted(long l0, long l1, long l2, long l3) {
        long t;
        if (l0 > l1) {
            t = l0;
            l0 = l1;
            l1 = t;
        }
        if (l2 > l3) {
            t = l2;
            l2 = l3;
            l3 = t;
        }
        if (l0 > l2) {
            t = l0;
            l0 = l2;
            l2 = t;
        }
        if (l1 > l3) {
            t = l1;
            l1 = l3;
            l3 = t;
        }
        if (l1 > l2) {
            t = l1;
            l1 = l2;
            l2 = t;
        }
        this.putLong(l0);
        this.putLong(l1);
        this.putLong(l2);
        this.putLong(l3);
    }

    private void putSorted(long l0, long l1, long l2, long l3, long l4) {
        long t;
        if (l0 > l1) {
            t = l0;
            l0 = l1;
            l1 = t;
        }
        if (l3 > l4) {
            t = l3;
            l3 = l4;
            l4 = t;
        }
        if (l2 > l4) {
            t = l2;
            l2 = l4;
            l4 = t;
        }
        if (l2 > l3) {
            t = l2;
            l2 = l3;
            l3 = t;
        }
        if (l1 > l4) {
            t = l1;
            l1 = l4;
            l4 = t;
        }
        if (l0 > l3) {
            t = l0;
            l0 = l3;
            l3 = t;
        }
        if (l0 > l2) {
            t = l0;
            l0 = l2;
            l2 = t;
        }
        if (l1 > l3) {
            t = l1;
            l1 = l3;
            l3 = t;
        }
        if (l1 > l2) {
            t = l1;
            l1 = l2;
            l2 = t;
        }
        this.putLong(l0);
        this.putLong(l1);
        this.putLong(l2);
        this.putLong(l3);
        this.putLong(l4);
    }

    private void putSorted(long l0, long l1, long l2, long l3, long l4, long l5) {
        long t;
        if (l1 > l2) {
            t = l1;
            l1 = l2;
            l2 = t;
        }
        if (l4 > l5) {
            t = l4;
            l4 = l5;
            l5 = t;
        }
        if (l0 > l2) {
            t = l0;
            l0 = l2;
            l2 = t;
        }
        if (l3 > l5) {
            t = l3;
            l3 = l5;
            l5 = t;
        }
        if (l0 > l1) {
            t = l0;
            l0 = l1;
            l1 = t;
        }
        if (l3 > l4) {
            t = l3;
            l3 = l4;
            l4 = t;
        }
        if (l2 > l5) {
            t = l2;
            l2 = l5;
            l5 = t;
        }
        if (l0 > l3) {
            t = l0;
            l0 = l3;
            l3 = t;
        }
        if (l1 > l4) {
            t = l1;
            l1 = l4;
            l4 = t;
        }
        if (l2 > l4) {
            t = l2;
            l2 = l4;
            l4 = t;
        }
        if (l1 > l3) {
            t = l1;
            l1 = l3;
            l3 = t;
        }
        if (l2 > l3) {
            t = l2;
            l2 = l3;
            l3 = t;
        }
        this.putLong(l0);
        this.putLong(l1);
        this.putLong(l2);
        this.putLong(l3);
        this.putLong(l4);
        this.putLong(l5);
    }

    private void putSorted(long l0, long l1, long l2, long l3, long l4, long l5, long l6) {
        long t;
        if (l1 > l2) {
            t = l1;
            l1 = l2;
            l2 = t;
        }
        if (l3 > l4) {
            t = l3;
            l3 = l4;
            l4 = t;
        }
        if (l5 > l6) {
            t = l5;
            l5 = l6;
            l6 = t;
        }
        if (l0 > l2) {
            t = l0;
            l0 = l2;
            l2 = t;
        }
        if (l3 > l5) {
            t = l3;
            l3 = l5;
            l5 = t;
        }
        if (l4 > l6) {
            t = l4;
            l4 = l6;
            l6 = t;
        }
        if (l0 > l1) {
            t = l0;
            l0 = l1;
            l1 = t;
        }
        if (l4 > l5) {
            t = l4;
            l4 = l5;
            l5 = t;
        }
        if (l2 > l6) {
            t = l2;
            l2 = l6;
            l6 = t;
        }
        if (l0 > l4) {
            t = l0;
            l0 = l4;
            l4 = t;
        }
        if (l1 > l5) {
            t = l1;
            l1 = l5;
            l5 = t;
        }
        if (l0 > l3) {
            t = l0;
            l0 = l3;
            l3 = t;
        }
        if (l2 > l5) {
            t = l2;
            l2 = l5;
            l5 = t;
        }
        if (l1 > l3) {
            t = l1;
            l1 = l3;
            l3 = t;
        }
        if (l2 > l4) {
            t = l2;
            l2 = l4;
            l4 = t;
        }
        if (l2 > l3) {
            t = l2;
            l2 = l3;
            l3 = t;
        }
        this.putLong(l0);
        this.putLong(l1);
        this.putLong(l2);
        this.putLong(l3);
        this.putLong(l4);
        this.putLong(l5);
        this.putLong(l6);
    }

    private void putSorted(long l0, long l1, long l2, long l3, long l4, long l5, long l6, long l7) {
        long t;
        if (l0 > l1) {
            t = l0;
            l0 = l1;
            l1 = t;
        }
        if (l2 > l3) {
            t = l2;
            l2 = l3;
            l3 = t;
        }
        if (l4 > l5) {
            t = l4;
            l4 = l5;
            l5 = t;
        }
        if (l6 > l7) {
            t = l6;
            l6 = l7;
            l7 = t;
        }
        if (l0 > l2) {
            t = l0;
            l0 = l2;
            l2 = t;
        }
        if (l1 > l3) {
            t = l1;
            l1 = l3;
            l3 = t;
        }
        if (l4 > l6) {
            t = l4;
            l4 = l6;
            l6 = t;
        }
        if (l5 > l7) {
            t = l5;
            l5 = l7;
            l7 = t;
        }
        if (l1 > l2) {
            t = l1;
            l1 = l2;
            l2 = t;
        }
        if (l5 > l6) {
            t = l5;
            l5 = l6;
            l6 = t;
        }
        if (l0 > l4) {
            t = l0;
            l0 = l4;
            l4 = t;
        }
        if (l3 > l7) {
            t = l3;
            l3 = l7;
            l7 = t;
        }
        if (l1 > l5) {
            t = l1;
            l1 = l5;
            l5 = t;
        }
        if (l2 > l6) {
            t = l2;
            l2 = l6;
            l6 = t;
        }
        if (l1 > l4) {
            t = l1;
            l1 = l4;
            l4 = t;
        }
        if (l3 > l6) {
            t = l3;
            l3 = l6;
            l6 = t;
        }
        if (l2 > l4) {
            t = l2;
            l2 = l4;
            l4 = t;
        }
        if (l3 > l5) {
            t = l3;
            l3 = l5;
            l5 = t;
        }
        if (l3 > l4) {
            t = l3;
            l3 = l4;
            l4 = t;
        }
        this.putLong(l0);
        this.putLong(l1);
        this.putLong(l2);
        this.putLong(l3);
        this.putLong(l4);
        this.putLong(l5);
        this.putLong(l6);
        this.putLong(l7);
    }

    private void putSorted(long l0, long l1, long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
        long t;
        if (l0 > l1) {
            t = l0;
            l0 = l1;
            l1 = t;
        }
        if (l3 > l4) {
            t = l3;
            l3 = l4;
            l4 = t;
        }
        if (l6 > l7) {
            t = l6;
            l6 = l7;
            l7 = t;
        }
        if (l1 > l2) {
            t = l1;
            l1 = l2;
            l2 = t;
        }
        if (l4 > l5) {
            t = l4;
            l4 = l5;
            l5 = t;
        }
        if (l7 > l8) {
            t = l7;
            l7 = l8;
            l8 = t;
        }
        if (l0 > l1) {
            t = l0;
            l0 = l1;
            l1 = t;
        }
        if (l3 > l4) {
            t = l3;
            l3 = l4;
            l4 = t;
        }
        if (l6 > l7) {
            t = l6;
            l6 = l7;
            l7 = t;
        }
        if (l2 > l5) {
            t = l2;
            l2 = l5;
            l5 = t;
        }
        if (l0 > l3) {
            t = l0;
            l0 = l3;
            l3 = t;
        }
        if (l1 > l4) {
            t = l1;
            l1 = l4;
            l4 = t;
        }
        if (l5 > l8) {
            t = l5;
            l5 = l8;
            l8 = t;
        }
        if (l3 > l6) {
            t = l3;
            l3 = l6;
            l6 = t;
        }
        if (l4 > l7) {
            t = l4;
            l4 = l7;
            l7 = t;
        }
        if (l2 > l5) {
            t = l2;
            l2 = l5;
            l5 = t;
        }
        if (l0 > l3) {
            t = l0;
            l0 = l3;
            l3 = t;
        }
        if (l1 > l4) {
            t = l1;
            l1 = l4;
            l4 = t;
        }
        if (l5 > l7) {
            t = l5;
            l5 = l7;
            l7 = t;
        }
        if (l2 > l6) {
            t = l2;
            l2 = l6;
            l6 = t;
        }
        if (l1 > l3) {
            t = l1;
            l1 = l3;
            l3 = t;
        }
        if (l4 > l6) {
            t = l4;
            l4 = l6;
            l6 = t;
        }
        if (l2 > l4) {
            t = l2;
            l2 = l4;
            l4 = t;
        }
        if (l5 > l6) {
            t = l5;
            l5 = l6;
            l6 = t;
        }
        if (l2 > l3) {
            t = l2;
            l2 = l3;
            l3 = t;
        }
        this.putLong(l0);
        this.putLong(l1);
        this.putLong(l2);
        this.putLong(l3);
        this.putLong(l4);
        this.putLong(l5);
        this.putLong(l6);
        this.putLong(l7);
        this.putLong(l8);
    }

    private void putSorted(long l0, long l1, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9) {
        long t;
        if (l4 > l9) {
            t = l4;
            l4 = l9;
            l9 = t;
        }
        if (l3 > l8) {
            t = l3;
            l3 = l8;
            l8 = t;
        }
        if (l2 > l7) {
            t = l2;
            l2 = l7;
            l7 = t;
        }
        if (l1 > l6) {
            t = l1;
            l1 = l6;
            l6 = t;
        }
        if (l0 > l5) {
            t = l0;
            l0 = l5;
            l5 = t;
        }
        if (l1 > l4) {
            t = l1;
            l1 = l4;
            l4 = t;
        }
        if (l6 > l9) {
            t = l6;
            l6 = l9;
            l9 = t;
        }
        if (l0 > l3) {
            t = l0;
            l0 = l3;
            l3 = t;
        }
        if (l5 > l8) {
            t = l5;
            l5 = l8;
            l8 = t;
        }
        if (l0 > l2) {
            t = l0;
            l0 = l2;
            l2 = t;
        }
        if (l3 > l6) {
            t = l3;
            l3 = l6;
            l6 = t;
        }
        if (l7 > l9) {
            t = l7;
            l7 = l9;
            l9 = t;
        }
        if (l0 > l1) {
            t = l0;
            l0 = l1;
            l1 = t;
        }
        if (l2 > l4) {
            t = l2;
            l2 = l4;
            l4 = t;
        }
        if (l5 > l7) {
            t = l5;
            l5 = l7;
            l7 = t;
        }
        if (l8 > l9) {
            t = l8;
            l8 = l9;
            l9 = t;
        }
        if (l1 > l2) {
            t = l1;
            l1 = l2;
            l2 = t;
        }
        if (l4 > l6) {
            t = l4;
            l4 = l6;
            l6 = t;
        }
        if (l7 > l8) {
            t = l7;
            l7 = l8;
            l8 = t;
        }
        if (l3 > l5) {
            t = l3;
            l3 = l5;
            l5 = t;
        }
        if (l2 > l5) {
            t = l2;
            l2 = l5;
            l5 = t;
        }
        if (l6 > l8) {
            t = l6;
            l6 = l8;
            l8 = t;
        }
        if (l1 > l3) {
            t = l1;
            l1 = l3;
            l3 = t;
        }
        if (l4 > l7) {
            t = l4;
            l4 = l7;
            l7 = t;
        }
        if (l2 > l3) {
            t = l2;
            l2 = l3;
            l3 = t;
        }
        if (l6 > l7) {
            t = l6;
            l6 = l7;
            l7 = t;
        }
        if (l3 > l4) {
            t = l3;
            l3 = l4;
            l4 = t;
        }
        if (l5 > l6) {
            t = l5;
            l5 = l6;
            l6 = t;
        }
        if (l4 > l5) {
            t = l4;
            l4 = l5;
            l5 = t;
        }
        this.putLong(l0);
        this.putLong(l1);
        this.putLong(l2);
        this.putLong(l3);
        this.putLong(l4);
        this.putLong(l5);
        this.putLong(l6);
        this.putLong(l7);
        this.putLong(l8);
        this.putLong(l9);
    }

    private <T> void putUnorderedRandomAccessList(List<T> data, ToLongFunction<? super T> elementHasher) {
        int size = data.size();
        switch (size) {
            case 0: {
                break;
            }
            case 1: {
                long elementHash0 = elementHasher.applyAsLong(data.get(0));
                this.putLong(elementHash0);
                break;
            }
            case 2: {
                long elementHash0 = elementHasher.applyAsLong(data.get(0));
                long elementHash1 = elementHasher.applyAsLong(data.get(1));
                this.putSorted(elementHash0, elementHash1);
                break;
            }
            case 3: {
                long elementHash0 = elementHasher.applyAsLong(data.get(0));
                long elementHash1 = elementHasher.applyAsLong(data.get(1));
                long elementHash2 = elementHasher.applyAsLong(data.get(2));
                this.putSorted(elementHash0, elementHash1, elementHash2);
                break;
            }
            case 4: {
                long elementHash0 = elementHasher.applyAsLong(data.get(0));
                long elementHash1 = elementHasher.applyAsLong(data.get(1));
                long elementHash2 = elementHasher.applyAsLong(data.get(2));
                long elementHash3 = elementHasher.applyAsLong(data.get(3));
                this.putSorted(elementHash0, elementHash1, elementHash2, elementHash3);
                break;
            }
            case 5: {
                long elementHash0 = elementHasher.applyAsLong(data.get(0));
                long elementHash1 = elementHasher.applyAsLong(data.get(1));
                long elementHash2 = elementHasher.applyAsLong(data.get(2));
                long elementHash3 = elementHasher.applyAsLong(data.get(3));
                long elementHash4 = elementHasher.applyAsLong(data.get(4));
                this.putSorted(elementHash0, elementHash1, elementHash2, elementHash3, elementHash4);
                break;
            }
            case 6: {
                long elementHash0 = elementHasher.applyAsLong(data.get(0));
                long elementHash1 = elementHasher.applyAsLong(data.get(1));
                long elementHash2 = elementHasher.applyAsLong(data.get(2));
                long elementHash3 = elementHasher.applyAsLong(data.get(3));
                long elementHash4 = elementHasher.applyAsLong(data.get(4));
                long elementHash5 = elementHasher.applyAsLong(data.get(5));
                this.putSorted(elementHash0, elementHash1, elementHash2, elementHash3, elementHash4, elementHash5);
                break;
            }
            case 7: {
                long elementHash0 = elementHasher.applyAsLong(data.get(0));
                long elementHash1 = elementHasher.applyAsLong(data.get(1));
                long elementHash2 = elementHasher.applyAsLong(data.get(2));
                long elementHash3 = elementHasher.applyAsLong(data.get(3));
                long elementHash4 = elementHasher.applyAsLong(data.get(4));
                long elementHash5 = elementHasher.applyAsLong(data.get(5));
                long elementHash6 = elementHasher.applyAsLong(data.get(6));
                this.putSorted(elementHash0, elementHash1, elementHash2, elementHash3, elementHash4, elementHash5, elementHash6);
                break;
            }
            case 8: {
                long elementHash0 = elementHasher.applyAsLong(data.get(0));
                long elementHash1 = elementHasher.applyAsLong(data.get(1));
                long elementHash2 = elementHasher.applyAsLong(data.get(2));
                long elementHash3 = elementHasher.applyAsLong(data.get(3));
                long elementHash4 = elementHasher.applyAsLong(data.get(4));
                long elementHash5 = elementHasher.applyAsLong(data.get(5));
                long elementHash6 = elementHasher.applyAsLong(data.get(6));
                long elementHash7 = elementHasher.applyAsLong(data.get(7));
                this.putSorted(elementHash0, elementHash1, elementHash2, elementHash3, elementHash4, elementHash5, elementHash6, elementHash7);
                break;
            }
            case 9: {
                long elementHash0 = elementHasher.applyAsLong(data.get(0));
                long elementHash1 = elementHasher.applyAsLong(data.get(1));
                long elementHash2 = elementHasher.applyAsLong(data.get(2));
                long elementHash3 = elementHasher.applyAsLong(data.get(3));
                long elementHash4 = elementHasher.applyAsLong(data.get(4));
                long elementHash5 = elementHasher.applyAsLong(data.get(5));
                long elementHash6 = elementHasher.applyAsLong(data.get(6));
                long elementHash7 = elementHasher.applyAsLong(data.get(7));
                long elementHash8 = elementHasher.applyAsLong(data.get(8));
                this.putSorted(elementHash0, elementHash1, elementHash2, elementHash3, elementHash4, elementHash5, elementHash6, elementHash7, elementHash8);
                break;
            }
            case 10: {
                long elementHash0 = elementHasher.applyAsLong(data.get(0));
                long elementHash1 = elementHasher.applyAsLong(data.get(1));
                long elementHash2 = elementHasher.applyAsLong(data.get(2));
                long elementHash3 = elementHasher.applyAsLong(data.get(3));
                long elementHash4 = elementHasher.applyAsLong(data.get(4));
                long elementHash5 = elementHasher.applyAsLong(data.get(5));
                long elementHash6 = elementHasher.applyAsLong(data.get(6));
                long elementHash7 = elementHasher.applyAsLong(data.get(7));
                long elementHash8 = elementHasher.applyAsLong(data.get(8));
                long elementHash9 = elementHasher.applyAsLong(data.get(9));
                this.putSorted(elementHash0, elementHash1, elementHash2, elementHash3, elementHash4, elementHash5, elementHash6, elementHash7, elementHash8, elementHash9);
                break;
            }
            default: {
                long[] elementHashes = new long[size];
                for (int i = 0; i < size; ++i) {
                    elementHashes[i] = elementHasher.applyAsLong(data.get(i));
                }
                Arrays.sort(elementHashes, 0, size);
                this.putLongs(elementHashes, 0, size);
            }
        }
        this.putInt(size);
    }

    private <T> void putUnorderedCollection(Collection<T> data, ToLongFunction<? super T> elementHasher) {
        int size = data.size();
        switch (size) {
            case 0: {
                break;
            }
            case 1: {
                Iterator<T> it = data.iterator();
                long elementHash0 = elementHasher.applyAsLong(it.next());
                this.putLong(elementHash0);
                break;
            }
            case 2: {
                Iterator<T> it = data.iterator();
                long elementHash0 = elementHasher.applyAsLong(it.next());
                long elementHash1 = elementHasher.applyAsLong(it.next());
                this.putSorted(elementHash0, elementHash1);
                break;
            }
            case 3: {
                Iterator<T> it = data.iterator();
                long elementHash0 = elementHasher.applyAsLong(it.next());
                long elementHash1 = elementHasher.applyAsLong(it.next());
                long elementHash2 = elementHasher.applyAsLong(it.next());
                this.putSorted(elementHash0, elementHash1, elementHash2);
                break;
            }
            case 4: {
                Iterator<T> it = data.iterator();
                long elementHash0 = elementHasher.applyAsLong(it.next());
                long elementHash1 = elementHasher.applyAsLong(it.next());
                long elementHash2 = elementHasher.applyAsLong(it.next());
                long elementHash3 = elementHasher.applyAsLong(it.next());
                this.putSorted(elementHash0, elementHash1, elementHash2, elementHash3);
                break;
            }
            case 5: {
                Iterator<T> it = data.iterator();
                long elementHash0 = elementHasher.applyAsLong(it.next());
                long elementHash1 = elementHasher.applyAsLong(it.next());
                long elementHash2 = elementHasher.applyAsLong(it.next());
                long elementHash3 = elementHasher.applyAsLong(it.next());
                long elementHash4 = elementHasher.applyAsLong(it.next());
                this.putSorted(elementHash0, elementHash1, elementHash2, elementHash3, elementHash4);
                break;
            }
            case 6: {
                Iterator<T> it = data.iterator();
                long elementHash0 = elementHasher.applyAsLong(it.next());
                long elementHash1 = elementHasher.applyAsLong(it.next());
                long elementHash2 = elementHasher.applyAsLong(it.next());
                long elementHash3 = elementHasher.applyAsLong(it.next());
                long elementHash4 = elementHasher.applyAsLong(it.next());
                long elementHash5 = elementHasher.applyAsLong(it.next());
                this.putSorted(elementHash0, elementHash1, elementHash2, elementHash3, elementHash4, elementHash5);
                break;
            }
            case 7: {
                Iterator<T> it = data.iterator();
                long elementHash0 = elementHasher.applyAsLong(it.next());
                long elementHash1 = elementHasher.applyAsLong(it.next());
                long elementHash2 = elementHasher.applyAsLong(it.next());
                long elementHash3 = elementHasher.applyAsLong(it.next());
                long elementHash4 = elementHasher.applyAsLong(it.next());
                long elementHash5 = elementHasher.applyAsLong(it.next());
                long elementHash6 = elementHasher.applyAsLong(it.next());
                this.putSorted(elementHash0, elementHash1, elementHash2, elementHash3, elementHash4, elementHash5, elementHash6);
                break;
            }
            case 8: {
                Iterator<T> it = data.iterator();
                long elementHash0 = elementHasher.applyAsLong(it.next());
                long elementHash1 = elementHasher.applyAsLong(it.next());
                long elementHash2 = elementHasher.applyAsLong(it.next());
                long elementHash3 = elementHasher.applyAsLong(it.next());
                long elementHash4 = elementHasher.applyAsLong(it.next());
                long elementHash5 = elementHasher.applyAsLong(it.next());
                long elementHash6 = elementHasher.applyAsLong(it.next());
                long elementHash7 = elementHasher.applyAsLong(it.next());
                this.putSorted(elementHash0, elementHash1, elementHash2, elementHash3, elementHash4, elementHash5, elementHash6, elementHash7);
                break;
            }
            case 9: {
                Iterator<T> it = data.iterator();
                long elementHash0 = elementHasher.applyAsLong(it.next());
                long elementHash1 = elementHasher.applyAsLong(it.next());
                long elementHash2 = elementHasher.applyAsLong(it.next());
                long elementHash3 = elementHasher.applyAsLong(it.next());
                long elementHash4 = elementHasher.applyAsLong(it.next());
                long elementHash5 = elementHasher.applyAsLong(it.next());
                long elementHash6 = elementHasher.applyAsLong(it.next());
                long elementHash7 = elementHasher.applyAsLong(it.next());
                long elementHash8 = elementHasher.applyAsLong(it.next());
                this.putSorted(elementHash0, elementHash1, elementHash2, elementHash3, elementHash4, elementHash5, elementHash6, elementHash7, elementHash8);
                break;
            }
            case 10: {
                Iterator<T> it = data.iterator();
                long elementHash0 = elementHasher.applyAsLong(it.next());
                long elementHash1 = elementHasher.applyAsLong(it.next());
                long elementHash2 = elementHasher.applyAsLong(it.next());
                long elementHash3 = elementHasher.applyAsLong(it.next());
                long elementHash4 = elementHasher.applyAsLong(it.next());
                long elementHash5 = elementHasher.applyAsLong(it.next());
                long elementHash6 = elementHasher.applyAsLong(it.next());
                long elementHash7 = elementHasher.applyAsLong(it.next());
                long elementHash8 = elementHasher.applyAsLong(it.next());
                long elementHash9 = elementHasher.applyAsLong(it.next());
                this.putSorted(elementHash0, elementHash1, elementHash2, elementHash3, elementHash4, elementHash5, elementHash6, elementHash7, elementHash8, elementHash9);
                break;
            }
            default: {
                Iterator<T> it = data.iterator();
                long[] elementHashes = new long[size];
                for (int i = 0; i < size; ++i) {
                    elementHashes[i] = elementHasher.applyAsLong(it.next());
                }
                Arrays.sort(elementHashes, 0, size);
                this.putLongs(elementHashes, 0, size);
            }
        }
        this.putInt(size);
    }

    @Override
    public <T> HashStream putOptional(Optional<T> obj, HashFunnel<? super T> funnel) {
        if (obj.isPresent()) {
            this.put((Object)obj.get(), (HashFunnel)funnel);
            this.putBoolean(true);
        } else {
            this.putBoolean(false);
        }
        return this;
    }

    @Override
    public HashStream putOptionalInt(OptionalInt v) {
        if (v.isPresent()) {
            this.putInt(v.getAsInt());
            this.putBoolean(true);
        } else {
            this.putBoolean(false);
        }
        return this;
    }

    @Override
    public HashStream putOptionalLong(OptionalLong v) {
        if (v.isPresent()) {
            this.putLong(v.getAsLong());
            this.putBoolean(true);
        } else {
            this.putBoolean(false);
        }
        return this;
    }

    @Override
    public HashStream putOptionalDouble(OptionalDouble v) {
        if (v.isPresent()) {
            this.putDouble(v.getAsDouble());
            this.putBoolean(true);
        } else {
            this.putBoolean(false);
        }
        return this;
    }
}

