/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.AbstractHashStream64;
import com.dynatrace.hash4j.hashing.AbstractHasher;
import com.dynatrace.hash4j.hashing.AbstractHasher64;
import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.UnsignedMultiplyUtil;

abstract class AbstractWyhashFinal
extends AbstractHasher64 {
    protected final long seed;
    protected final long secret1;
    protected final long secret2;
    protected final long secret3;
    protected static final long[] DEFAULT_SECRET = new long[]{-6884282663029611473L, -1800455987208640293L, -8161530843051276573L, 6384245875588680899L};

    protected AbstractWyhashFinal(long seed, long secret1, long secret2, long secret3) {
        this.seed = seed;
        this.secret1 = secret1;
        this.secret2 = secret2;
        this.secret3 = secret3;
    }

    @Override
    public HashStream64 hashStream() {
        return new HashStreamImpl();
    }

    @Override
    public long hashBytesToLong(byte[] input, int off, int len) {
        long b;
        long a;
        long see0 = this.seed;
        if (len <= 16) {
            if (len >= 4) {
                a = AbstractWyhashFinal.wyr4(input, off) << 32 | AbstractWyhashFinal.wyr4(input, off + (len >>> 3 << 2));
                b = AbstractWyhashFinal.wyr4(input, off + len - 4) << 32 | AbstractWyhashFinal.wyr4(input, off + len - 4 - (len >>> 3 << 2));
            } else if (len > 0) {
                a = AbstractWyhashFinal.wyr3(input, off, len);
                b = 0L;
            } else {
                a = 0L;
                b = 0L;
            }
        } else {
            int i;
            int p = off;
            long see1 = this.seed;
            long see2 = this.seed;
            for (i = len; i > 48; i -= 48) {
                see0 = AbstractWyhashFinal.wymix(AbstractWyhashFinal.getLong(input, p) ^ this.secret1, AbstractWyhashFinal.getLong(input, p + 8) ^ see0);
                see1 = AbstractWyhashFinal.wymix(AbstractWyhashFinal.getLong(input, p + 16) ^ this.secret2, AbstractWyhashFinal.getLong(input, p + 24) ^ see1);
                see2 = AbstractWyhashFinal.wymix(AbstractWyhashFinal.getLong(input, p + 32) ^ this.secret3, AbstractWyhashFinal.getLong(input, p + 40) ^ see2);
                p += 48;
            }
            see0 ^= see1 ^ see2;
            while (i > 16) {
                see0 = AbstractWyhashFinal.wymix(AbstractWyhashFinal.getLong(input, p) ^ this.secret1, AbstractWyhashFinal.getLong(input, p + 8) ^ see0);
                i -= 16;
                p += 16;
            }
            a = AbstractWyhashFinal.getLong(input, p + i - 16);
            b = AbstractWyhashFinal.getLong(input, p + i - 8);
        }
        return this.finish(a, b, see0, len);
    }

    protected abstract long finish(long var1, long var3, long var5, long var7);

    @Override
    public long hashCharsToLong(CharSequence input) {
        long b;
        long a;
        int len = input.length();
        long see0 = this.seed;
        if (len <= 8) {
            if (len >= 2) {
                a = (long)AbstractWyhashFinal.getInt(input, 0) << 32 | (long)AbstractWyhashFinal.getInt(input, len >>> 2 << 1) & 0xFFFFFFFFL;
                b = (long)AbstractWyhashFinal.getInt(input, len - 2) << 32 | (long)AbstractWyhashFinal.getInt(input, len - 2 - (len >>> 2 << 1)) & 0xFFFFFFFFL;
            } else if (len > 0) {
                long ch = (long)input.charAt(0) & 0xFFFFL;
                long c0 = ch & 0xFFL;
                long c1 = ch >>> 8;
                a = c0 << 16 | c1 << 8 | c1;
                b = 0L;
            } else {
                a = 0L;
                b = 0L;
            }
        } else {
            int i;
            int p = 0;
            long see1 = this.seed;
            long see2 = this.seed;
            for (i = len; i > 24; i -= 24) {
                see0 = AbstractWyhashFinal.wymix(AbstractWyhashFinal.getLong(input, p) ^ this.secret1, AbstractWyhashFinal.getLong(input, p + 4) ^ see0);
                see1 = AbstractWyhashFinal.wymix(AbstractWyhashFinal.getLong(input, p + 8) ^ this.secret2, AbstractWyhashFinal.getLong(input, p + 12) ^ see1);
                see2 = AbstractWyhashFinal.wymix(AbstractWyhashFinal.getLong(input, p + 16) ^ this.secret3, AbstractWyhashFinal.getLong(input, p + 20) ^ see2);
                p += 24;
            }
            see0 ^= see1 ^ see2;
            while (i > 8) {
                see0 = AbstractWyhashFinal.wymix(AbstractWyhashFinal.getLong(input, p) ^ this.secret1, AbstractWyhashFinal.getLong(input, p + 4) ^ see0);
                i -= 8;
                p += 8;
            }
            a = AbstractWyhashFinal.getLong(input, len - 8);
            b = AbstractWyhashFinal.getLong(input, len - 4);
        }
        return this.finish(a, b, see0, (long)len << 1);
    }

    protected static long wymix(long a, long b) {
        long x = a * b;
        long y = UnsignedMultiplyUtil.unsignedMultiplyHigh(a, b);
        return x ^ y;
    }

    private static long wyr3(byte[] data, int off, int k) {
        return ((long)data[off] & 0xFFL) << 16 | ((long)data[off + (k >>> 1)] & 0xFFL) << 8 | (long)data[off + k - 1] & 0xFFL;
    }

    private static long wyr4(byte[] data, int p) {
        return (long)AbstractWyhashFinal.getInt(data, p) & 0xFFFFFFFFL;
    }

    protected static long[] makeSecret(long seed) {
        long[] secret = new long[4];
        byte[] c = new byte[]{15, 23, 27, 29, 30, 39, 43, 45, 46, 51, 53, 54, 57, 58, 60, 71, 75, 77, 78, 83, 85, 86, 89, 90, 92, 99, 101, 102, 105, 106, 108, 113, 114, 116, 120, -121, -117, -115, -114, -109, -107, -106, -103, -102, -100, -93, -91, -90, -87, -86, -84, -79, -78, -76, -72, -61, -59, -58, -55, -54, -52, -47, -46, -44, -40, -31, -30, -28, -24, -16};
        for (int i = 0; i < 4; ++i) {
            boolean ok;
            block1: do {
                int j;
                ok = true;
                secret[i] = (long)c[(int)Long.remainderUnsigned(AbstractWyhashFinal.wymix(seed += -6884282663029611473L, seed ^ 0xE7037ED1A0B428DBL), c.length)] & 0xFFL;
                if ((secret[i] & 1L) == 0L) {
                    seed += 7150253579921374537L;
                    ok = false;
                    continue;
                }
                for (j = 8; j < 64; j += 8) {
                    int n = i;
                    secret[n] = secret[n] | ((long)c[(int)Long.remainderUnsigned(AbstractWyhashFinal.wymix(seed += -6884282663029611473L, seed ^ 0xE7037ED1A0B428DBL), c.length)] & 0xFFL) << j;
                }
                for (j = 0; j < i; ++j) {
                    if (Long.bitCount(secret[j] ^ secret[i]) == 32) continue;
                    ok = false;
                    continue block1;
                }
            } while (!ok);
        }
        return secret;
    }

    @Override
    public long hashLongLongToLong(long v1, long v2) {
        return this.finish(v1 << 32 | v2 & 0xFFFFFFFFL, v2 & 0xFFFFFFFF00000000L | v1 >>> 32, this.seed, 16L);
    }

    @Override
    public long hashLongLongLongToLong(long v1, long v2, long v3) {
        return this.finish(v2, v3, AbstractWyhashFinal.wymix(v1 ^ this.secret1, v2 ^ this.seed), 24L);
    }

    private class HashStreamImpl
    extends AbstractHashStream64 {
        private final byte[] buffer = new byte[56];
        private long byteCount = 0L;
        private int offset = 0;
        private long see0;
        private long see1;
        private long see2;

        private HashStreamImpl() {
            this.see0 = AbstractWyhashFinal.this.seed;
            this.see1 = AbstractWyhashFinal.this.seed;
            this.see2 = AbstractWyhashFinal.this.seed;
        }

        @Override
        public HashStream64 reset() {
            this.byteCount = 0L;
            this.offset = 0;
            this.see0 = AbstractWyhashFinal.this.seed;
            this.see1 = AbstractWyhashFinal.this.seed;
            this.see2 = AbstractWyhashFinal.this.seed;
            return this;
        }

        @Override
        public HashStream64 putByte(byte v) {
            this.buffer[this.offset] = v;
            ++this.offset;
            ++this.byteCount;
            if (this.offset > 48) {
                this.offset -= 48;
                this.processBuffer();
                this.buffer[0] = this.buffer[48];
            }
            return this;
        }

        @Override
        public HashStream64 putShort(short v) {
            AbstractHasher.setShort(this.buffer, this.offset, v);
            this.offset += 2;
            this.byteCount += 2L;
            if (this.offset > 48) {
                this.offset -= 48;
                this.processBuffer();
                AbstractHasher.setShort(this.buffer, 0, AbstractHasher.getShort(this.buffer, 48));
            }
            return this;
        }

        @Override
        public HashStream64 putChar(char v) {
            AbstractHasher.setChar(this.buffer, this.offset, v);
            this.offset += 2;
            this.byteCount += 2L;
            if (this.offset > 48) {
                this.offset -= 48;
                this.processBuffer();
                AbstractHasher.setChar(this.buffer, 0, AbstractHasher.getChar(this.buffer, 48));
            }
            return this;
        }

        @Override
        public HashStream64 putInt(int v) {
            AbstractHasher.setInt(this.buffer, this.offset, v);
            this.offset += 4;
            this.byteCount += 4L;
            if (this.offset > 48) {
                this.offset -= 48;
                this.processBuffer();
                AbstractHasher.setInt(this.buffer, 0, AbstractHasher.getInt(this.buffer, 48));
            }
            return this;
        }

        @Override
        public HashStream64 putLong(long v) {
            AbstractHasher.setLong(this.buffer, this.offset, v);
            this.offset += 8;
            this.byteCount += 8L;
            if (this.offset > 48) {
                this.offset -= 48;
                this.processBuffer();
                AbstractHasher.setLong(this.buffer, 0, AbstractHasher.getLong(this.buffer, 48));
            }
            return this;
        }

        @Override
        public HashStream64 putBytes(byte[] b, int off, int len) {
            this.byteCount += (long)len;
            int x = 48 - this.offset;
            if (len > x) {
                System.arraycopy(b, off, this.buffer, this.offset, x);
                this.processBuffer();
                int lenOrig = len;
                len -= x;
                off += x;
                while (len > 48) {
                    long b0 = AbstractHasher.getLong(b, off);
                    long b1 = AbstractHasher.getLong(b, off + 8);
                    long b2 = AbstractHasher.getLong(b, off + 16);
                    long b3 = AbstractHasher.getLong(b, off + 24);
                    long b4 = AbstractHasher.getLong(b, off + 32);
                    long b5 = AbstractHasher.getLong(b, off + 40);
                    this.processBuffer(b0, b1, b2, b3, b4, b5);
                    off += 48;
                    len -= 48;
                }
                int y = 16 - len;
                if (lenOrig > 48 && y > 0) {
                    System.arraycopy(b, off - y, this.buffer, 32 + len, y);
                }
                this.offset = 0;
            }
            System.arraycopy(b, off, this.buffer, this.offset, len);
            this.offset += len;
            return this;
        }

        @Override
        public HashStream64 putChars(CharSequence s) {
            int remainingChars = s.length();
            this.byteCount += (long)remainingChars << 1;
            int off = 0;
            if (remainingChars > 48 - this.offset >>> 1) {
                if (this.offset > 1) {
                    while (this.offset < 42) {
                        AbstractHasher.setLong(this.buffer, this.offset, AbstractHasher.getLong(s, off));
                        off += 4;
                        this.offset += 8;
                    }
                    if (this.offset < 46) {
                        AbstractHasher.setInt(this.buffer, this.offset, AbstractHasher.getInt(s, off));
                        off += 2;
                        this.offset += 4;
                    }
                    if (this.offset < 48) {
                        AbstractHasher.setChar(this.buffer, this.offset, s.charAt(off));
                        ++off;
                        this.offset += 2;
                    }
                    remainingChars -= off;
                    this.processBuffer();
                    this.offset &= 1;
                }
                if (this.offset == 0) {
                    if (remainingChars > 24) {
                        long b5;
                        long b4;
                        do {
                            long b0 = AbstractHasher.getLong(s, off);
                            long b1 = AbstractHasher.getLong(s, off + 4);
                            long b2 = AbstractHasher.getLong(s, off + 8);
                            long b3 = AbstractHasher.getLong(s, off + 12);
                            b4 = AbstractHasher.getLong(s, off + 16);
                            b5 = AbstractHasher.getLong(s, off + 20);
                            this.processBuffer(b0, b1, b2, b3, b4, b5);
                            off += 24;
                        } while ((remainingChars -= 24) > 24);
                        AbstractHasher.setLong(this.buffer, 32, b4);
                        AbstractHasher.setLong(this.buffer, 40, b5);
                    }
                } else {
                    long z = (long)this.buffer[off == 0 ? 0 : 48] & 0xFFL;
                    if (remainingChars >= 24) {
                        long b5;
                        long b4;
                        do {
                            long b0 = AbstractHasher.getLong(s, off);
                            long b1 = AbstractHasher.getLong(s, off + 4);
                            long b2 = AbstractHasher.getLong(s, off + 8);
                            long b3 = AbstractHasher.getLong(s, off + 12);
                            b4 = AbstractHasher.getLong(s, off + 16);
                            b5 = AbstractHasher.getLong(s, off + 20);
                            long y = b5 >>> 56;
                            b5 = b4 >>> 56 | b5 << 8;
                            b4 = b3 >>> 56 | b4 << 8;
                            b3 = b2 >>> 56 | b3 << 8;
                            b2 = b1 >>> 56 | b2 << 8;
                            b1 = b0 >>> 56 | b1 << 8;
                            b0 = z | b0 << 8;
                            z = y;
                            this.processBuffer(b0, b1, b2, b3, b4, b5);
                            off += 24;
                        } while ((remainingChars -= 24) >= 24);
                        AbstractHasher.setLong(this.buffer, 32, b4);
                        AbstractHasher.setLong(this.buffer, 40, b5);
                    }
                    this.buffer[0] = (byte)z;
                }
            }
            while (remainingChars >= 4) {
                AbstractHasher.setLong(this.buffer, this.offset, AbstractHasher.getLong(s, off));
                off += 4;
                this.offset += 8;
                remainingChars -= 4;
            }
            if (remainingChars >= 2) {
                AbstractHasher.setInt(this.buffer, this.offset, AbstractHasher.getInt(s, off));
                off += 2;
                this.offset += 4;
                remainingChars -= 2;
            }
            if (remainingChars != 0) {
                AbstractHasher.setChar(this.buffer, this.offset, s.charAt(off));
                this.offset += 2;
            }
            return this;
        }

        private void processBuffer() {
            long b0 = AbstractHasher.getLong(this.buffer, 0);
            long b1 = AbstractHasher.getLong(this.buffer, 8);
            long b2 = AbstractHasher.getLong(this.buffer, 16);
            long b3 = AbstractHasher.getLong(this.buffer, 24);
            long b4 = AbstractHasher.getLong(this.buffer, 32);
            long b5 = AbstractHasher.getLong(this.buffer, 40);
            this.processBuffer(b0, b1, b2, b3, b4, b5);
        }

        private void processBuffer(long b0, long b1, long b2, long b3, long b4, long b5) {
            this.see0 = AbstractWyhashFinal.wymix(b0 ^ AbstractWyhashFinal.this.secret1, b1 ^ this.see0);
            this.see1 = AbstractWyhashFinal.wymix(b2 ^ AbstractWyhashFinal.this.secret2, b3 ^ this.see1);
            this.see2 = AbstractWyhashFinal.wymix(b4 ^ AbstractWyhashFinal.this.secret3, b5 ^ this.see2);
        }

        @Override
        public long getAsLong() {
            long b;
            long a;
            long s = this.see0;
            if (this.byteCount <= 16L) {
                if (this.byteCount >= 4L) {
                    a = AbstractWyhashFinal.wyr4(this.buffer, 0) << 32 | AbstractWyhashFinal.wyr4(this.buffer, this.offset >>> 3 << 2);
                    b = AbstractWyhashFinal.wyr4(this.buffer, this.offset - 4) << 32 | AbstractWyhashFinal.wyr4(this.buffer, this.offset - 4 - (this.offset >>> 3 << 2));
                } else if (this.byteCount > 0L) {
                    a = AbstractWyhashFinal.wyr3(this.buffer, 0, this.offset);
                    b = 0L;
                } else {
                    a = 0L;
                    b = 0L;
                }
            } else {
                s ^= this.see1 ^ this.see2;
                int i = this.offset;
                int p = 0;
                while (i > 16) {
                    s = AbstractWyhashFinal.wymix(AbstractHasher.getLong(this.buffer, p) ^ AbstractWyhashFinal.this.secret1, AbstractHasher.getLong(this.buffer, p + 8) ^ s);
                    i -= 16;
                    p += 16;
                }
                if (this.offset >= 16) {
                    a = AbstractHasher.getLong(this.buffer, this.offset - 16);
                    b = AbstractHasher.getLong(this.buffer, this.offset - 8);
                } else {
                    b = AbstractHasher.getLong(this.buffer, 0);
                    a = AbstractHasher.getLong(this.buffer, 40);
                    int shift = this.offset << 3;
                    if (this.offset > 8) {
                        a = a >>> shift | b << -shift;
                        b = AbstractHasher.getLong(this.buffer, this.offset - 8);
                    } else if (this.offset < 8) {
                        b = a >>> shift | b << -shift;
                        a = AbstractHasher.getLong(this.buffer, this.offset + 32);
                    }
                }
            }
            return AbstractWyhashFinal.this.finish(a, b, s, this.byteCount);
        }
    }
}

