/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.AbstractFarmHash;
import com.dynatrace.hash4j.hashing.AbstractHasher;
import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.Hasher64;

class FarmHashUo
extends AbstractFarmHash {
    private final long seed0;
    private final long seed1;
    private final long mul;
    private final long startX;
    private final long startY;
    private final long startZ;
    private static final FarmHashUo INSTANCE = new FarmHashUo(81L, 0L);

    private FarmHashUo(long seed0, long seed1) {
        this.seed0 = seed0;
        this.seed1 = seed1;
        this.startX = seed0 * -7286425919675154353L;
        this.startY = seed1 * -7286425919675154353L + 113L;
        this.startZ = FarmHashUo.shiftMix(this.startY * -7286425919675154353L) * -7286425919675154353L;
        long u = seed0 - this.startZ;
        this.mul = -7286425919675154353L + (u & 0x82L);
    }

    static Hasher64 create() {
        return INSTANCE;
    }

    static Hasher64 create(final long seed) {
        return new FarmHashUo(0L, seed){

            @Override
            protected long finalizeHash(long hash) {
                return 1.hashLen16(hash - -7286425919675154353L, seed, -7070675565921424023L);
            }
        };
    }

    static Hasher64 create(final long seed0, final long seed1) {
        return new FarmHashUo(seed0, seed1){

            @Override
            protected long finalizeHash(long hash) {
                return 2.hashLen16(hash - seed0, seed1, -7070675565921424023L);
            }
        };
    }

    private static long uoH(long x, long y, long mul, int r) {
        long a = (x ^ y) * mul;
        a = FarmHashUo.shiftMix(a);
        long b = (y ^ a) * mul;
        return Long.rotateRight(b, r) * mul;
    }

    @Override
    public HashStream64 hashStream() {
        return new HashStreamImpl();
    }

    @Override
    protected long hashBytesToLongLength65Plus(byte[] bytes, int offset, int length) {
        long b7;
        long b6;
        long b5;
        long b4;
        long b3;
        long b2;
        long b1;
        long b0;
        long x = this.startX;
        long y = this.startY;
        long z = this.startZ;
        long v0 = this.seed0;
        long v1 = this.seed1;
        long w0 = 0L;
        long w1 = 0L;
        long u = this.seed0 - z;
        int end = offset + (length - 1 & 0xFFFFFFC0);
        int last64offset = offset + length - 64;
        do {
            b0 = FarmHashUo.getLong(bytes, offset);
            b1 = FarmHashUo.getLong(bytes, offset + 8);
            b2 = FarmHashUo.getLong(bytes, offset + 16);
            b3 = FarmHashUo.getLong(bytes, offset + 24);
            b4 = FarmHashUo.getLong(bytes, offset + 32);
            b5 = FarmHashUo.getLong(bytes, offset + 40);
            b6 = FarmHashUo.getLong(bytes, offset + 48);
            b7 = FarmHashUo.getLong(bytes, offset + 56);
            x += b0 + b1;
            y += b2;
            z += b3;
            v0 += b4;
            v1 += b5 + b1;
            w0 += b6;
            w1 += b7;
            x = Long.rotateRight(x, 26);
            y = Long.rotateRight(y, 29);
            z *= this.mul;
            v0 = Long.rotateRight(v0, 33);
            v1 = Long.rotateRight(v1, 30);
            w0 ^= (x *= 9L);
            w0 *= 9L;
            z = Long.rotateRight(z, 32);
            z += w1;
            w1 += z;
            z *= 9L;
            long t = u;
            u = y;
            y = t;
            z += b0 + b6;
            v1 += b3;
            w1 += b5 + b6;
            y += b7;
            y += (v0 += b2);
            v0 += (x += b1) - y;
            v1 += (w0 += b4);
            w0 += v1;
            w1 += x - y;
            x += w1;
            w1 = Long.rotateRight(w1, 34);
            t = u;
            u = z;
            z = t;
        } while ((offset += 64) != end);
        b0 = FarmHashUo.getLong(bytes, last64offset);
        b1 = FarmHashUo.getLong(bytes, last64offset + 8);
        b2 = FarmHashUo.getLong(bytes, last64offset + 16);
        b3 = FarmHashUo.getLong(bytes, last64offset + 24);
        b4 = FarmHashUo.getLong(bytes, last64offset + 32);
        b5 = FarmHashUo.getLong(bytes, last64offset + 40);
        b6 = FarmHashUo.getLong(bytes, last64offset + 48);
        b7 = FarmHashUo.getLong(bytes, last64offset + 56);
        return this.finalizeHash(u, x, y, z, v0, v1, w0 += (long)(length - 1 & 0x3F), w1, b0, b1, b2, b3, b4, b5, b6, b7);
    }

    @Override
    protected long hashCharsToLongLength33Plus(CharSequence input) {
        long b7;
        long b6;
        long b5;
        long b4;
        long b3;
        long b2;
        long b1;
        long b0;
        int len = input.length();
        long x = this.startX;
        long y = this.startY;
        long z = this.startZ;
        long v0 = this.seed0;
        long v1 = this.seed1;
        long w0 = 0L;
        long w1 = 0L;
        long u = this.seed0 - z;
        int end = len - 1 & 0xFFFFFFE0;
        int last64offset = len - 32;
        int offset = 0;
        do {
            b0 = FarmHashUo.getLong(input, offset + 0);
            b1 = FarmHashUo.getLong(input, offset + 4);
            b2 = FarmHashUo.getLong(input, offset + 8);
            b3 = FarmHashUo.getLong(input, offset + 12);
            b4 = FarmHashUo.getLong(input, offset + 16);
            b5 = FarmHashUo.getLong(input, offset + 20);
            b6 = FarmHashUo.getLong(input, offset + 24);
            b7 = FarmHashUo.getLong(input, offset + 28);
            x += b0 + b1;
            y += b2;
            z += b3;
            v0 += b4;
            v1 += b5 + b1;
            w0 += b6;
            w1 += b7;
            x = Long.rotateRight(x, 26);
            y = Long.rotateRight(y, 29);
            z *= this.mul;
            v0 = Long.rotateRight(v0, 33);
            v1 = Long.rotateRight(v1, 30);
            w0 ^= (x *= 9L);
            w0 *= 9L;
            z = Long.rotateRight(z, 32);
            z += w1;
            w1 += z;
            z *= 9L;
            long t = u;
            u = y;
            y = t;
            z += b0 + b6;
            v1 += b3;
            w1 += b5 + b6;
            y += b7;
            y += (v0 += b2);
            v0 += (x += b1) - y;
            v1 += (w0 += b4);
            w0 += v1;
            w1 += x - y;
            x += w1;
            w1 = Long.rotateRight(w1, 34);
            t = u;
            u = z;
            z = t;
        } while ((offset += 32) != end);
        b0 = FarmHashUo.getLong(input, last64offset);
        b1 = FarmHashUo.getLong(input, last64offset + 4);
        b2 = FarmHashUo.getLong(input, last64offset + 8);
        b3 = FarmHashUo.getLong(input, last64offset + 12);
        b4 = FarmHashUo.getLong(input, last64offset + 16);
        b5 = FarmHashUo.getLong(input, last64offset + 20);
        b6 = FarmHashUo.getLong(input, last64offset + 24);
        b7 = FarmHashUo.getLong(input, last64offset + 28);
        return this.finalizeHash(u, x, y, z, v0, v1, w0 += (long)((len << 1) - 1 & 0x3F), w1, b0, b1, b2, b3, b4, b5, b6, b7);
    }

    private long finalizeHash(long u, long x, long y, long z, long v0, long v1, long w0, long w1, long b0, long b1, long b2, long b3, long b4, long b5, long b6, long b7) {
        u *= 9L;
        v1 = Long.rotateRight(v1, 28);
        v0 = Long.rotateRight(v0, 20);
        u += y;
        x = Long.rotateRight((y += u) - x + v0 + b1, 37) * this.mul;
        y = Long.rotateRight(y ^ v1 ^ b6, 42) * this.mul;
        x ^= w1 * 9L;
        y += v0 + b5;
        z = Long.rotateRight(z + w0, 33) * this.mul;
        long c0 = v1 * this.mul + b0;
        long c1 = z + w1 + b4;
        long a0 = c0 + (b1 + b2);
        long a1 = c1 + (b5 + b6);
        return FarmHashUo.uoH(FarmHashUo.hashLen16(a0 + b3 + x, a1 + b7 ^ y, this.mul) + z - u, FarmHashUo.uoH(Long.rotateRight(x + w0 + c0 + b3, 21) + Long.rotateRight(a0, 44) + c0 + y, Long.rotateRight(y + b2 + c1 + b7, 21) + Long.rotateRight(a1, 44) + c1 + z, -7286425919675154353L, 30) ^ x, -7286425919675154353L, 31);
    }

    private class HashStreamImpl
    extends AbstractFarmHash.FarmHashStreamImpl {
        private long x;
        private long y;
        private long z;
        private long v0;
        private long v1;
        private long w0;
        private long w1;
        private long u;

        private HashStreamImpl() {
            this.x = FarmHashUo.this.startX;
            this.y = FarmHashUo.this.startY;
            this.z = FarmHashUo.this.startZ;
            this.v0 = FarmHashUo.this.seed0;
            this.v1 = FarmHashUo.this.seed1;
            this.w0 = 0L;
            this.w1 = 0L;
            this.u = FarmHashUo.this.seed0 - this.z;
        }

        @Override
        public HashStream64 reset() {
            this.x = FarmHashUo.this.startX;
            this.y = FarmHashUo.this.startY;
            this.z = FarmHashUo.this.startZ;
            this.v0 = FarmHashUo.this.seed0;
            this.v1 = FarmHashUo.this.seed1;
            this.w0 = 0L;
            this.w1 = 0L;
            this.u = FarmHashUo.this.seed0 - this.z;
            this.bufferCount = 8;
            this.init = true;
            return this;
        }

        @Override
        protected void processBuffer(long b0, long b1, long b2, long b3, long b4, long b5, long b6, long b7) {
            this.init = false;
            this.x += b0 + b1;
            this.y += b2;
            this.z += b3;
            this.v0 += b4;
            this.v1 += b5 + b1;
            this.w0 += b6;
            this.w1 += b7;
            this.x = Long.rotateRight(this.x, 26);
            this.x *= 9L;
            this.y = Long.rotateRight(this.y, 29);
            this.z *= FarmHashUo.this.mul;
            this.v0 = Long.rotateRight(this.v0, 33);
            this.v1 = Long.rotateRight(this.v1, 30);
            this.w0 ^= this.x;
            this.w0 *= 9L;
            this.z = Long.rotateRight(this.z, 32);
            this.z += this.w1;
            this.w1 += this.z;
            this.z *= 9L;
            long t = this.u;
            this.u = this.y;
            this.y = t;
            this.z += b0 + b6;
            this.v0 += b2;
            this.v1 += b3;
            this.w0 += b4;
            this.w1 += b5 + b6;
            this.x += b1;
            this.y += b7;
            this.y += this.v0;
            this.v0 += this.x - this.y;
            this.v1 += this.w0;
            this.w0 += this.v1;
            this.w1 += this.x - this.y;
            this.x += this.w1;
            this.w1 = Long.rotateRight(this.w1, 34);
            t = this.u;
            this.u = this.z;
            this.z = t;
        }

        @Override
        public long getAsLong() {
            if (this.init) {
                if (this.bufferCount <= 40) {
                    if (this.bufferCount <= 24) {
                        return FarmHashUo.this.finalizeHash(this.hashLen0To16(this.bufferCount));
                    }
                    return FarmHashUo.this.finalizeHash(this.hashLen17To32(this.bufferCount));
                }
                return FarmHashUo.this.finalizeHash(this.hashLen33To64(this.bufferCount));
            }
            AbstractHasher.setLong(this.buffer, 0, AbstractHasher.getLong(this.buffer, 64));
            long b0 = AbstractHasher.getLong(this.buffer, this.bufferCount & 0x3F);
            long b1 = AbstractHasher.getLong(this.buffer, this.bufferCount + 8 & 0x3F);
            long b2 = AbstractHasher.getLong(this.buffer, this.bufferCount + 16 & 0x3F);
            long b3 = AbstractHasher.getLong(this.buffer, this.bufferCount + 24 & 0x3F);
            long b4 = AbstractHasher.getLong(this.buffer, this.bufferCount + 32 & 0x3F);
            long b5 = AbstractHasher.getLong(this.buffer, this.bufferCount + 40 & 0x3F);
            long b6 = AbstractHasher.getLong(this.buffer, this.bufferCount + 48 & 0x3F);
            long b7 = AbstractHasher.getLong(this.buffer, this.bufferCount - 8);
            return FarmHashUo.this.finalizeHash(this.u, this.x, this.y, this.z, this.v0, this.v1, this.w0 + (long)this.bufferCount - 9L, this.w1, b0, b1, b2, b3, b4, b5, b6, b7);
        }
    }
}

