/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.AbstractHashStream128;
import com.dynatrace.hash4j.hashing.AbstractHasher;
import com.dynatrace.hash4j.hashing.AbstractHasher128;
import com.dynatrace.hash4j.hashing.HashStream128;
import com.dynatrace.hash4j.hashing.HashValue128;
import com.dynatrace.hash4j.hashing.Hasher128;

class Murmur3_128
extends AbstractHasher128 {
    private static final long C1 = -8663945395140668459L;
    private static final long C2 = 5545529020109919103L;
    private static final Hasher128 DEFAULT_HASHER_INSTANCE = Murmur3_128.create(0);
    private final long seed;

    static Hasher128 create() {
        return DEFAULT_HASHER_INSTANCE;
    }

    static Hasher128 create(int seed) {
        long longSeed = (long)seed & 0xFFFFFFFFL;
        return new Murmur3_128(longSeed);
    }

    private static long fmix64(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    private static long mixK1(long k1) {
        k1 *= -8663945395140668459L;
        k1 = Long.rotateLeft(k1, 31);
        return k1 *= 5545529020109919103L;
    }

    private static long mixK2(long k2) {
        k2 *= 5545529020109919103L;
        k2 = Long.rotateLeft(k2, 33);
        return k2 *= -8663945395140668459L;
    }

    private static long mixH1(long h1, long h2) {
        h1 = Long.rotateLeft(h1, 27);
        return (h1 += h2) * 5L + 1390208809L;
    }

    private static long mixH2(long h1, long h2) {
        h2 = Long.rotateLeft(h2, 31);
        return (h2 += h1) * 5L + 944331445L;
    }

    private static HashValue128 finalizeHash(long h1, long h2, long byteCount) {
        h1 ^= byteCount;
        h1 += (h2 ^= byteCount);
        h2 += h1;
        h1 = Murmur3_128.fmix64(h1);
        h2 = Murmur3_128.fmix64(h2);
        h1 += h2;
        return new HashValue128(h2 += h1, h1);
    }

    private static long finalizeHashToLong(long h1, long h2, long byteCount) {
        h1 ^= byteCount;
        h1 += (h2 ^= byteCount);
        h2 += h1;
        h1 = Murmur3_128.fmix64(h1);
        h2 = Murmur3_128.fmix64(h2);
        return h1 + h2;
    }

    public Murmur3_128(long seed) {
        this.seed = seed;
    }

    @Override
    public HashStream128 hashStream() {
        return new HashStreamImpl();
    }

    @Override
    public HashValue128 hashBytesTo128Bits(byte[] input, int off, int len) {
        int nblocks = len >>> 4;
        long h1 = this.seed;
        long h2 = this.seed;
        int i = 0;
        while (i < nblocks) {
            long k1 = Murmur3_128.getLong(input, off);
            long k2 = Murmur3_128.getLong(input, off + 8);
            h1 ^= Murmur3_128.mixK1(k1);
            h1 = Murmur3_128.mixH1(h1, h2);
            h2 ^= Murmur3_128.mixK2(k2);
            h2 = Murmur3_128.mixH2(h1, h2);
            ++i;
            off += 16;
        }
        long k1 = 0L;
        long k2 = 0L;
        switch (len & 0xF) {
            case 15: {
                k2 ^= ((long)input[off + 14] & 0xFFL) << 48;
            }
            case 14: {
                k2 ^= ((long)input[off + 13] & 0xFFL) << 40;
            }
            case 13: {
                k2 ^= ((long)input[off + 12] & 0xFFL) << 32;
            }
            case 12: {
                k2 ^= ((long)input[off + 11] & 0xFFL) << 24;
            }
            case 11: {
                k2 ^= ((long)input[off + 10] & 0xFFL) << 16;
            }
            case 10: {
                k2 ^= ((long)input[off + 9] & 0xFFL) << 8;
            }
            case 9: {
                h2 ^= Murmur3_128.mixK2(k2 ^= (long)input[off + 8] & 0xFFL);
            }
            case 8: {
                k1 ^= (long)input[off + 7] << 56;
            }
            case 7: {
                k1 ^= ((long)input[off + 6] & 0xFFL) << 48;
            }
            case 6: {
                k1 ^= ((long)input[off + 5] & 0xFFL) << 40;
            }
            case 5: {
                k1 ^= ((long)input[off + 4] & 0xFFL) << 32;
            }
            case 4: {
                k1 ^= ((long)input[off + 3] & 0xFFL) << 24;
            }
            case 3: {
                k1 ^= ((long)input[off + 2] & 0xFFL) << 16;
            }
            case 2: {
                k1 ^= ((long)input[off + 1] & 0xFFL) << 8;
            }
            case 1: {
                h1 ^= Murmur3_128.mixK1(k1 ^= (long)input[off] & 0xFFL);
            }
        }
        return Murmur3_128.finalizeHash(h1, h2, len);
    }

    @Override
    public HashValue128 hashCharsTo128Bits(CharSequence s) {
        int i;
        long h1 = this.seed;
        long h2 = this.seed;
        int len = s.length();
        for (i = 0; i <= len - 8; i += 8) {
            long b0 = Murmur3_128.getLong(s, i);
            long b1 = Murmur3_128.getLong(s, i + 4);
            h1 ^= Murmur3_128.mixK1(b0);
            h1 = Murmur3_128.mixH1(h1, h2);
            h2 ^= Murmur3_128.mixK2(b1);
            h2 = Murmur3_128.mixH2(h1, h2);
        }
        if (i < len) {
            long buffer0 = s.charAt(i);
            if (i + 1 < len) {
                buffer0 |= (long)s.charAt(i + 1) << 16;
                if (i + 2 < len) {
                    buffer0 |= (long)s.charAt(i + 2) << 32;
                    if (i + 3 < len) {
                        buffer0 |= (long)s.charAt(i + 3) << 48;
                        if (i + 4 < len) {
                            long buffer1 = s.charAt(i + 4);
                            if (i + 5 < len) {
                                buffer1 |= (long)s.charAt(i + 5) << 16;
                                if (i + 6 < len) {
                                    buffer1 |= (long)s.charAt(i + 6) << 32;
                                }
                            }
                            h2 ^= Murmur3_128.mixK2(buffer1);
                        }
                    }
                }
            }
            h1 ^= Murmur3_128.mixK1(buffer0);
        }
        return Murmur3_128.finalizeHash(h1, h2, (long)len << 1);
    }

    @Override
    public long hashLongLongToLong(long v1, long v2) {
        long h1 = this.seed;
        long h2 = this.seed;
        h1 ^= Murmur3_128.mixK1(v1);
        h1 = Murmur3_128.mixH1(h1, h2);
        h2 ^= Murmur3_128.mixK2(v2);
        h2 = Murmur3_128.mixH2(h1, h2);
        return Murmur3_128.finalizeHashToLong(h1, h2, 16L);
    }

    @Override
    public long hashLongLongLongToLong(long v1, long v2, long v3) {
        long h1 = this.seed;
        long h2 = this.seed;
        h1 ^= Murmur3_128.mixK1(v1);
        h1 = Murmur3_128.mixH1(h1, h2);
        h2 ^= Murmur3_128.mixK2(v2);
        h2 = Murmur3_128.mixH2(h1, h2);
        return Murmur3_128.finalizeHashToLong(h1 ^= Murmur3_128.mixK1(v3), h2, 24L);
    }

    private class HashStreamImpl
    extends AbstractHashStream128 {
        private long h1;
        private long h2;
        private long buffer0;
        private long buffer1;
        private long bitCount;

        private HashStreamImpl() {
            this.h1 = Murmur3_128.this.seed;
            this.h2 = Murmur3_128.this.seed;
            this.buffer0 = 0L;
            this.buffer1 = 0L;
            this.bitCount = 0L;
        }

        @Override
        public HashStream128 reset() {
            this.h1 = Murmur3_128.this.seed;
            this.h2 = Murmur3_128.this.seed;
            this.buffer0 = 0L;
            this.buffer1 = 0L;
            this.bitCount = 0L;
            return this;
        }

        @Override
        public HashStream128 putByte(byte b) {
            this.buffer1 |= ((long)b & 0xFFL) << (int)this.bitCount;
            if ((this.bitCount & 0x38L) == 56L) {
                if ((this.bitCount & 0x40L) != 0L) {
                    this.processBuffer(this.buffer0, this.buffer1);
                }
                this.buffer0 = this.buffer1;
                this.buffer1 = 0L;
            }
            this.bitCount += 8L;
            return this;
        }

        @Override
        public HashStream128 putShort(short v) {
            long l = (long)v & 0xFFFFL;
            this.buffer1 |= l << (int)this.bitCount;
            if ((this.bitCount & 0x30L) == 48L) {
                if ((this.bitCount & 0x40L) != 0L) {
                    this.processBuffer(this.buffer0, this.buffer1);
                }
                this.buffer0 = this.buffer1;
                this.buffer1 = l >>> (int)(-this.bitCount);
            }
            this.bitCount += 16L;
            return this;
        }

        @Override
        public HashStream128 putInt(int v) {
            long l = (long)v & 0xFFFFFFFFL;
            this.buffer1 |= l << (int)this.bitCount;
            if ((this.bitCount & 0x20L) != 0L) {
                if ((this.bitCount & 0x40L) != 0L) {
                    this.processBuffer(this.buffer0, this.buffer1);
                }
                this.buffer0 = this.buffer1;
                this.buffer1 = l >>> (int)(-this.bitCount);
            }
            this.bitCount += 32L;
            return this;
        }

        @Override
        public HashStream128 putLong(long l) {
            this.buffer1 |= l << (int)this.bitCount;
            if ((this.bitCount & 0x40L) != 0L) {
                this.processBuffer(this.buffer0, this.buffer1);
            }
            this.buffer0 = this.buffer1;
            this.buffer1 = l >>> 1 >>> (int)(this.bitCount ^ 0xFFFFFFFFFFFFFFFFL);
            this.bitCount += 64L;
            return this;
        }

        @Override
        public HashStream128 putBytes(byte[] b, int off, int len) {
            long oldBitCount = this.bitCount;
            int numWrittenBytes = (int)this.bitCount >>> 3;
            int regularBlockStartIdx = -numWrittenBytes & 0xF;
            int regularBlockEndIdx = len - (len + numWrittenBytes & 0xF);
            this.bitCount += (long)len << 3;
            if (regularBlockEndIdx < regularBlockStartIdx) {
                int z = -numWrittenBytes & 7;
                if (len < z) {
                    for (int x = 0; x < len; ++x) {
                        this.buffer1 |= ((long)b[off + x] & 0xFFL) << (x + numWrittenBytes << 3);
                    }
                } else {
                    int x;
                    if (0 < z) {
                        for (x = 0; x < z; ++x) {
                            this.buffer1 |= ((long)b[off + x] & 0xFFL) << (x + numWrittenBytes << 3);
                        }
                        this.buffer0 = this.buffer1;
                        this.buffer1 = 0L;
                    }
                    for (x = z; x < len; ++x) {
                        this.buffer1 |= ((long)b[off + x] & 0xFFL) << (x + numWrittenBytes << 3);
                    }
                }
                return this;
            }
            if (regularBlockStartIdx > 0) {
                if (regularBlockStartIdx >= 8) {
                    if (regularBlockStartIdx > 8) {
                        this.buffer0 = this.buffer1 | AbstractHasher.getLong(b, off) << (int)oldBitCount;
                    }
                    this.buffer1 = AbstractHasher.getLong(b, off + regularBlockStartIdx - 8);
                } else if (len >= 8) {
                    this.buffer1 |= AbstractHasher.getLong(b, off) << (int)oldBitCount;
                } else if (regularBlockStartIdx >= 4) {
                    if (regularBlockStartIdx >= 5) {
                        if (regularBlockStartIdx >= 6) {
                            if (regularBlockStartIdx >= 7) {
                                this.buffer1 |= ((long)b[off + regularBlockStartIdx - 7] & 0xFFL) << 8;
                            }
                            this.buffer1 |= ((long)b[off + regularBlockStartIdx - 6] & 0xFFL) << 16;
                        }
                        this.buffer1 |= ((long)b[off + regularBlockStartIdx - 5] & 0xFFL) << 24;
                    }
                    this.buffer1 |= (long)AbstractHasher.getInt(b, off + regularBlockStartIdx - 4) << 32;
                } else {
                    if (regularBlockStartIdx >= 2) {
                        if (regularBlockStartIdx >= 3) {
                            this.buffer1 |= ((long)b[off + regularBlockStartIdx - 3] & 0xFFL) << 40;
                        }
                        this.buffer1 |= ((long)b[off + regularBlockStartIdx - 2] & 0xFFL) << 48;
                    }
                    this.buffer1 |= (long)b[off + regularBlockStartIdx - 1] << 56;
                }
                this.processBuffer(this.buffer0, this.buffer1);
                this.buffer1 = 0L;
            }
            for (int i = regularBlockStartIdx; i < regularBlockEndIdx; i += 16) {
                long b0 = AbstractHasher.getLong(b, off + i);
                long b1 = AbstractHasher.getLong(b, off + i + 8);
                this.processBuffer(b0, b1);
            }
            int remainingBytes = len - regularBlockEndIdx;
            int offLen = off + len;
            if (0 < remainingBytes) {
                if (8 <= remainingBytes) {
                    if (8 < remainingBytes) {
                        this.buffer1 = AbstractHasher.getLong(b, offLen - 8) >>> -(remainingBytes << 3);
                    }
                    this.buffer0 = AbstractHasher.getLong(b, offLen - remainingBytes);
                } else if (len >= 8) {
                    this.buffer1 |= AbstractHasher.getLong(b, offLen - 8) >>> -(remainingBytes << 3);
                } else if (3 < remainingBytes) {
                    this.buffer1 |= (long)AbstractHasher.getInt(b, offLen - remainingBytes) & 0xFFFFFFFFL;
                    if (4 < remainingBytes) {
                        this.buffer1 |= ((long)b[offLen - (remainingBytes - 4)] & 0xFFL) << 32;
                        if (5 < remainingBytes) {
                            this.buffer1 |= ((long)b[offLen - (remainingBytes - 5)] & 0xFFL) << 40;
                            if (6 < remainingBytes) {
                                this.buffer1 |= ((long)b[offLen - (remainingBytes - 6)] & 0xFFL) << 48;
                            }
                        }
                    }
                } else {
                    this.buffer1 |= (long)b[offLen - remainingBytes] & 0xFFL;
                    if (1 < remainingBytes) {
                        this.buffer1 |= ((long)b[offLen - (remainingBytes - 1)] & 0xFFL) << 8;
                        if (2 < remainingBytes) {
                            this.buffer1 |= ((long)b[offLen - (remainingBytes - 2)] & 0xFFL) << 16;
                        }
                    }
                }
            }
            return this;
        }

        private void processBuffer(long b0, long b1) {
            this.h1 ^= Murmur3_128.mixK1(b0);
            this.h1 = Murmur3_128.mixH1(this.h1, this.h2);
            this.h2 ^= Murmur3_128.mixK2(b1);
            this.h2 = Murmur3_128.mixH2(this.h1, this.h2);
        }

        @Override
        public HashValue128 get() {
            long g1 = this.h1;
            long g2 = this.h2;
            if ((this.bitCount & 0x7FL) != 0L) {
                this.buffer1 &= -1L >>> (int)(-this.bitCount);
                if ((this.bitCount & 0x40L) == 0L) {
                    g1 ^= Murmur3_128.mixK1(this.buffer1);
                } else {
                    g1 ^= Murmur3_128.mixK1(this.buffer0);
                    g2 ^= Murmur3_128.mixK2(this.buffer1);
                }
            }
            return Murmur3_128.finalizeHash(g1, g2, this.bitCount >>> 3);
        }

        @Override
        public long getAsLong() {
            long g1 = this.h1;
            long g2 = this.h2;
            if ((this.bitCount & 0x7FL) != 0L) {
                this.buffer1 &= -1L >>> (int)(-this.bitCount);
                if ((this.bitCount & 0x40L) == 0L) {
                    g1 ^= Murmur3_128.mixK1(this.buffer1);
                } else {
                    g1 ^= Murmur3_128.mixK1(this.buffer0);
                    g2 ^= Murmur3_128.mixK2(this.buffer1);
                }
            }
            return Murmur3_128.finalizeHashToLong(g1, g2, this.bitCount >>> 3);
        }

        @Override
        public HashStream128 putChars(CharSequence s) {
            int i;
            int len = s.length();
            if (len < (i = 8 - (int)this.bitCount >>> 4 & 7)) {
                for (int j = 0; j < len; ++j) {
                    long l = s.charAt(j);
                    this.buffer1 |= l << (int)this.bitCount;
                    if ((this.bitCount & 0x30L) == 48L) {
                        this.buffer0 = this.buffer1;
                        this.buffer1 = l >>> (int)(-this.bitCount);
                    }
                    this.bitCount += 16L;
                }
                return this;
            }
            if ((this.bitCount & 0xFL) == 0L) {
                if (i - 1 >= 0) {
                    if (i - 2 >= 0) {
                        if (i - 3 >= 0) {
                            if (i - 4 >= 0) {
                                if (i - 5 >= 0) {
                                    if (i - 6 >= 0) {
                                        if (i - 7 >= 0) {
                                            this.buffer1 |= (long)s.charAt(0) << 16;
                                        }
                                        this.buffer1 |= (long)s.charAt(i - 6) << 32;
                                    }
                                    this.buffer1 |= (long)s.charAt(i - 5) << 48;
                                    this.buffer0 = this.buffer1;
                                    this.buffer1 = 0L;
                                }
                                this.buffer1 |= (long)s.charAt(i - 4);
                            }
                            this.buffer1 |= (long)s.charAt(i - 3) << 16;
                        }
                        this.buffer1 |= (long)s.charAt(i - 2) << 32;
                    }
                    this.buffer1 |= (long)s.charAt(i - 1) << 48;
                    this.processBuffer(this.buffer0, this.buffer1);
                    this.buffer1 = 0L;
                }
                while (i <= len - 8) {
                    long b0 = AbstractHasher.getLong(s, i);
                    long b1 = AbstractHasher.getLong(s, i + 4);
                    this.processBuffer(b0, b1);
                    i += 8;
                }
                if (i < len) {
                    this.buffer1 |= (long)s.charAt(i);
                    if (i + 1 < len) {
                        this.buffer1 |= (long)s.charAt(i + 1) << 16;
                        if (i + 2 < len) {
                            this.buffer1 |= (long)s.charAt(i + 2) << 32;
                            if (i + 3 < len) {
                                this.buffer1 |= (long)s.charAt(i + 3) << 48;
                                this.buffer0 = this.buffer1;
                                this.buffer1 = 0L;
                                if (i + 4 < len) {
                                    this.buffer1 |= (long)s.charAt(i + 4);
                                    if (i + 5 < len) {
                                        this.buffer1 |= (long)s.charAt(i + 5) << 16;
                                        if (i + 6 < len) {
                                            this.buffer1 |= (long)s.charAt(i + 6) << 32;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            } else {
                long l;
                if (i - 1 >= 0) {
                    if (i - 2 >= 0) {
                        if (i - 3 >= 0) {
                            if (i - 4 >= 0) {
                                if (i - 5 >= 0) {
                                    if (i - 6 >= 0) {
                                        if (i - 7 >= 0) {
                                            this.buffer1 |= (long)s.charAt(0) << 24;
                                        }
                                        this.buffer1 |= (long)s.charAt(i - 6) << 40;
                                    }
                                    l = s.charAt(i - 5);
                                    this.buffer1 |= l << 56;
                                    this.buffer0 = this.buffer1;
                                    this.buffer1 = l >>> 8;
                                }
                                this.buffer1 |= (long)s.charAt(i - 4) << 8;
                            }
                            this.buffer1 |= (long)s.charAt(i - 3) << 24;
                        }
                        this.buffer1 |= (long)s.charAt(i - 2) << 40;
                    }
                    l = s.charAt(i - 1);
                    this.buffer1 |= l << 56;
                    this.processBuffer(this.buffer0, this.buffer1);
                    this.buffer1 = l >>> 8;
                }
                while (i <= len - 8) {
                    long c0 = s.charAt(i);
                    long c1 = s.charAt(i + 1);
                    long c2 = s.charAt(i + 2);
                    long c3 = s.charAt(i + 3);
                    long c4 = s.charAt(i + 4);
                    long c5 = s.charAt(i + 5);
                    long c6 = s.charAt(i + 6);
                    long c7 = s.charAt(i + 7);
                    long b0 = this.buffer1 | c0 << 8 | c1 << 24 | c2 << 40 | c3 << 56;
                    long b1 = c3 >>> 8 | c4 << 8 | c5 << 24 | c6 << 40 | c7 << 56;
                    this.processBuffer(b0, b1);
                    this.buffer1 = c7 >>> 8;
                    i += 8;
                }
                if (i < len) {
                    this.buffer1 |= (long)s.charAt(i) << 8;
                    if (i + 1 < len) {
                        this.buffer1 |= (long)s.charAt(i + 1) << 24;
                        if (i + 2 < len) {
                            this.buffer1 |= (long)s.charAt(i + 2) << 40;
                            if (i + 3 < len) {
                                l = s.charAt(i + 3);
                                this.buffer1 |= l << 56;
                                this.buffer0 = this.buffer1;
                                this.buffer1 = l >>> 8;
                                if (i + 4 < len) {
                                    this.buffer1 |= (long)s.charAt(i + 4) << 8;
                                    if (i + 5 < len) {
                                        this.buffer1 |= (long)s.charAt(i + 5) << 24;
                                        if (i + 6 < len) {
                                            this.buffer1 |= (long)s.charAt(i + 6) << 40;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            this.bitCount += (long)len << 4;
            return this;
        }

        @Override
        public int getHashBitSize() {
            return 128;
        }
    }
}

