/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.snowflake;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.slice.Slice;
import io.trino.plugin.base.aggregation.AggregateFunctionRewriter;
import io.trino.plugin.base.expression.ConnectorExpressionRewriter;
import io.trino.plugin.base.mapping.IdentifierMapping;
import io.trino.plugin.jdbc.BaseJdbcClient;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.BooleanWriteFunction;
import io.trino.plugin.jdbc.CaseSensitivity;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DoubleWriteFunction;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcSortItem;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.LongWriteFunction;
import io.trino.plugin.jdbc.ObjectReadFunction;
import io.trino.plugin.jdbc.ObjectWriteFunction;
import io.trino.plugin.jdbc.PredicatePushdownController;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.SliceWriteFunction;
import io.trino.plugin.jdbc.StandardColumnMappings;
import io.trino.plugin.jdbc.TypeHandlingJdbcSessionProperties;
import io.trino.plugin.jdbc.UnsupportedTypeHandling;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.plugin.jdbc.aggregation.ImplementAvgDecimal;
import io.trino.plugin.jdbc.aggregation.ImplementAvgFloatingPoint;
import io.trino.plugin.jdbc.aggregation.ImplementCorr;
import io.trino.plugin.jdbc.aggregation.ImplementCount;
import io.trino.plugin.jdbc.aggregation.ImplementCountAll;
import io.trino.plugin.jdbc.aggregation.ImplementCountDistinct;
import io.trino.plugin.jdbc.aggregation.ImplementCovariancePop;
import io.trino.plugin.jdbc.aggregation.ImplementCovarianceSamp;
import io.trino.plugin.jdbc.aggregation.ImplementMinMax;
import io.trino.plugin.jdbc.aggregation.ImplementRegrIntercept;
import io.trino.plugin.jdbc.aggregation.ImplementRegrSlope;
import io.trino.plugin.jdbc.aggregation.ImplementStddevPop;
import io.trino.plugin.jdbc.aggregation.ImplementStddevSamp;
import io.trino.plugin.jdbc.aggregation.ImplementSum;
import io.trino.plugin.jdbc.aggregation.ImplementVariancePop;
import io.trino.plugin.jdbc.aggregation.ImplementVarianceSamp;
import io.trino.plugin.jdbc.expression.JdbcConnectorExpressionRewriterBuilder;
import io.trino.plugin.jdbc.logging.RemoteQueryModifier;
import io.trino.plugin.snowflake.ImplementAvgBigint;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.BiFunction;

public class SnowflakeClient
extends BaseJdbcClient {
    private static final int MAX_SUPPORTED_TEMPORAL_PRECISION = 9;
    private static final DateTimeFormatter SNOWFLAKE_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("u-MM-dd'T'HH:mm:ss.SSSSSSSSSXXX");
    private static final DateTimeFormatter SNOWFLAKE_DATE_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd");
    private static final DateTimeFormatter SNOWFLAKE_TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("u-MM-dd'T'HH:mm:ss.SSSSSSSSS");
    private static final DateTimeFormatter SNOWFLAKE_TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.SSSSSSSSS");
    private static final TimeZone UTC_TZ = TimeZone.getTimeZone(ZoneId.of("UTC"));
    private final AggregateFunctionRewriter<JdbcExpression, ?> aggregateFunctionRewriter;

    @Inject
    public SnowflakeClient(BaseJdbcConfig config, ConnectionFactory connectionFactory, QueryBuilder queryBuilder, IdentifierMapping identifierMapping, RemoteQueryModifier remoteQueryModifier) {
        super("\"", connectionFactory, queryBuilder, config.getJdbcTypesMappedToVarchar(), identifierMapping, remoteQueryModifier, false);
        JdbcTypeHandle bigintTypeHandle = new JdbcTypeHandle(-5, Optional.of("bigint"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        ConnectorExpressionRewriter connectorExpressionRewriter = JdbcConnectorExpressionRewriterBuilder.newBuilder().addStandardRules(arg_0 -> ((SnowflakeClient)this).quoted(arg_0)).build();
        this.aggregateFunctionRewriter = new AggregateFunctionRewriter(connectorExpressionRewriter, (Set)ImmutableSet.builder().add((Object)new ImplementCountAll(bigintTypeHandle)).add((Object)new ImplementCount(bigintTypeHandle)).add((Object)new ImplementCountDistinct(bigintTypeHandle, false)).add((Object)new ImplementMinMax(false)).add((Object)new ImplementSum(SnowflakeClient::decimalTypeHandle)).add((Object)new ImplementAvgFloatingPoint()).add((Object)new ImplementAvgDecimal()).add((Object)new ImplementAvgBigint()).add((Object)new ImplementStddevSamp()).add((Object)new ImplementStddevPop()).add((Object)new ImplementVarianceSamp()).add((Object)new ImplementVariancePop()).add((Object)new ImplementCovarianceSamp()).add((Object)new ImplementCovariancePop()).add((Object)new ImplementCorr()).add((Object)new ImplementRegrIntercept()).add((Object)new ImplementRegrSlope()).build());
    }

    public Optional<ColumnMapping> toColumnMapping(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        Optional mapping = this.getForcedMappingToVarchar(typeHandle);
        if (mapping.isPresent()) {
            return mapping;
        }
        String jdbcTypeName = (String)typeHandle.jdbcTypeName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Type name is missing: " + String.valueOf(typeHandle)));
        jdbcTypeName = jdbcTypeName.toLowerCase(Locale.ENGLISH);
        int type = typeHandle.jdbcType();
        switch (type) {
            case 16: {
                return Optional.of(StandardColumnMappings.booleanColumnMapping());
            }
            case -5: {
                return Optional.of(StandardColumnMappings.bigintColumnMapping());
            }
            case 8: {
                return Optional.of(StandardColumnMappings.doubleColumnMapping());
            }
            case 2: 
            case 3: {
                int precision = typeHandle.requiredColumnSize();
                int scale = typeHandle.requiredDecimalDigits();
                if (precision > 38) break;
                DecimalType decimalType = DecimalType.createDecimalType((int)precision, (int)scale);
                return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)decimalType, (RoundingMode)RoundingMode.UNNECESSARY));
            }
            case 12: {
                if (!jdbcTypeName.equals("varchar")) break;
                return Optional.of(SnowflakeClient.varcharColumnMapping(typeHandle.requiredColumnSize(), typeHandle.caseSensitivity()));
            }
            case -2: {
                if (!jdbcTypeName.equals("binary")) break;
                return Optional.of(StandardColumnMappings.varbinaryColumnMapping());
            }
            case -4: 
            case -3: {
                return Optional.of(StandardColumnMappings.varbinaryColumnMapping());
            }
            case 91: {
                return Optional.of(ColumnMapping.longMapping((Type)DateType.DATE, ResultSet::getLong, (LongWriteFunction)SnowflakeClient.snowFlakeDateWriteFunction()));
            }
            case 92: {
                return Optional.of(SnowflakeClient.timeColumnMapping(typeHandle.requiredDecimalDigits()));
            }
            case 93: {
                return Optional.of(SnowflakeClient.timestampColumnMapping(typeHandle.requiredDecimalDigits()));
            }
            case 2014: {
                return Optional.of(SnowflakeClient.timestampWithTimeZoneColumnMapping(typeHandle.requiredDecimalDigits()));
            }
        }
        if (TypeHandlingJdbcSessionProperties.getUnsupportedTypeHandling((ConnectorSession)session) == UnsupportedTypeHandling.CONVERT_TO_VARCHAR) {
            return SnowflakeClient.mapToUnboundedVarchar((JdbcTypeHandle)typeHandle);
        }
        return Optional.empty();
    }

    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        if (type == BooleanType.BOOLEAN) {
            return WriteMapping.booleanMapping((String)"BOOLEAN", (BooleanWriteFunction)StandardColumnMappings.booleanWriteFunction());
        }
        if (type == TinyintType.TINYINT) {
            return WriteMapping.longMapping((String)"NUMBER(3, 0)", (LongWriteFunction)StandardColumnMappings.tinyintWriteFunction());
        }
        if (type == SmallintType.SMALLINT) {
            return WriteMapping.longMapping((String)"NUMBER(5, 0)", (LongWriteFunction)StandardColumnMappings.smallintWriteFunction());
        }
        if (type == IntegerType.INTEGER) {
            return WriteMapping.longMapping((String)"NUMBER(10, 0)", (LongWriteFunction)StandardColumnMappings.integerWriteFunction());
        }
        if (type == BigintType.BIGINT) {
            return WriteMapping.longMapping((String)"NUMBER(19, 0)", (LongWriteFunction)StandardColumnMappings.bigintWriteFunction());
        }
        if (type == RealType.REAL) {
            return WriteMapping.longMapping((String)"DOUBLE", (LongWriteFunction)StandardColumnMappings.realWriteFunction());
        }
        if (type == DoubleType.DOUBLE) {
            return WriteMapping.doubleMapping((String)"DOUBLE", (DoubleWriteFunction)StandardColumnMappings.doubleWriteFunction());
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            String dataType = String.format("NUMBER(%s, %s)", decimalType.getPrecision(), decimalType.getScale());
            if (decimalType.isShort()) {
                return WriteMapping.longMapping((String)dataType, (LongWriteFunction)StandardColumnMappings.shortDecimalWriteFunction((DecimalType)decimalType));
            }
            return WriteMapping.objectMapping((String)dataType, (ObjectWriteFunction)StandardColumnMappings.longDecimalWriteFunction((DecimalType)decimalType));
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            return WriteMapping.sliceMapping((String)("VARCHAR(" + charType.getLength() + ")"), (SliceWriteFunction)SnowflakeClient.charWriteFunction(charType));
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            Object dataType = varcharType.isUnbounded() ? "VARCHAR" : "VARCHAR(" + varcharType.getBoundedLength() + ")";
            return WriteMapping.sliceMapping((String)dataType, (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction());
        }
        if (type == VarbinaryType.VARBINARY) {
            return WriteMapping.sliceMapping((String)"VARBINARY", (SliceWriteFunction)StandardColumnMappings.varbinaryWriteFunction());
        }
        if (type == DateType.DATE) {
            return WriteMapping.longMapping((String)"DATE", (LongWriteFunction)SnowflakeClient.snowFlakeDateWriteFunction());
        }
        if (type instanceof TimeType) {
            TimeType timeType = (TimeType)type;
            return WriteMapping.longMapping((String)String.format("TIME(%s)", timeType.getPrecision()), (LongWriteFunction)SnowflakeClient.timeWriteFunction(timeType.getPrecision()));
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            return SnowflakeClient.snowflakeTimestampWriteMapping(timestampType.getPrecision());
        }
        if (type instanceof TimestampWithTimeZoneType) {
            TimestampWithTimeZoneType timestampWithTimeZoneType = (TimestampWithTimeZoneType)type;
            return SnowflakeClient.snowflakeTimestampWithTimeZoneWriteMapping(timestampWithTimeZoneType.getPrecision());
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
    }

    public Optional<JdbcExpression> implementAggregation(ConnectorSession session, AggregateFunction aggregate, Map<String, ColumnHandle> assignments) {
        return this.aggregateFunctionRewriter.rewrite(session, aggregate, assignments);
    }

    public boolean supportsAggregationPushdown(ConnectorSession session, JdbcTableHandle table, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        return SnowflakeClient.preventTextualTypeAggregationPushdown(groupingSets);
    }

    private static Optional<JdbcTypeHandle> decimalTypeHandle(DecimalType decimalType) {
        return Optional.of(new JdbcTypeHandle(2, Optional.of("NUMBER"), Optional.of(decimalType.getPrecision()), Optional.of(decimalType.getScale()), Optional.empty(), Optional.empty()));
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.of((sql, limit) -> sql + " LIMIT " + limit);
    }

    public boolean isLimitGuaranteed(ConnectorSession session) {
        return true;
    }

    public boolean supportsTopN(ConnectorSession session, JdbcTableHandle handle, List<JdbcSortItem> sortOrder) {
        for (JdbcSortItem sortItem : sortOrder) {
            Type sortItemType = sortItem.column().getColumnType();
            if (!(sortItemType instanceof CharType) && !(sortItemType instanceof VarcharType)) continue;
            return false;
        }
        return true;
    }

    protected Optional<BaseJdbcClient.TopNFunction> topNFunction() {
        return Optional.of(BaseJdbcClient.TopNFunction.sqlStandard(arg_0 -> ((SnowflakeClient)this).quoted(arg_0)));
    }

    public boolean isTopNGuaranteed(ConnectorSession session) {
        return true;
    }

    public Optional<String> getTableComment(ResultSet resultSet) throws SQLException {
        return Optional.ofNullable(Strings.emptyToNull((String)resultSet.getString("REMARKS")));
    }

    protected List<String> createTableSqls(RemoteTableName remoteTableName, List<String> columns, ConnectorTableMetadata tableMetadata) {
        Preconditions.checkArgument((boolean)tableMetadata.getProperties().isEmpty(), (String)"Unsupported table properties: %s", (Object)tableMetadata.getProperties());
        return ImmutableList.of((Object)String.format("CREATE TABLE %s (%s) COMMENT = %s", this.quoted(remoteTableName), String.join((CharSequence)", ", columns), SnowflakeClient.snowflakeVarcharLiteral(tableMetadata.getComment().orElse(""))));
    }

    public void setTableComment(ConnectorSession session, JdbcTableHandle handle, Optional<String> comment) {
        String sql = "COMMENT ON TABLE %s IS %s".formatted(this.quoted(handle.asPlainTable().getRemoteTableName()), SnowflakeClient.snowflakeVarcharLiteral(comment.orElse("")));
        this.execute(session, sql);
    }

    private static String snowflakeVarcharLiteral(String value) {
        Objects.requireNonNull(value, "value is null");
        return "'" + value.replace("'", "''").replace("\\", "\\\\") + "'";
    }

    public void setColumnType(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column, Type type) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support setting column types");
    }

    private static ColumnMapping timeColumnMapping(int precision) {
        Preconditions.checkArgument((precision <= 9 ? 1 : 0) != 0, (Object)"The max timestamp precision in Snowflake is 9");
        return ColumnMapping.longMapping((Type)TimeType.createTimeType((int)precision), (resultSet, columnIndex) -> {
            LocalTime time = SNOWFLAKE_TIME_FORMATTER.parse((CharSequence)resultSet.getString(columnIndex), LocalTime::from);
            return Timestamps.round((long)(time.toNanoOfDay() * 1000L), (int)(12 - precision));
        }, (LongWriteFunction)SnowflakeClient.timeWriteFunction(precision), (PredicatePushdownController)PredicatePushdownController.FULL_PUSHDOWN);
    }

    private static ColumnMapping timestampWithTimeZoneColumnMapping(int precision) {
        if (precision <= 3) {
            return ColumnMapping.longMapping((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)precision), (resultSet, columnIndex) -> {
                ZonedDateTime timestamp = SNOWFLAKE_DATETIME_FORMATTER.parse((CharSequence)resultSet.getString(columnIndex), ZonedDateTime::from);
                return DateTimeEncoding.packDateTimeWithZone((long)timestamp.toInstant().toEpochMilli(), (String)timestamp.getZone().getId());
            }, (LongWriteFunction)SnowflakeClient.shortTimestampWithTimeZoneWriteFunction(), (PredicatePushdownController)PredicatePushdownController.FULL_PUSHDOWN);
        }
        return ColumnMapping.objectMapping((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)precision), (ObjectReadFunction)SnowflakeClient.longTimestampWithTimezoneReadFunction(), (ObjectWriteFunction)SnowflakeClient.longTimestampWithTimeZoneWriteFunction());
    }

    private static ObjectReadFunction longTimestampWithTimezoneReadFunction() {
        return ObjectReadFunction.of(LongTimestampWithTimeZone.class, (resultSet, columnIndex) -> {
            ZonedDateTime timestamp = SNOWFLAKE_DATETIME_FORMATTER.parse((CharSequence)resultSet.getString(columnIndex), ZonedDateTime::from);
            return LongTimestampWithTimeZone.fromEpochSecondsAndFraction((long)timestamp.toEpochSecond(), (long)((long)timestamp.getNano() * 1000L), (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)timestamp.getZone().getId()));
        });
    }

    private static ColumnMapping timestampColumnMapping(int precision) {
        if (precision <= 6) {
            return ColumnMapping.longMapping((Type)TimestampType.createTimestampType((int)precision), (resultSet, columnIndex) -> StandardColumnMappings.toTrinoTimestamp((TimestampType)TimestampType.createTimestampType((int)precision), (LocalDateTime)SnowflakeClient.toLocalDateTime(resultSet, columnIndex)), (LongWriteFunction)SnowflakeClient.shortTimestampWriteFunction());
        }
        return ColumnMapping.objectMapping((Type)TimestampType.createTimestampType((int)precision), (ObjectReadFunction)SnowflakeClient.longTimestampReader(), (ObjectWriteFunction)SnowflakeClient.longTimestampWriteFunction(precision));
    }

    private static LocalDateTime toLocalDateTime(ResultSet resultSet, int columnIndex) throws SQLException {
        GregorianCalendar calendar = new GregorianCalendar(UTC_TZ, Locale.ENGLISH);
        calendar.setTime(new Date(0L));
        Timestamp ts = resultSet.getTimestamp(columnIndex, (Calendar)calendar);
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(ts.getTime()), ZoneOffset.UTC);
    }

    private static ObjectReadFunction longTimestampReader() {
        return ObjectReadFunction.of(LongTimestamp.class, (resultSet, columnIndex) -> {
            GregorianCalendar calendar = new GregorianCalendar(UTC_TZ, Locale.ENGLISH);
            calendar.setTime(new Date(0L));
            Timestamp ts = resultSet.getTimestamp(columnIndex, (Calendar)calendar);
            long epochMillis = ts.getTime();
            int nanosInTheSecond = ts.getNanos();
            int nanosInTheMilli = nanosInTheSecond % 1000000;
            long micro = epochMillis * 1000L + (long)(nanosInTheMilli / 1000);
            int picosOfMicro = nanosInTheMilli % 1000 * 1000;
            return new LongTimestamp(micro, picosOfMicro);
        });
    }

    private static LongWriteFunction timeWriteFunction(int precision) {
        Preconditions.checkArgument((precision <= 9 ? 1 : 0) != 0, (String)"Unsupported precision: %s", (int)precision);
        return (statement, index, picosOfDay) -> {
            if ((picosOfDay = Timestamps.round((long)picosOfDay, (int)(12 - precision))) == 86400000000000000L) {
                picosOfDay = 0L;
            }
            LocalTime localTime = LocalTime.ofNanoOfDay(picosOfDay / 1000L);
            statement.setString(index, SNOWFLAKE_TIME_FORMATTER.format(localTime));
        };
    }

    private static ColumnMapping varcharColumnMapping(int varcharLength, Optional<CaseSensitivity> caseSensitivity) {
        VarcharType varcharType = varcharLength <= 0x7FFFFFFE ? VarcharType.createVarcharType((int)varcharLength) : VarcharType.createUnboundedVarcharType();
        return StandardColumnMappings.varcharColumnMapping((VarcharType)varcharType, (caseSensitivity.orElse(CaseSensitivity.CASE_INSENSITIVE) == CaseSensitivity.CASE_SENSITIVE ? 1 : 0) != 0);
    }

    private static LongWriteFunction snowFlakeDateWriteFunction() {
        return (statement, index, day) -> statement.setString(index, SNOWFLAKE_DATE_FORMATTER.format(LocalDate.ofEpochDay(day)));
    }

    private static SliceWriteFunction charWriteFunction(CharType charType) {
        return (statement, index, value) -> statement.setString(index, Chars.padSpaces((Slice)value, (CharType)charType).toStringUtf8());
    }

    private static WriteMapping snowflakeTimestampWriteMapping(int precision) {
        Preconditions.checkArgument((precision <= 9 ? 1 : 0) != 0, (Object)"The max timestamp precision in Snowflake is 9");
        if (precision <= 6) {
            return WriteMapping.longMapping((String)String.format("timestamp_ntz(%d)", precision), (LongWriteFunction)SnowflakeClient.shortTimestampWriteFunction());
        }
        return WriteMapping.objectMapping((String)String.format("timestamp_ntz(%d)", precision), (ObjectWriteFunction)SnowflakeClient.longTimestampWriteFunction(precision));
    }

    private static LongWriteFunction shortTimestampWriteFunction() {
        return (statement, index, value) -> statement.setString(index, StandardColumnMappings.fromTrinoTimestamp((long)value).toString());
    }

    private static ObjectWriteFunction longTimestampWriteFunction(int precision) {
        return ObjectWriteFunction.of(LongTimestamp.class, (statement, index, value) -> statement.setString(index, SNOWFLAKE_TIMESTAMP_FORMATTER.format(StandardColumnMappings.fromLongTrinoTimestamp((LongTimestamp)value, (int)precision))));
    }

    private static WriteMapping snowflakeTimestampWithTimeZoneWriteMapping(int precision) {
        Preconditions.checkArgument((precision <= 9 ? 1 : 0) != 0, (Object)"Max Snowflake precision is is 9");
        if (precision <= 3) {
            return WriteMapping.longMapping((String)String.format("timestamp_tz(%d)", precision), (LongWriteFunction)SnowflakeClient.shortTimestampWithTimeZoneWriteFunction());
        }
        return WriteMapping.objectMapping((String)String.format("timestamp_tz(%d)", precision), (ObjectWriteFunction)SnowflakeClient.longTimestampWithTimeZoneWriteFunction());
    }

    private static LongWriteFunction shortTimestampWithTimeZoneWriteFunction() {
        return (statement, index, encodedTimeWithZone) -> {
            Instant instant = Instant.ofEpochMilli(DateTimeEncoding.unpackMillisUtc((long)encodedTimeWithZone));
            ZoneId zone = ZoneId.of(DateTimeEncoding.unpackZoneKey((long)encodedTimeWithZone).getId());
            statement.setString(index, SNOWFLAKE_DATETIME_FORMATTER.format(instant.atZone(zone)));
        };
    }

    private static ObjectWriteFunction longTimestampWithTimeZoneWriteFunction() {
        return ObjectWriteFunction.of(LongTimestampWithTimeZone.class, (statement, index, value) -> {
            long epochMillis = value.getEpochMillis();
            long epochSeconds = Math.floorDiv(epochMillis, 1000);
            long adjustNanoSeconds = (long)Math.floorMod(epochMillis, 1000) * 1000000L + (long)(value.getPicosOfMilli() / 1000);
            ZoneId zone = TimeZoneKey.getTimeZoneKey((short)value.getTimeZoneKey()).getZoneId();
            Instant instant = Instant.ofEpochSecond(epochSeconds, adjustNanoSeconds);
            statement.setString(index, SNOWFLAKE_DATETIME_FORMATTER.format(ZonedDateTime.ofInstant(instant, zone)));
        });
    }
}

