/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.snowflake;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.ConfigBinder;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DriverConnectionFactory;
import io.trino.plugin.jdbc.ForBaseJdbc;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.TypeHandlingJdbcConfig;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.plugin.jdbc.ptf.Query;
import io.trino.plugin.snowflake.SnowflakeClient;
import io.trino.plugin.snowflake.SnowflakeConfig;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.table.ConnectorTableFunction;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.sql.Driver;
import java.util.Properties;
import net.snowflake.client.jdbc.SnowflakeDriver;

public class SnowflakeClientModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(JdbcClient.class).annotatedWith(ForBaseJdbc.class).to(SnowflakeClient.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(SnowflakeConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(TypeHandlingJdbcConfig.class);
        Multibinder.newSetBinder((Binder)binder, ConnectorTableFunction.class).addBinding().toProvider(Query.class).in(Scopes.SINGLETON);
    }

    @Singleton
    @Provides
    @ForBaseJdbc
    public ConnectionFactory getConnectionFactory(BaseJdbcConfig baseJdbcConfig, SnowflakeConfig snowflakeConfig, CredentialProvider credentialProvider, OpenTelemetry openTelemetry) throws MalformedURLException {
        Properties properties = new Properties();
        snowflakeConfig.getAccount().ifPresent(account -> properties.setProperty("account", (String)account));
        snowflakeConfig.getDatabase().ifPresent(database -> properties.setProperty("db", (String)database));
        snowflakeConfig.getRole().ifPresent(role -> properties.setProperty("role", (String)role));
        snowflakeConfig.getWarehouse().ifPresent(warehouse -> properties.setProperty("warehouse", (String)warehouse));
        SnowflakeClientModule.setOutputProperties(properties);
        if (snowflakeConfig.getHttpProxy().isPresent()) {
            String proxy = snowflakeConfig.getHttpProxy().get();
            URL url = URI.create(proxy).toURL();
            properties.setProperty("useProxy", "true");
            properties.setProperty("proxyHost", url.getHost());
            properties.setProperty("proxyPort", Integer.toString(url.getPort()));
            properties.setProperty("proxyProtocol", url.getProtocol());
            String userInfo = url.getUserInfo();
            if (userInfo != null) {
                String[] usernamePassword = userInfo.split(":", 2);
                if (usernamePassword.length != 2) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Improper snowflake.http_proxy. username:password@ is optional but what was entered was not correct");
                }
                properties.setProperty("proxyUser", usernamePassword[0]);
                properties.setProperty("proxyPassword", usernamePassword[1]);
            }
        }
        return DriverConnectionFactory.builder((Driver)new SnowflakeDriver(), (String)baseJdbcConfig.getConnectionUrl(), (CredentialProvider)credentialProvider).setConnectionProperties(properties).setOpenTelemetry(openTelemetry).build();
    }

    protected static void setOutputProperties(Properties properties) {
        properties.setProperty("TIMESTAMP_OUTPUT_FORMAT", "YYYY-MM-DD\"T\"HH24:MI:SS.FF9TZH:TZM");
        properties.setProperty("TIMESTAMP_NTZ_OUTPUT_FORMAT", "YYYY-MM-DD\"T\"HH24:MI:SS.FF9TZH:TZM");
        properties.setProperty("TIMESTAMP_TZ_OUTPUT_FORMAT", "YYYY-MM-DD\"T\"HH24:MI:SS.FF9TZH:TZM");
        properties.setProperty("TIMESTAMP_LTZ_OUTPUT_FORMAT", "YYYY-MM-DD\"T\"HH24:MI:SS.FF9TZH:TZM");
        properties.setProperty("TIME_OUTPUT_FORMAT", "HH24:MI:SS.FF9");
        properties.setProperty("JDBC_TREAT_DECIMAL_AS_INT", "FALSE");
    }
}

