/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowValueBuilder;
import io.trino.spi.block.SqlRow;
import io.trino.spi.type.RowType;
import java.util.List;

public class BufferedRowValueBuilder {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(BufferedRowValueBuilder.class);
    private final int bufferSize;
    private List<BlockBuilder> fieldBuilders;

    public static BufferedRowValueBuilder createBuffered(RowType rowType) {
        return new BufferedRowValueBuilder(rowType, 1024);
    }

    BufferedRowValueBuilder(RowType rowType, int bufferSize) {
        this.bufferSize = bufferSize;
        this.fieldBuilders = rowType.getTypeParameters().stream().map(fieldType -> fieldType.createBlockBuilder(null, bufferSize)).toList();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.fieldBuilders.stream().mapToLong(BlockBuilder::getRetainedSizeInBytes).sum();
    }

    public <E extends Throwable> SqlRow build(RowValueBuilder<E> builder) throws E {
        int expectedSize = this.fieldBuilders.get(0).getPositionCount();
        if (!this.fieldBuilders.stream().allMatch(field -> field.getPositionCount() == expectedSize)) {
            throw new IllegalStateException("Field builders were corrupted by a previous call to buildValue");
        }
        if (this.fieldBuilders.get(0).getPositionCount() + 1 > this.bufferSize) {
            this.fieldBuilders = this.fieldBuilders.stream().map(field -> field.newBlockBuilderLike(this.bufferSize, null)).toList();
        }
        int startSize = this.fieldBuilders.get(0).getPositionCount();
        try {
            builder.build(this.fieldBuilders);
        }
        catch (Exception e) {
            this.equalizeBlockBuilders();
            throw e;
        }
        if (this.equalizeBlockBuilders()) {
            throw new IllegalStateException("Expected field builders to have the same size");
        }
        int endSize = this.fieldBuilders.get(0).getPositionCount();
        if (endSize != startSize + 1) {
            throw new IllegalStateException("Expected exactly one entry added to each field builder");
        }
        List<Block> blocks = this.fieldBuilders.stream().map(field -> field.build().getRegion(startSize, 1)).toList();
        return new SqlRow(0, blocks.toArray(new Block[0]));
    }

    private boolean equalizeBlockBuilders() {
        boolean nullsAppended = false;
        int newBlockSize = this.fieldBuilders.stream().mapToInt(BlockBuilder::getPositionCount).max().orElseThrow();
        for (BlockBuilder fieldBuilder : this.fieldBuilders) {
            while (fieldBuilder.getPositionCount() < newBlockSize) {
                fieldBuilder.appendNull();
                nullsAppended = true;
            }
        }
        return nullsAppended;
    }
}

