/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.Node;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;

public final class ConnectorBucketNodeMap {
    private final int bucketCount;
    private final Optional<List<Node>> bucketToNode;
    private final long cacheKeyHint;

    public static ConnectorBucketNodeMap createBucketNodeMap(int bucketCount) {
        return new ConnectorBucketNodeMap(bucketCount, Optional.empty(), ThreadLocalRandom.current().nextLong());
    }

    public static ConnectorBucketNodeMap createBucketNodeMap(List<Node> bucketToNode) {
        return new ConnectorBucketNodeMap(bucketToNode.size(), Optional.of(bucketToNode), ThreadLocalRandom.current().nextLong());
    }

    private ConnectorBucketNodeMap(int bucketCount, Optional<List<Node>> bucketToNode, long cacheKeyHint) {
        if (bucketCount <= 0) {
            throw new IllegalArgumentException("bucketCount must be positive");
        }
        if (bucketToNode.isPresent() && bucketToNode.get().size() != bucketCount) {
            throw new IllegalArgumentException(String.format("Mismatched bucket count in bucketToNode (%s) and bucketCount (%s)", bucketToNode.get().size(), bucketCount));
        }
        this.bucketCount = bucketCount;
        this.bucketToNode = bucketToNode.map(List::copyOf);
        this.cacheKeyHint = cacheKeyHint;
    }

    public int getBucketCount() {
        return this.bucketCount;
    }

    public boolean hasFixedMapping() {
        return this.bucketToNode.isPresent();
    }

    public List<Node> getFixedMapping() {
        return this.bucketToNode.orElseThrow(() -> new IllegalArgumentException("No fixed bucket to node mapping"));
    }

    public long getCacheKeyHint() {
        return this.cacheKeyHint;
    }

    public ConnectorBucketNodeMap withCacheKeyHint(long cacheKeyHint) {
        return new ConnectorBucketNodeMap(this.bucketCount, this.bucketToNode, cacheKeyHint);
    }
}

