/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.memory;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.QueryId;
import io.trino.spi.memory.MemoryAllocation;
import java.util.List;
import java.util.Map;

public final class MemoryPoolInfo {
    private final long maxBytes;
    private final long reservedBytes;
    private final long reservedRevocableBytes;
    private final Map<QueryId, Long> queryMemoryReservations;
    private final Map<QueryId, List<MemoryAllocation>> queryMemoryAllocations;
    private final Map<QueryId, Long> queryMemoryRevocableReservations;
    private final Map<String, Long> taskMemoryReservations;
    private final Map<String, Long> taskMemoryRevocableReservations;

    @JsonCreator
    public MemoryPoolInfo(@JsonProperty(value="maxBytes") long maxBytes, @JsonProperty(value="reservedBytes") long reservedBytes, @JsonProperty(value="reservedRevocableBytes") long reservedRevocableBytes, @JsonProperty(value="queryMemoryReservations") Map<QueryId, Long> queryMemoryReservations, @JsonProperty(value="queryMemoryAllocations") Map<QueryId, List<MemoryAllocation>> queryMemoryAllocations, @JsonProperty(value="queryMemoryRevocableReservations") Map<QueryId, Long> queryMemoryRevocableReservations, @JsonProperty(value="taskMemoryReservations") Map<String, Long> taskMemoryReservations, @JsonProperty(value="taskMemoryRevocableReservations") Map<String, Long> taskMemoryRevocableReservations) {
        this.maxBytes = maxBytes;
        this.reservedBytes = reservedBytes;
        this.reservedRevocableBytes = reservedRevocableBytes;
        this.queryMemoryReservations = Map.copyOf(queryMemoryReservations);
        this.queryMemoryAllocations = Map.copyOf(queryMemoryAllocations);
        this.queryMemoryRevocableReservations = Map.copyOf(queryMemoryRevocableReservations);
        this.taskMemoryReservations = Map.copyOf(taskMemoryReservations);
        this.taskMemoryRevocableReservations = Map.copyOf(taskMemoryRevocableReservations);
    }

    @JsonProperty
    public long getMaxBytes() {
        return this.maxBytes;
    }

    @JsonProperty
    public long getFreeBytes() {
        return this.maxBytes - this.reservedBytes - this.reservedRevocableBytes;
    }

    @JsonProperty
    public long getReservedBytes() {
        return this.reservedBytes;
    }

    @JsonProperty
    public long getReservedRevocableBytes() {
        return this.reservedRevocableBytes;
    }

    @JsonProperty
    public Map<QueryId, Long> getQueryMemoryReservations() {
        return this.queryMemoryReservations;
    }

    @JsonProperty
    public Map<QueryId, List<MemoryAllocation>> getQueryMemoryAllocations() {
        return this.queryMemoryAllocations;
    }

    @JsonProperty
    public Map<QueryId, Long> getQueryMemoryRevocableReservations() {
        return this.queryMemoryRevocableReservations;
    }

    @JsonProperty
    public Map<String, Long> getTaskMemoryReservations() {
        return this.taskMemoryReservations;
    }

    @JsonProperty
    public Map<String, Long> getTaskMemoryRevocableReservations() {
        return this.taskMemoryRevocableReservations;
    }

    public String toString() {
        return String.format("maxBytes=%s,reservedBytes=%s,reserveRevocableBytes=%s", this.maxBytes, this.reservedBytes, this.reservedRevocableBytes);
    }
}

