/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.type.Timestamps;
import java.util.Objects;

public final class SqlTime {
    private final int precision;
    private final long picos;

    public static SqlTime newInstance(int precision, long picos) {
        if (precision < 0 || precision > 12) {
            throw new IllegalArgumentException("Invalid precision: " + precision);
        }
        if (Timestamps.rescale(Timestamps.rescale(picos, 12, precision), precision, 12) != picos) {
            throw new IllegalArgumentException(String.format("picos contains data beyond specified precision (%s): %s", precision, picos));
        }
        if (picos < 0L || picos >= 86400000000000000L) {
            throw new IllegalArgumentException("picos is out of range: " + picos);
        }
        return new SqlTime(precision, picos);
    }

    private SqlTime(int precision, long picos) {
        this.precision = precision;
        this.picos = picos;
    }

    public long getPicos() {
        return this.picos;
    }

    public SqlTime roundTo(int precision) {
        return new SqlTime(precision, Timestamps.round(this.picos, 12 - precision) % 86400000000000000L);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlTime sqlTime = (SqlTime)o;
        return this.precision == sqlTime.precision && this.picos == sqlTime.picos;
    }

    public int hashCode() {
        return Objects.hash(this.precision, this.picos);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(8 + (this.precision == 0 ? 0 : 1 + this.precision));
        SqlTime.appendTwoDigits((int)(this.picos / 3600000000000000L), builder);
        builder.append(':');
        SqlTime.appendTwoDigits((int)(this.picos / 60000000000000L % 60L), builder);
        builder.append(':');
        SqlTime.appendTwoDigits((int)(this.picos / 1000000000000L % 60L), builder);
        if (this.precision > 0) {
            long scaledFraction = this.picos % 1000000000000L / Timestamps.POWERS_OF_TEN[12 - this.precision];
            builder.append('.');
            builder.setLength(builder.length() + this.precision);
            for (int index = builder.length() - 1; index > 8; --index) {
                long temp = scaledFraction / 10L;
                int digit = (int)(scaledFraction - temp * 10L);
                scaledFraction = temp;
                builder.setCharAt(index, (char)(48 + digit));
            }
        }
        return builder.toString();
    }

    private static void appendTwoDigits(int value, StringBuilder builder) {
        if (value < 10) {
            builder.append('0');
        }
        builder.append(value);
    }
}

