/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.type.Timestamps;
import java.util.Objects;

public final class SqlTimeWithTimeZone {
    private final int precision;
    private final long picos;
    private final int offsetMinutes;

    public static SqlTimeWithTimeZone newInstance(int precision, long picoseconds, int offsetMinutes) {
        if (precision < 0 || precision > 12) {
            throw new IllegalArgumentException("Invalid precision: " + precision);
        }
        if (Timestamps.rescale(Timestamps.rescale(picoseconds, 12, precision), precision, 12) != picoseconds) {
            throw new IllegalArgumentException(String.format("picoseconds contains data beyond specified precision (%s): %s", precision, picoseconds));
        }
        if (picoseconds < 0L || picoseconds >= 86400000000000000L) {
            throw new IllegalArgumentException("picoseconds is out of range: " + picoseconds);
        }
        if (offsetMinutes < -840 || offsetMinutes > 840) {
            throw new IllegalArgumentException("offsetMinutes is out of range: " + offsetMinutes);
        }
        return new SqlTimeWithTimeZone(precision, picoseconds, offsetMinutes);
    }

    private SqlTimeWithTimeZone(int precision, long picos, int offsetMinutes) {
        this.precision = precision;
        this.picos = picos;
        this.offsetMinutes = offsetMinutes;
    }

    public long getPicos() {
        return this.picos;
    }

    public int getOffsetMinutes() {
        return this.offsetMinutes;
    }

    public SqlTimeWithTimeZone roundTo(int precision) {
        return new SqlTimeWithTimeZone(precision, Timestamps.round(this.picos, 12 - precision) % 86400000000000000L, this.offsetMinutes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlTimeWithTimeZone other = (SqlTimeWithTimeZone)o;
        return this.precision == other.precision && this.picos == other.picos && this.offsetMinutes == other.offsetMinutes;
    }

    public int hashCode() {
        return Objects.hash(this.precision, this.picos, this.offsetMinutes);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(14 + (this.precision == 0 ? 0 : 1 + this.precision));
        SqlTimeWithTimeZone.appendTwoDigits((int)(this.picos / 3600000000000000L), builder);
        builder.append(':');
        SqlTimeWithTimeZone.appendTwoDigits((int)(this.picos / 60000000000000L % 60L), builder);
        builder.append(':');
        SqlTimeWithTimeZone.appendTwoDigits((int)(this.picos / 1000000000000L % 60L), builder);
        if (this.precision > 0) {
            long scaledFraction = this.picos % 1000000000000L / Timestamps.POWERS_OF_TEN[12 - this.precision];
            builder.append('.');
            builder.setLength(builder.length() + this.precision);
            for (int index = builder.length() - 1; index > 8; --index) {
                long temp = scaledFraction / 10L;
                int digit = (int)(scaledFraction - temp * 10L);
                scaledFraction = temp;
                builder.setCharAt(index, (char)(48 + digit));
            }
        }
        builder.append(this.offsetMinutes >= 0 ? (char)'+' : '-');
        SqlTimeWithTimeZone.appendTwoDigits(Math.abs(this.offsetMinutes / 60), builder);
        builder.append(':');
        SqlTimeWithTimeZone.appendTwoDigits(Math.abs(this.offsetMinutes % 60), builder);
        return builder.toString();
    }

    private static void appendTwoDigits(int value, StringBuilder builder) {
        if (value < 10) {
            builder.append('0');
        }
        builder.append(value);
    }
}

