/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpch;

import io.trino.tpch.GenerateUtils;
import io.trino.tpch.StringUtils;
import io.trino.tpch.TpchEntity;
import java.util.Objects;

public record Part(long rowNumber, long partKey, String name, String manufacturer, String brand, String type, int size, String container, long retailPriceInCents, String comment) implements TpchEntity
{
    public Part {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(manufacturer, "manufacturer is null");
        Objects.requireNonNull(brand, "brand is null");
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(container, "container is null");
        Objects.requireNonNull(comment, "comment is null");
    }

    public double retailPrice() {
        return (double)this.retailPriceInCents / 100.0;
    }

    @Override
    public String toLine() {
        return StringUtils.buildLine(this.partKey, this.name, this.manufacturer, this.brand, this.type, this.size, this.container, GenerateUtils.formatMoney(this.retailPriceInCents), this.comment);
    }
}

