/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpch;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import io.trino.tpch.Distributions;
import io.trino.tpch.GenerateUtils;
import io.trino.tpch.Part;
import io.trino.tpch.RandomBoundedInt;
import io.trino.tpch.RandomString;
import io.trino.tpch.RandomStringSequence;
import io.trino.tpch.RandomText;
import io.trino.tpch.TextPool;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Supplier;

public class PartGenerator
implements Iterable<Part> {
    public static final int SCALE_BASE = 200000;
    private static final int NAME_WORDS = 5;
    private static final int MANUFACTURER_MIN = 1;
    private static final int MANUFACTURER_MAX = 5;
    private static final int BRAND_MIN = 1;
    private static final int BRAND_MAX = 5;
    private static final int SIZE_MIN = 1;
    private static final int SIZE_MAX = 50;
    private static final int COMMENT_AVERAGE_LENGTH = 14;
    private final double scaleFactor;
    private final int part;
    private final int partCount;
    private final Distributions distributions;
    private final Supplier<TextPool> textPool;

    public PartGenerator(double scaleFactor, int part, int partCount) {
        this(scaleFactor, part, partCount, Distributions.getDefaultDistributions(), TextPool.getDefaultTextPool());
    }

    public PartGenerator(double scaleFactor, int part, int partCount, Distributions distributions, Supplier<TextPool> textPool) {
        Preconditions.checkArgument((scaleFactor > 0.0 ? 1 : 0) != 0, (Object)"scaleFactor must be greater than 0");
        Preconditions.checkArgument((part >= 1 ? 1 : 0) != 0, (Object)"part must be at least 1");
        Preconditions.checkArgument((part <= partCount ? 1 : 0) != 0, (Object)"part must be less than or equal to part count");
        this.scaleFactor = scaleFactor;
        this.part = part;
        this.partCount = partCount;
        this.distributions = Objects.requireNonNull(distributions, "distributions is null");
        this.textPool = Objects.requireNonNull(textPool, "textPool is null");
    }

    @Override
    public Iterator<Part> iterator() {
        return new PartGeneratorIterator(this.distributions, this.textPool.get(), GenerateUtils.calculateStartIndex(200000, this.scaleFactor, this.part, this.partCount), GenerateUtils.calculateRowCount(200000, this.scaleFactor, this.part, this.partCount));
    }

    static long calculatePartPrice(long p) {
        long price = 90000L;
        price += p / 10L % 20001L;
        return price += p % 1000L * 100L;
    }

    private static class PartGeneratorIterator
    extends AbstractIterator<Part> {
        private final RandomStringSequence nameRandom;
        private final RandomBoundedInt manufacturerRandom;
        private final RandomBoundedInt brandRandom;
        private final RandomString typeRandom;
        private final RandomBoundedInt sizeRandom;
        private final RandomString containerRandom;
        private final RandomText commentRandom;
        private final long startIndex;
        private final long rowCount;
        private long index;

        private PartGeneratorIterator(Distributions distributions, TextPool textPool, long startIndex, long rowCount) {
            this.startIndex = startIndex;
            this.rowCount = rowCount;
            this.nameRandom = new RandomStringSequence(709314158L, 5, distributions.getPartColors());
            this.manufacturerRandom = new RandomBoundedInt(1L, 1, 5);
            this.brandRandom = new RandomBoundedInt(46831694L, 1, 5);
            this.typeRandom = new RandomString(1841581359L, distributions.getPartTypes());
            this.sizeRandom = new RandomBoundedInt(1193163244L, 1, 50);
            this.containerRandom = new RandomString(727633698L, distributions.getPartContainers());
            this.commentRandom = new RandomText(804159733L, textPool, 14.0);
            this.nameRandom.advanceRows(startIndex);
            this.manufacturerRandom.advanceRows(startIndex);
            this.brandRandom.advanceRows(startIndex);
            this.typeRandom.advanceRows(startIndex);
            this.sizeRandom.advanceRows(startIndex);
            this.containerRandom.advanceRows(startIndex);
            this.commentRandom.advanceRows(startIndex);
        }

        protected Part computeNext() {
            if (this.index >= this.rowCount) {
                return (Part)this.endOfData();
            }
            Part part = this.makePart(this.startIndex + this.index + 1L);
            this.nameRandom.rowFinished();
            this.manufacturerRandom.rowFinished();
            this.brandRandom.rowFinished();
            this.typeRandom.rowFinished();
            this.sizeRandom.rowFinished();
            this.containerRandom.rowFinished();
            this.commentRandom.rowFinished();
            ++this.index;
            return part;
        }

        private Part makePart(long partKey) {
            String name = this.nameRandom.nextValue();
            int manufacturer = this.manufacturerRandom.nextValue();
            int brand = manufacturer * 10 + this.brandRandom.nextValue();
            return new Part(partKey, partKey, name, "Manufacturer#" + manufacturer, "Brand#" + brand, this.typeRandom.nextValue(), this.sizeRandom.nextValue(), this.containerRandom.nextValue(), PartGenerator.calculatePartPrice(partKey), this.commentRandom.nextValue());
        }
    }
}

