/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpch;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import io.trino.tpch.Distributions;
import io.trino.tpch.GenerateUtils;
import io.trino.tpch.RandomAlphaNumeric;
import io.trino.tpch.RandomBoundedInt;
import io.trino.tpch.RandomInt;
import io.trino.tpch.RandomPhoneNumber;
import io.trino.tpch.RandomText;
import io.trino.tpch.StringUtils;
import io.trino.tpch.Supplier;
import io.trino.tpch.TextPool;
import java.util.Iterator;
import java.util.Objects;

public class SupplierGenerator
implements Iterable<Supplier> {
    public static final int SCALE_BASE = 10000;
    private static final int ACCOUNT_BALANCE_MIN = -99999;
    private static final int ACCOUNT_BALANCE_MAX = 999999;
    private static final int ADDRESS_AVERAGE_LENGTH = 25;
    private static final int COMMENT_AVERAGE_LENGTH = 63;
    public static final String BBB_BASE_TEXT = "Customer ";
    public static final String BBB_COMPLAINT_TEXT = "Complaints";
    public static final String BBB_RECOMMEND_TEXT = "Recommends";
    public static final int BBB_COMMENT_LENGTH = "Customer ".length() + "Complaints".length();
    public static final int BBB_COMMENTS_PER_SCALE_BASE = 10;
    public static final int BBB_COMPLAINT_PERCENT = 50;
    private final double scaleFactor;
    private final int part;
    private final int partCount;
    private final Distributions distributions;
    private final java.util.function.Supplier<TextPool> textPool;

    public SupplierGenerator(double scaleFactor, int part, int partCount) {
        this(scaleFactor, part, partCount, Distributions.getDefaultDistributions(), TextPool.getDefaultTextPool());
    }

    public SupplierGenerator(double scaleFactor, int part, int partCount, Distributions distributions, java.util.function.Supplier<TextPool> textPool) {
        Preconditions.checkArgument((scaleFactor > 0.0 ? 1 : 0) != 0, (Object)"scaleFactor must be greater than 0");
        Preconditions.checkArgument((part >= 1 ? 1 : 0) != 0, (Object)"part must be at least 1");
        Preconditions.checkArgument((part <= partCount ? 1 : 0) != 0, (Object)"part must be less than or equal to part count");
        this.scaleFactor = scaleFactor;
        this.part = part;
        this.partCount = partCount;
        this.distributions = Objects.requireNonNull(distributions, "distributions is null");
        this.textPool = Objects.requireNonNull(textPool, "textPool is null");
    }

    @Override
    public Iterator<Supplier> iterator() {
        return new SupplierGeneratorIterator(this.distributions, this.textPool.get(), GenerateUtils.calculateStartIndex(10000, this.scaleFactor, this.part, this.partCount), GenerateUtils.calculateRowCount(10000, this.scaleFactor, this.part, this.partCount));
    }

    private static class SupplierGeneratorIterator
    extends AbstractIterator<Supplier> {
        private final RandomAlphaNumeric addressRandom = new RandomAlphaNumeric(706178559L, 25);
        private final RandomBoundedInt nationKeyRandom;
        private final RandomPhoneNumber phoneRandom = new RandomPhoneNumber(884434366L);
        private final RandomBoundedInt accountBalanceRandom = new RandomBoundedInt(962338209L, -99999, 999999);
        private final RandomText commentRandom;
        private final RandomBoundedInt bbbCommentRandom = new RandomBoundedInt(202794285L, 1, 10000);
        private final RandomInt bbbJunkRandom = new RandomInt(263032577L, 1);
        private final RandomInt bbbOffsetRandom = new RandomInt(715851524L, 1);
        private final RandomBoundedInt bbbTypeRandom = new RandomBoundedInt(753643799L, 0, 100);
        private final long startIndex;
        private final long rowCount;
        private long index;

        private SupplierGeneratorIterator(Distributions distributions, TextPool textPool, long startIndex, long rowCount) {
            this.startIndex = startIndex;
            this.rowCount = rowCount;
            this.nationKeyRandom = new RandomBoundedInt(110356601L, 0, distributions.getNations().size() - 1);
            this.commentRandom = new RandomText(1341315363L, textPool, 63.0);
            this.addressRandom.advanceRows(startIndex);
            this.nationKeyRandom.advanceRows(startIndex);
            this.phoneRandom.advanceRows(startIndex);
            this.accountBalanceRandom.advanceRows(startIndex);
            this.commentRandom.advanceRows(startIndex);
            this.bbbCommentRandom.advanceRows(startIndex);
            this.bbbJunkRandom.advanceRows(startIndex);
            this.bbbOffsetRandom.advanceRows(startIndex);
            this.bbbTypeRandom.advanceRows(startIndex);
        }

        protected Supplier computeNext() {
            if (this.index >= this.rowCount) {
                return (Supplier)this.endOfData();
            }
            Supplier supplier = this.makeSupplier(this.startIndex + this.index + 1L);
            this.addressRandom.rowFinished();
            this.nationKeyRandom.rowFinished();
            this.phoneRandom.rowFinished();
            this.accountBalanceRandom.rowFinished();
            this.commentRandom.rowFinished();
            this.bbbCommentRandom.rowFinished();
            this.bbbJunkRandom.rowFinished();
            this.bbbOffsetRandom.rowFinished();
            this.bbbTypeRandom.rowFinished();
            ++this.index;
            return supplier;
        }

        private Supplier makeSupplier(long supplierKey) {
            String comment = this.commentRandom.nextValue();
            int bbbCommentRandomValue = this.bbbCommentRandom.nextValue();
            if (bbbCommentRandomValue <= 10) {
                StringBuilder buffer = new StringBuilder(comment);
                int noise = this.bbbJunkRandom.nextInt(0, comment.length() - BBB_COMMENT_LENGTH);
                int offset = this.bbbOffsetRandom.nextInt(0, comment.length() - (BBB_COMMENT_LENGTH + noise));
                String type = this.bbbTypeRandom.nextValue() < 50 ? SupplierGenerator.BBB_COMPLAINT_TEXT : SupplierGenerator.BBB_RECOMMEND_TEXT;
                buffer.replace(offset, offset + SupplierGenerator.BBB_BASE_TEXT.length(), SupplierGenerator.BBB_BASE_TEXT);
                buffer.replace(SupplierGenerator.BBB_BASE_TEXT.length() + offset + noise, SupplierGenerator.BBB_BASE_TEXT.length() + offset + noise + type.length(), type);
                comment = buffer.toString();
            }
            long nationKey = this.nationKeyRandom.nextValue();
            return new Supplier(supplierKey, supplierKey, "Supplier#" + StringUtils.padWithZeros(supplierKey, 9), this.addressRandom.nextValue(), nationKey, this.phoneRandom.nextValue(nationKey), this.accountBalanceRandom.nextValue(), comment);
        }
    }
}

