/*
 * Decompiled with CFR 0.152.
 */
package xerial.larray.buffer;

import java.lang.ref.ReferenceQueue;
import xerial.larray.buffer.Memory;
import xerial.larray.buffer.MemoryReference;
import xerial.larray.buffer.OffHeapMemoryReference;
import xerial.larray.buffer.UnsafeUtil;

public class OffHeapMemory
implements Memory {
    private final long _data;
    public static long HEADER_SIZE = 8L;

    public OffHeapMemory() {
        this._data = 0L;
    }

    public OffHeapMemory(long l) {
        this._data = l != 0L ? l + HEADER_SIZE : 0L;
    }

    public OffHeapMemory(long l, long l2) {
        if (l != 0L) {
            this._data = l + HEADER_SIZE;
            UnsafeUtil.unsafe.putLong(l, l2);
        } else {
            this._data = 0L;
        }
    }

    @Override
    public long headerAddress() {
        return this._data - HEADER_SIZE;
    }

    @Override
    public long size() {
        return this._data == 0L ? 0L : UnsafeUtil.unsafe.getLong(this.headerAddress()) + HEADER_SIZE;
    }

    @Override
    public long address() {
        return this._data;
    }

    @Override
    public long dataSize() {
        return this._data == 0L ? 0L : UnsafeUtil.unsafe.getLong(this.headerAddress());
    }

    @Override
    public MemoryReference toRef(ReferenceQueue<Memory> referenceQueue) {
        return new OffHeapMemoryReference(this, referenceQueue);
    }

    @Override
    public void release() {
        if (this._data != 0L) {
            UnsafeUtil.unsafe.freeMemory(this.headerAddress());
        }
    }
}

