/*
 * Decompiled with CFR 0.152.
 */
package xerial.larray.buffer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import xerial.larray.buffer.LBuffer;
import xerial.larray.buffer.UnsafeUtil;

class WritableChannelWrap
implements WritableByteChannel {
    private final LBuffer b;
    int cursor = 0;

    WritableChannelWrap(LBuffer lBuffer) {
        this.b = lBuffer;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        int n = Math.max(byteBuffer.limit() - byteBuffer.position(), 0);
        int n2 = 0;
        if (byteBuffer.isDirect()) {
            byteBuffer.put(this.b.toDirectByteBuffer(this.cursor, n));
            n2 = n;
        } else if (byteBuffer.hasArray()) {
            n2 = this.b.readFrom(byteBuffer.array(), byteBuffer.position(), this.cursor, n);
        } else {
            for (long i = 0L; i < (long)n; ++i) {
                UnsafeUtil.unsafe.putByte(this.b.address() + i, byteBuffer.get((int)((long)byteBuffer.position() + i)));
            }
            n2 = n;
        }
        this.cursor += n2;
        byteBuffer.position(byteBuffer.position() + n2);
        return n2;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }
}

