/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.password.ldap;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.units.Duration;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class LdapAuthenticatorConfig {
    private List<String> userBindSearchPatterns = ImmutableList.of();
    private String groupAuthorizationSearchPattern;
    private String userBaseDistinguishedName;
    private String bindDistinguishedName;
    private String bindPassword;
    private Duration ldapCacheTtl = new Duration(1.0, TimeUnit.HOURS);

    @NotNull
    public List<String> getUserBindSearchPatterns() {
        return this.userBindSearchPatterns;
    }

    public LdapAuthenticatorConfig setUserBindSearchPatterns(List<String> userBindSearchPatterns) {
        this.userBindSearchPatterns = Objects.requireNonNull(userBindSearchPatterns, "userBindSearchPatterns is null");
        return this;
    }

    @Config(value="ldap.user-bind-pattern")
    @ConfigDescription(value="Custom user bind pattern. Example: ${USER}@example.com")
    public LdapAuthenticatorConfig setUserBindSearchPatterns(String userBindSearchPatterns) {
        this.userBindSearchPatterns = Splitter.on((String)":").trimResults().omitEmptyStrings().splitToList((CharSequence)userBindSearchPatterns);
        return this;
    }

    public String getGroupAuthorizationSearchPattern() {
        return this.groupAuthorizationSearchPattern;
    }

    @Config(value="ldap.group-auth-pattern")
    @ConfigDescription(value="Custom group authorization check query. Example: &(objectClass=user)(memberOf=cn=group)(user=username)")
    public LdapAuthenticatorConfig setGroupAuthorizationSearchPattern(String groupAuthorizationSearchPattern) {
        this.groupAuthorizationSearchPattern = groupAuthorizationSearchPattern;
        return this;
    }

    public String getUserBaseDistinguishedName() {
        return this.userBaseDistinguishedName;
    }

    @Config(value="ldap.user-base-dn")
    @ConfigDescription(value="Base distinguished name of the user. Example: dc=example,dc=com")
    public LdapAuthenticatorConfig setUserBaseDistinguishedName(String userBaseDistinguishedName) {
        this.userBaseDistinguishedName = userBaseDistinguishedName;
        return this;
    }

    public String getBindDistinguishedName() {
        return this.bindDistinguishedName;
    }

    @Config(value="ldap.bind-dn")
    @ConfigDescription(value="Bind distinguished name. Example: CN=User Name,OU=CITY_OU,OU=STATE_OU,DC=domain,DC=domain_root")
    public LdapAuthenticatorConfig setBindDistinguishedName(String bindDistinguishedName) {
        this.bindDistinguishedName = bindDistinguishedName;
        return this;
    }

    public String getBindPassword() {
        return this.bindPassword;
    }

    @Config(value="ldap.bind-password")
    @ConfigDescription(value="Bind password used. Example: password1234")
    @ConfigSecuritySensitive
    public LdapAuthenticatorConfig setBindPassword(String bindPassword) {
        this.bindPassword = bindPassword;
        return this;
    }

    @NotNull
    public Duration getLdapCacheTtl() {
        return this.ldapCacheTtl;
    }

    @Config(value="ldap.cache-ttl")
    public LdapAuthenticatorConfig setLdapCacheTtl(Duration ldapCacheTtl) {
        this.ldapCacheTtl = ldapCacheTtl;
        return this;
    }
}

