/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import java.util.Map;
import java.util.Objects;

public record SystemColumnHandle(String columnName) implements ColumnHandle
{
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(SystemColumnHandle.class);

    public SystemColumnHandle {
        Objects.requireNonNull(columnName, "columnName is null");
    }

    @Override
    public String toString() {
        return this.columnName;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.columnName);
    }

    public static Map<String, ColumnHandle> toSystemColumnHandles(ConnectorTableMetadata tableMetadata) {
        return (Map)tableMetadata.getColumns().stream().collect(ImmutableMap.toImmutableMap(ColumnMetadata::getName, column -> new SystemColumnHandle(column.getName())));
    }
}

