/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import io.trino.cost.FilterStatsCalculator;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.SimpleStatsRule;
import io.trino.cost.StatsCalculator;
import io.trino.cost.StatsNormalizer;
import io.trino.matching.Pattern;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.SpatialJoinNode;
import java.util.Objects;
import java.util.Optional;

public class SpatialJoinStatsRule
extends SimpleStatsRule<SpatialJoinNode> {
    private static final Pattern<SpatialJoinNode> PATTERN = Patterns.spatialJoin();
    private final FilterStatsCalculator statsCalculator;

    public SpatialJoinStatsRule(FilterStatsCalculator statsCalculator, StatsNormalizer normalizer) {
        super(normalizer);
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
    }

    @Override
    protected Optional<PlanNodeStatsEstimate> doCalculate(SpatialJoinNode node, StatsCalculator.Context context) {
        PlanNodeStatsEstimate leftStats = context.statsProvider().getStats(node.getLeft());
        PlanNodeStatsEstimate rightStats = context.statsProvider().getStats(node.getRight());
        PlanNodeStatsEstimate crossJoinStats = this.crossJoinStats(node, leftStats, rightStats);
        return switch (node.getType()) {
            default -> throw new MatchException(null, null);
            case SpatialJoinNode.Type.INNER -> Optional.of(this.statsCalculator.filterStats(crossJoinStats, node.getFilter(), context.session()));
            case SpatialJoinNode.Type.LEFT -> Optional.of(PlanNodeStatsEstimate.unknown());
        };
    }

    private PlanNodeStatsEstimate crossJoinStats(SpatialJoinNode node, PlanNodeStatsEstimate leftStats, PlanNodeStatsEstimate rightStats) {
        PlanNodeStatsEstimate.Builder builder = PlanNodeStatsEstimate.builder().setOutputRowCount(leftStats.getOutputRowCount() * rightStats.getOutputRowCount());
        node.getLeft().getOutputSymbols().forEach(symbol -> builder.addSymbolStatistics((Symbol)symbol, leftStats.getSymbolStatistics((Symbol)symbol)));
        node.getRight().getOutputSymbols().forEach(symbol -> builder.addSymbolStatistics((Symbol)symbol, rightStats.getSymbolStatistics((Symbol)symbol)));
        return builder.build();
    }

    @Override
    public Pattern<SpatialJoinNode> getPattern() {
        return PATTERN;
    }
}

