/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.PlanNodeStatsEstimateMath;
import io.trino.cost.SimpleStatsRule;
import io.trino.cost.StatsCalculator;
import io.trino.cost.StatsNormalizer;
import io.trino.matching.Pattern;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.UnionNode;
import java.util.Optional;

public class UnionStatsRule
extends SimpleStatsRule<UnionNode> {
    private static final Pattern<UnionNode> PATTERN = Patterns.union();

    public UnionStatsRule(StatsNormalizer normalizer) {
        super(normalizer);
    }

    @Override
    public Pattern<UnionNode> getPattern() {
        return PATTERN;
    }

    @Override
    protected final Optional<PlanNodeStatsEstimate> doCalculate(UnionNode node, StatsCalculator.Context context) {
        Preconditions.checkArgument((!node.getSources().isEmpty() ? 1 : 0) != 0, (Object)"Empty Union is not supported");
        Optional<PlanNodeStatsEstimate> estimate = Optional.empty();
        for (int i = 0; i < node.getSources().size(); ++i) {
            PlanNode source = node.getSources().get(i);
            PlanNodeStatsEstimate sourceStats = context.statsProvider().getStats(source);
            PlanNodeStatsEstimate sourceStatsWithMappedSymbols = this.mapToOutputSymbols(sourceStats, node.getSymbolMapping(), i);
            estimate = estimate.isPresent() ? Optional.of(PlanNodeStatsEstimateMath.addStatsAndCollapseDistinctValues(estimate.get(), sourceStatsWithMappedSymbols)) : Optional.of(sourceStatsWithMappedSymbols);
        }
        return estimate;
    }

    private PlanNodeStatsEstimate mapToOutputSymbols(PlanNodeStatsEstimate estimate, ListMultimap<Symbol, Symbol> mapping, int index) {
        PlanNodeStatsEstimate.Builder mapped = PlanNodeStatsEstimate.builder().setOutputRowCount(estimate.getOutputRowCount());
        mapping.keySet().forEach(symbol -> mapped.addSymbolStatistics((Symbol)symbol, estimate.getSymbolStatistics((Symbol)mapping.get(symbol).get(index))));
        return mapped.build();
    }
}

