/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.DropView;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import java.util.List;
import java.util.Objects;

public class DropViewTask
implements DataDefinitionTask<DropView> {
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public DropViewTask(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public String getName() {
        return "DROP VIEW";
    }

    @Override
    public ListenableFuture<Void> execute(DropView statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        QualifiedObjectName name;
        Session session = stateMachine.getSession();
        if (this.metadata.isMaterializedView(session, name = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName()))) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, (Node)statement, "View '%s' does not exist, but a materialized view with that name exists. Did you mean DROP MATERIALIZED VIEW %s?", name, name);
        }
        if (!this.metadata.isView(session, name)) {
            if (this.metadata.getTableHandle(session, name).isPresent()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, (Node)statement, "View '%s' does not exist, but a table with that name exists. Did you mean DROP TABLE %s?", name, name);
            }
            if (!statement.isExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, (Node)statement, "View '%s' does not exist", name);
            }
            return Futures.immediateVoidFuture();
        }
        this.accessControl.checkCanDropView(session.toSecurityContext(), name);
        this.metadata.dropView(session, name);
        return Futures.immediateVoidFuture();
    }
}

