/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Stream;

public enum StageState {
    PLANNED(false, false),
    SCHEDULING(false, false),
    RUNNING(false, false),
    PENDING(false, false),
    FINISHED(true, false),
    ABORTED(true, true),
    FAILED(true, true);

    public static final Set<StageState> TERMINAL_STAGE_STATES;
    private final boolean doneState;
    private final boolean failureState;

    private StageState(boolean doneState, boolean failureState) {
        Preconditions.checkArgument((!failureState || doneState ? 1 : 0) != 0, (String)"%s is a non-done failure state", (Object)this.name());
        this.doneState = doneState;
        this.failureState = failureState;
    }

    public boolean isDone() {
        return this.doneState;
    }

    public boolean isFailure() {
        return this.failureState;
    }

    public boolean isScheduled() {
        return this.equals((Object)RUNNING) || this.equals((Object)PENDING) || this.isDone();
    }

    static {
        TERMINAL_STAGE_STATES = (Set)Stream.of(StageState.values()).filter(StageState::isDone).collect(ImmutableSet.toImmutableSet());
    }
}

