/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.OptionalLong;

public class OutputBufferStatus {
    private static final OutputBufferStatus INITIAL = new OutputBufferStatus(OptionalLong.empty(), false, false);
    private final OptionalLong outputBuffersVersion;
    private final boolean overutilized;
    private final boolean exchangeSinkInstanceHandleUpdateRequired;

    @JsonCreator
    public OutputBufferStatus(@JsonProperty(value="outputBuffersVersion") OptionalLong outputBuffersVersion, @JsonProperty(value="overutilized") boolean overutilized, @JsonProperty(value="exchangeSinkInstanceHandleUpdateRequired") boolean exchangeSinkInstanceHandleUpdateRequired) {
        this.outputBuffersVersion = Objects.requireNonNull(outputBuffersVersion, "outputBuffersVersion is null");
        this.overutilized = overutilized;
        this.exchangeSinkInstanceHandleUpdateRequired = exchangeSinkInstanceHandleUpdateRequired;
    }

    @JsonProperty
    public OptionalLong getOutputBuffersVersion() {
        return this.outputBuffersVersion;
    }

    @JsonProperty
    public boolean isOverutilized() {
        return this.overutilized;
    }

    @JsonProperty
    public boolean isExchangeSinkInstanceHandleUpdateRequired() {
        return this.exchangeSinkInstanceHandleUpdateRequired;
    }

    public static OutputBufferStatus initial() {
        return INITIAL;
    }

    public static Builder builder(long outputBuffersVersion) {
        return new Builder(outputBuffersVersion);
    }

    public static class Builder {
        private final OptionalLong outputBuffersVersion;
        private boolean overutilized;
        private boolean exchangeSinkInstanceHandleUpdateRequired;

        public Builder(long outputBuffersVersion) {
            this.outputBuffersVersion = OptionalLong.of(outputBuffersVersion);
        }

        public Builder setOverutilized(boolean overutilized) {
            this.overutilized = overutilized;
            return this;
        }

        public Builder setExchangeSinkInstanceHandleUpdateRequired(boolean exchangeSinkInstanceHandleUpdateRequired) {
            this.exchangeSinkInstanceHandleUpdateRequired = exchangeSinkInstanceHandleUpdateRequired;
            return this;
        }

        public OutputBufferStatus build() {
            return new OutputBufferStatus(this.outputBuffersVersion, this.overutilized, this.exchangeSinkInstanceHandleUpdateRequired);
        }
    }
}

