/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.airlift.slice.SizeOf;
import io.trino.execution.scheduler.faulttolerant.NodeRequirements;
import io.trino.execution.scheduler.faulttolerant.SplitsMapping;
import java.util.Objects;

public class TaskDescriptor {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(TaskDescriptor.class);
    private final int partitionId;
    private final SplitsMapping splits;
    private final NodeRequirements nodeRequirements;
    private volatile transient long retainedSizeInBytes;

    @JsonCreator
    public TaskDescriptor(@JsonProperty(value="partitionId") int partitionId, @JsonProperty(value="splits") SplitsMapping splitsMapping, @JsonProperty(value="nodeRequirements") NodeRequirements nodeRequirements) {
        this.partitionId = partitionId;
        this.splits = Objects.requireNonNull(splitsMapping, "splitsMapping is null");
        this.nodeRequirements = Objects.requireNonNull(nodeRequirements, "nodeRequirements is null");
    }

    @JsonProperty
    public int getPartitionId() {
        return this.partitionId;
    }

    @JsonProperty
    public SplitsMapping getSplits() {
        return this.splits;
    }

    @JsonProperty
    public NodeRequirements getNodeRequirements() {
        return this.nodeRequirements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskDescriptor that = (TaskDescriptor)o;
        return this.partitionId == that.partitionId && Objects.equals(this.splits, that.splits) && Objects.equals(this.nodeRequirements, that.nodeRequirements);
    }

    public int hashCode() {
        return Objects.hash(this.partitionId, this.splits, this.nodeRequirements);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitionId", this.partitionId).add("splits", (Object)this.splits).add("nodeRequirements", (Object)this.nodeRequirements).toString();
    }

    public long getRetainedSizeInBytes() {
        long result = this.retainedSizeInBytes;
        if (result == 0L) {
            this.retainedSizeInBytes = result = (long)INSTANCE_SIZE + this.splits.getRetainedSizeInBytes() + this.nodeRequirements.getRetainedSizeInBytes();
        }
        return result;
    }
}

