/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import io.trino.execution.TaskId;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.LanguageFunctionDefinition;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.ScalarFunctionImplementation;
import io.trino.sql.routine.ir.IrRoutine;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public interface LanguageFunctionProvider {
    public static final LanguageFunctionProvider DISABLED = new LanguageFunctionProvider(){

        @Override
        public ScalarFunctionImplementation specialize(FunctionId functionId, InvocationConvention invocationConvention, FunctionManager functionManager) {
            throw new UnsupportedOperationException("SQL language functions are disabled");
        }

        @Override
        public void registerTask(TaskId taskId, Map<FunctionId, LanguageFunctionData> languageFunctions) {
            if (!languageFunctions.isEmpty()) {
                throw new UnsupportedOperationException("SQL language functions are disabled");
            }
        }

        @Override
        public void unregisterTask(TaskId taskId) {
        }
    };

    public ScalarFunctionImplementation specialize(FunctionId var1, InvocationConvention var2, FunctionManager var3);

    public void registerTask(TaskId var1, Map<FunctionId, LanguageFunctionData> var2);

    public void unregisterTask(TaskId var1);

    public record LanguageFunctionData(Optional<IrRoutine> irRoutine, Optional<LanguageFunctionDefinition> definition) {
        public LanguageFunctionData {
            Objects.requireNonNull(irRoutine, "irRoutine is null");
            Objects.requireNonNull(definition, "definition is null");
            Preconditions.checkArgument((irRoutine.isPresent() != definition.isPresent() ? 1 : 0) != 0, (Object)"exactly one of irRoutine and metadata must be present");
        }

        public static LanguageFunctionData ofIrRoutine(IrRoutine irRoutine) {
            return new LanguageFunctionData(Optional.of(irRoutine), Optional.empty());
        }

        public static LanguageFunctionData ofDefinition(LanguageFunctionDefinition metadata) {
            return new LanguageFunctionData(Optional.empty(), Optional.of(metadata));
        }
    }
}

