/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.spi.connector.CatalogSchemaRoutineName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.SchemaRoutineName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.SchemaFunctionName;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public record QualifiedObjectName(String catalogName, String schemaName, String objectName) {
    private static final Pattern UNQUOTED_COMPONENT = Pattern.compile("[a-zA-Z0-9_]+");
    private static final String COMPONENT = UNQUOTED_COMPONENT.pattern() + "|\"([^\"]|\"\")*\"";
    private static final Pattern PATTERN = Pattern.compile("(?<catalog>" + COMPONENT + ")\\.(?<schema>" + COMPONENT + ")\\.(?<table>" + COMPONENT + ")");

    public QualifiedObjectName {
        MetadataUtil.checkObjectName(catalogName, schemaName, objectName);
    }

    @JsonCreator
    public static QualifiedObjectName valueOf(String name) {
        Objects.requireNonNull(name, "name is null");
        Matcher matcher = PATTERN.matcher(name);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"Invalid name %s", (Object)name);
        return new QualifiedObjectName(QualifiedObjectName.unquoteIfNeeded(matcher.group("catalog")), QualifiedObjectName.unquoteIfNeeded(matcher.group("schema")), QualifiedObjectName.unquoteIfNeeded(matcher.group("table")));
    }

    public SchemaTableName asSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.objectName);
    }

    public CatalogSchemaTableName asCatalogSchemaTableName() {
        return new CatalogSchemaTableName(this.catalogName, this.schemaName, this.objectName);
    }

    public SchemaRoutineName asSchemaRoutineName() {
        return new SchemaRoutineName(this.schemaName, this.objectName);
    }

    public CatalogSchemaRoutineName asCatalogSchemaRoutineName() {
        return new CatalogSchemaRoutineName(this.catalogName, this.schemaName, this.objectName);
    }

    public QualifiedTablePrefix asQualifiedTablePrefix() {
        return new QualifiedTablePrefix(this.catalogName, this.schemaName, this.objectName);
    }

    public SchemaFunctionName asSchemaFunctionName() {
        return new SchemaFunctionName(this.schemaName, this.objectName);
    }

    @Override
    @JsonValue
    public String toString() {
        return QualifiedObjectName.quoteIfNeeded(this.catalogName) + "." + QualifiedObjectName.quoteIfNeeded(this.schemaName) + "." + QualifiedObjectName.quoteIfNeeded(this.objectName);
    }

    public static Function<SchemaTableName, QualifiedObjectName> convertFromSchemaTableName(String catalogName) {
        return input -> new QualifiedObjectName(catalogName, input.getSchemaName(), input.getTableName());
    }

    private static String unquoteIfNeeded(String name) {
        if (name.isEmpty() || name.charAt(0) != '\"') {
            return name;
        }
        Preconditions.checkArgument((name.charAt(name.length() - 1) == '\"' ? 1 : 0) != 0, (String)"Invalid name: [%s]", (Object)name);
        return name.substring(1, name.length() - 1).replace("\"\"", "\"");
    }

    private static String quoteIfNeeded(String name) {
        if (UNQUOTED_COMPONENT.matcher(name).matches()) {
            return name;
        }
        return "\"" + name.replace("\"", "\"\"") + "\"";
    }
}

