/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;

public class PositionSearcher {
    private PositionSearcher() {
    }

    public static int findEndPosition(int startPosition, int endPosition, PositionComparator comparator) {
        long left;
        Preconditions.checkArgument((startPosition >= 0 ? 1 : 0) != 0, (String)"startPosition must be greater or equal than zero: %s", (int)startPosition);
        Preconditions.checkArgument((startPosition < endPosition ? 1 : 0) != 0, (String)"startPosition (%s) must be less than endPosition (%s)", (int)startPosition, (int)endPosition);
        long right = startPosition;
        long distance = 1L;
        do {
            left = right;
        } while ((right += (distance *= 2L)) < (long)endPosition && comparator.test(Math.toIntExact(left), Math.toIntExact(right)));
        int intLeft = Math.toIntExact(left);
        int intRight = Math.toIntExact(Math.min(right, (long)endPosition));
        while (intRight - intLeft > 1) {
            int middle = intLeft + intRight >>> 1;
            if (comparator.test(startPosition, middle)) {
                intLeft = middle;
                continue;
            }
            intRight = middle;
        }
        return intRight;
    }

    public static interface PositionComparator {
        public boolean test(int var1, int var2);
    }
}

