/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.BooleanType;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;

public final class AggregationMask {
    private static final int[] NO_SELECTED_POSITIONS = new int[0];
    private int positionCount;
    private int[] selectedPositions = NO_SELECTED_POSITIONS;
    private int selectedPositionCount;

    public static AggregationMask createSelectNone(int positionCount) {
        return AggregationMask.createSelectedPositions(positionCount, NO_SELECTED_POSITIONS, 0);
    }

    public static AggregationMask createSelectAll(int positionCount) {
        return new AggregationMask(positionCount);
    }

    public static AggregationMask createSelectedPositions(int positionCount, int[] selectedPositions, int selectedPositionCount) {
        return new AggregationMask(positionCount, selectedPositions, selectedPositionCount);
    }

    private AggregationMask(int positionCount) {
        this.reset(positionCount);
    }

    private AggregationMask(int positionCount, int[] selectedPositions, int selectedPositionCount) {
        Preconditions.checkArgument((positionCount >= 0 ? 1 : 0) != 0, (Object)"positionCount is negative");
        Preconditions.checkArgument((selectedPositionCount >= 0 ? 1 : 0) != 0, (Object)"selectedPositionCount is negative");
        Preconditions.checkArgument((selectedPositionCount <= positionCount ? 1 : 0) != 0, (Object)"selectedPositionCount cannot be greater than positionCount");
        Objects.requireNonNull(selectedPositions, "selectedPositions is null");
        Preconditions.checkArgument((selectedPositions.length >= selectedPositionCount ? 1 : 0) != 0, (Object)"selectedPosition is smaller than selectedPositionCount");
        this.reset(positionCount);
        this.selectedPositions = selectedPositions;
        this.selectedPositionCount = selectedPositionCount;
    }

    public void reset(int positionCount) {
        Preconditions.checkArgument((positionCount >= 0 ? 1 : 0) != 0, (Object)"positionCount is negative");
        this.positionCount = positionCount;
        this.selectedPositionCount = positionCount;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public boolean isSelectAll() {
        return this.positionCount == this.selectedPositionCount;
    }

    public boolean isSelectNone() {
        return this.selectedPositionCount == 0;
    }

    public Page filterPage(Page page) {
        if (this.isSelectAll()) {
            return page;
        }
        if (this.isSelectNone()) {
            return page.getRegion(0, 0);
        }
        return page.getPositions(Arrays.copyOf(this.selectedPositions, this.selectedPositionCount), 0, this.selectedPositionCount);
    }

    public int getSelectedPositionCount() {
        return this.selectedPositionCount;
    }

    public int[] getSelectedPositions() {
        Preconditions.checkState((!this.isSelectAll() ? 1 : 0) != 0, (Object)"getSelectedPositions not available when in selectAll mode");
        return this.selectedPositions;
    }

    public void unselectNullPositions(Block block) {
        this.unselectPositions(block, false);
    }

    public void applyMaskBlock(@Nullable Block maskBlock) {
        if (maskBlock != null) {
            this.unselectPositions(maskBlock, true);
        }
    }

    private void unselectPositions(Block block, boolean shouldTestValues) {
        int positionCount = block.getPositionCount();
        Preconditions.checkArgument((positionCount == this.positionCount ? 1 : 0) != 0, (Object)"Block position count does not match current position count");
        if (this.isSelectNone()) {
            return;
        }
        if (!block.mayHaveNull() && !shouldTestValues) {
            return;
        }
        if (block instanceof RunLengthEncodedBlock) {
            if (AggregationMask.test(block, 0, shouldTestValues)) {
                return;
            }
            this.selectedPositionCount = 0;
            return;
        }
        if (positionCount == this.selectedPositionCount) {
            if (this.selectedPositions.length < positionCount) {
                this.selectedPositions = new int[positionCount];
            }
            int selectedPositionsIndex = 0;
            for (int position = 0; position < positionCount; ++position) {
                if (!AggregationMask.test(block, position, shouldTestValues)) continue;
                this.selectedPositions[selectedPositionsIndex] = position;
                ++selectedPositionsIndex;
            }
            this.selectedPositionCount = selectedPositionsIndex;
            return;
        }
        int newIndex = 0;
        for (int originalIndex = 0; originalIndex < this.selectedPositionCount; ++originalIndex) {
            int position = this.selectedPositions[originalIndex];
            if (!AggregationMask.test(block, position, shouldTestValues)) continue;
            this.selectedPositions[newIndex] = position;
            ++newIndex;
        }
        this.selectedPositionCount = newIndex;
    }

    private static boolean test(Block block, int position, boolean testValue) {
        if (block.isNull(position)) {
            return false;
        }
        return !testValue || BooleanType.BOOLEAN.getBoolean(block, position);
    }
}

