/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.annotation.UsedByGeneratedCode;
import io.trino.operator.aggregation.state.LongState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.WindowAccumulator;
import io.trino.spi.function.WindowIndex;
import io.trino.spi.type.BigintType;

@AggregationFunction(value="count", windowAccumulator=CountWindowAccumulator.class)
public final class CountAggregation {
    private CountAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState LongState state) {
        state.setValue(state.getValue() + 1L);
    }

    @CombineFunction
    public static void combine(@AggregationState LongState state, @AggregationState LongState otherState) {
        state.setValue(state.getValue() + otherState.getValue());
    }

    @OutputFunction(value="bigint")
    public static void output(@AggregationState LongState state, BlockBuilder out) {
        BigintType.BIGINT.writeLong(out, state.getValue());
    }

    public static class CountWindowAccumulator
    implements WindowAccumulator {
        private long count;

        @UsedByGeneratedCode
        public CountWindowAccumulator() {
        }

        private CountWindowAccumulator(long count) {
            this.count = count;
        }

        public long getEstimatedSize() {
            return 8L;
        }

        public WindowAccumulator copy() {
            return new CountWindowAccumulator(this.count);
        }

        public void addInput(WindowIndex index, int startPosition, int endPosition) {
            this.count += (long)(endPosition - startPosition + 1);
        }

        public boolean removeInput(WindowIndex index, int startPosition, int endPosition) {
            this.count -= (long)(endPosition - startPosition + 1);
            return true;
        }

        public void output(BlockBuilder blockBuilder) {
            BigintType.BIGINT.writeLong(blockBuilder, this.count);
        }
    }
}

