/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.DoubleHistogramAggregation;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.RealType;
import java.util.Map;

@AggregationFunction(value="numeric_histogram")
public final class RealHistogramAggregation {
    private RealHistogramAggregation() {
    }

    @InputFunction
    public static void add(@AggregationState DoubleHistogramAggregation.State state, @SqlType(value="bigint") long buckets, @SqlType(value="real") long value, @SqlType(value="double") double weight) {
        DoubleHistogramAggregation.add(state, buckets, Float.intBitsToFloat((int)value), weight);
    }

    @InputFunction
    public static void add(@AggregationState DoubleHistogramAggregation.State state, @SqlType(value="bigint") long buckets, @SqlType(value="real") long value) {
        RealHistogramAggregation.add(state, buckets, value, 1.0);
    }

    @CombineFunction
    public static void merge(@AggregationState DoubleHistogramAggregation.State state, @AggregationState DoubleHistogramAggregation.State other) {
        DoubleHistogramAggregation.merge(state, other);
    }

    @OutputFunction(value="map(real,real)")
    public static void output(@AggregationState DoubleHistogramAggregation.State state, BlockBuilder out) {
        if (state.get() == null) {
            out.appendNull();
        } else {
            Map<Double, Double> value = state.get().getBuckets();
            ((MapBlockBuilder)out).buildEntry((keyBuilder, valueBuilder) -> {
                for (Map.Entry entry : value.entrySet()) {
                    RealType.REAL.writeLong(keyBuilder, (long)Float.floatToRawIntBits(((Double)entry.getKey()).floatValue()));
                    RealType.REAL.writeLong(valueBuilder, (long)Float.floatToRawIntBits(((Double)entry.getValue()).floatValue()));
                }
            });
        }
    }
}

