/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.annotation.UsedByGeneratedCode;
import io.trino.operator.aggregation.state.NullableDoubleState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.WindowAccumulator;
import io.trino.spi.function.WindowIndex;
import io.trino.spi.type.RealType;
import io.trino.type.Reals;

@AggregationFunction(value="sum", windowAccumulator=RealSumWindowAccumulator.class)
public final class RealSumAggregation {
    private RealSumAggregation() {
    }

    @InputFunction
    public static void sum(@AggregationState NullableDoubleState state, @SqlType(value="real") long value) {
        state.setNull(false);
        state.setValue(state.getValue() + (double)Float.intBitsToFloat((int)value));
    }

    @CombineFunction
    public static void combine(@AggregationState NullableDoubleState state, @AggregationState NullableDoubleState otherState) {
        if (state.isNull()) {
            if (otherState.isNull()) {
                return;
            }
            state.set(otherState);
            return;
        }
        if (!otherState.isNull()) {
            state.setValue(state.getValue() + otherState.getValue());
        }
    }

    @OutputFunction(value="real")
    public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits((float)state.getValue()));
        }
    }

    public static class RealSumWindowAccumulator
    implements WindowAccumulator {
        private long count;
        private double sum;

        @UsedByGeneratedCode
        public RealSumWindowAccumulator() {
        }

        private RealSumWindowAccumulator(long count, double sum) {
            this.count = count;
            this.sum = sum;
        }

        public long getEstimatedSize() {
            return 16L;
        }

        public WindowAccumulator copy() {
            return new RealSumWindowAccumulator(this.count, this.sum);
        }

        public void addInput(WindowIndex index, int startPosition, int endPosition) {
            for (int i = startPosition; i <= endPosition; ++i) {
                if (index.isNull(0, i)) continue;
                this.sum += (double)Float.intBitsToFloat((int)index.getLong(0, i));
                ++this.count;
            }
        }

        public boolean removeInput(WindowIndex index, int startPosition, int endPosition) {
            if (!Double.isFinite(this.sum)) {
                return false;
            }
            for (int i = startPosition; i <= endPosition; ++i) {
                if (index.isNull(0, i)) continue;
                this.sum -= (double)Float.intBitsToFloat((int)index.getLong(0, i));
                --this.count;
            }
            return true;
        }

        public void output(BlockBuilder blockBuilder) {
            if (this.count == 0L) {
                blockBuilder.appendNull();
            } else {
                RealType.REAL.writeLong(blockBuilder, Reals.toReal((float)this.sum));
            }
        }
    }
}

