/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.multimapagg;

import io.trino.operator.aggregation.multimapagg.MultimapAggregationState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Description;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.function.TypeParameters;

@AggregationFunction(value="multimap_agg", isOrderSensitive=true)
@Description(value="Aggregates all the rows (key/value pairs) into a single multimap")
public final class MultimapAggregationFunction {
    private MultimapAggregationFunction() {
    }

    @InputFunction
    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    public static void input(@AggregationState(value={"K", "V"}) MultimapAggregationState state, @BlockPosition @SqlType(value="K") ValueBlock key, @BlockIndex int keyPosition, @SqlNullable @BlockPosition @SqlType(value="V") ValueBlock value, @BlockIndex int valuePosition) {
        state.add(key, keyPosition, value, valuePosition);
    }

    @CombineFunction
    public static void combine(@AggregationState(value={"K", "V"}) MultimapAggregationState state, @AggregationState(value={"K", "V"}) MultimapAggregationState otherState) {
        state.merge(otherState);
    }

    @OutputFunction(value="map(K, array(V))")
    public static void output(@AggregationState(value={"K", "V"}) MultimapAggregationState state, BlockBuilder out) {
        state.writeAll((MapBlockBuilder)out);
    }
}

