/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.DynamicClassLoader;
import io.airlift.bytecode.FieldDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.trino.array.BlockBigArray;
import io.trino.array.BooleanBigArray;
import io.trino.array.ByteBigArray;
import io.trino.array.DoubleBigArray;
import io.trino.array.IntBigArray;
import io.trino.array.LongBigArray;
import io.trino.array.ObjectBigArray;
import io.trino.array.SliceBigArray;
import io.trino.array.SqlMapBigArray;
import io.trino.array.SqlRowBigArray;
import io.trino.operator.aggregation.state.AbstractGroupedAccumulatorState;
import io.trino.operator.aggregation.state.InitialBooleanValue;
import io.trino.operator.aggregation.state.InitialDoubleValue;
import io.trino.operator.aggregation.state.InitialLongValue;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.RowValueBuilder;
import io.trino.spi.block.SqlMap;
import io.trino.spi.block.SqlRow;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.AccumulatorStateMetadata;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.function.GroupedAccumulatorState;
import io.trino.spi.function.InOut;
import io.trino.spi.function.InternalDataAccessor;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.sql.gen.CallSiteBinder;
import io.trino.sql.gen.LambdaMetafactoryGenerator;
import io.trino.sql.gen.SqlTypeBytecodeExpression;
import io.trino.type.UnknownType;
import io.trino.util.CompilerUtils;
import java.lang.annotation.Annotation;
import java.lang.constant.Constable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class StateCompiler {
    private StateCompiler() {
    }

    private static Class<?> getBigArrayType(Class<?> type) {
        if (type.equals(Long.TYPE)) {
            return LongBigArray.class;
        }
        if (type.equals(Byte.TYPE)) {
            return ByteBigArray.class;
        }
        if (type.equals(Double.TYPE)) {
            return DoubleBigArray.class;
        }
        if (type.equals(Boolean.TYPE)) {
            return BooleanBigArray.class;
        }
        if (type.equals(Integer.TYPE)) {
            return IntBigArray.class;
        }
        if (type.equals(Slice.class)) {
            return SliceBigArray.class;
        }
        if (type.equals(Block.class)) {
            return BlockBigArray.class;
        }
        if (type.equals(SqlMap.class)) {
            return SqlMapBigArray.class;
        }
        if (type.equals(SqlRow.class)) {
            return SqlRowBigArray.class;
        }
        return ObjectBigArray.class;
    }

    private static Class<?> bigArrayElementType(Class<?> bigArrayType) {
        if (bigArrayType.equals(LongBigArray.class)) {
            return Long.TYPE;
        }
        if (bigArrayType.equals(ByteBigArray.class)) {
            return Byte.TYPE;
        }
        if (bigArrayType.equals(DoubleBigArray.class)) {
            return Double.TYPE;
        }
        if (bigArrayType.equals(BooleanBigArray.class)) {
            return Boolean.TYPE;
        }
        if (bigArrayType.equals(IntBigArray.class)) {
            return Integer.TYPE;
        }
        if (bigArrayType.equals(SliceBigArray.class)) {
            return Slice.class;
        }
        if (bigArrayType.equals(BlockBigArray.class)) {
            return Block.class;
        }
        if (bigArrayType.equals(SqlMapBigArray.class)) {
            return SqlMap.class;
        }
        if (bigArrayType.equals(SqlRowBigArray.class)) {
            return SqlRow.class;
        }
        if (bigArrayType.equals(ObjectBigArray.class)) {
            return Object.class;
        }
        throw new IllegalArgumentException("Unsupported bigArrayType: " + bigArrayType.getName());
    }

    public static <T extends AccumulatorState> AccumulatorStateSerializer<T> generateStateSerializer(Class<T> clazz) {
        return StateCompiler.generateStateSerializer(clazz, (Map<String, Type>)ImmutableMap.of());
    }

    @VisibleForTesting
    static <T extends AccumulatorState> AccumulatorStateSerializer<T> generateStateSerializer(Class<T> clazz, Map<String, Type> fieldTypes) {
        AccumulatorStateMetadata metadata = StateCompiler.getMetadataAnnotation(clazz);
        if (metadata != null && metadata.stateSerializerClass() != AccumulatorStateSerializer.class) {
            try {
                return (AccumulatorStateSerializer)metadata.stateSerializerClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(clazz.getSimpleName() + "Serializer"), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(AccumulatorStateSerializer.class)});
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        definition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}));
        List<StateField> fields = StateCompiler.enumerateFields(clazz, fieldTypes);
        StateCompiler.generateGetSerializedType(definition, fields, callSiteBinder);
        StateCompiler.generateSerialize(definition, callSiteBinder, clazz, fields);
        StateCompiler.generateDeserialize(definition, callSiteBinder, clazz, fields);
        DynamicClassLoader classLoader = new DynamicClassLoader(clazz.getClassLoader(), StateCompiler.class.getClassLoader());
        Class<AccumulatorStateSerializer> serializerClass = CompilerUtils.defineClass(definition, AccumulatorStateSerializer.class, callSiteBinder.getBindings(), (ClassLoader)classLoader);
        try {
            return serializerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static void generateGetSerializedType(ClassDefinition definition, List<StateField> fields, CallSiteBinder callSiteBinder) {
        BytecodeBlock body = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getSerializedType", ParameterizedType.type(Type.class), new Parameter[0]).getBody();
        Type type = StateCompiler.getSerializedType(fields);
        body.comment("return %s", new Object[]{type.getTypeSignature()}).append((BytecodeNode)SqlTypeBytecodeExpression.constantType(callSiteBinder, type)).retObject();
    }

    private static Type getSerializedType(List<StateField> fields) {
        if (fields.size() > 1) {
            List types = (List)fields.stream().map(StateField::getSqlType).collect(ImmutableList.toImmutableList());
            return RowType.anonymous((List)types);
        }
        if (fields.size() == 1) {
            return ((StateField)Iterables.getOnlyElement(fields)).getSqlType();
        }
        return UnknownType.UNKNOWN;
    }

    public static <T> AccumulatorStateMetadata getMetadataAnnotation(Class<T> clazz) {
        AccumulatorStateMetadata metadata = clazz.getAnnotation(AccumulatorStateMetadata.class);
        if (metadata != null) {
            return metadata;
        }
        for (Class<?> superInterface : clazz.getInterfaces()) {
            metadata = superInterface.getAnnotation(AccumulatorStateMetadata.class);
            if (metadata == null) continue;
            return metadata;
        }
        return null;
    }

    private static <T extends AccumulatorState> void generateDeserialize(ClassDefinition definition, CallSiteBinder binder, Class<T> clazz, List<StateField> fields) {
        Parameter block = Parameter.arg((String)"block", Block.class);
        Parameter index = Parameter.arg((String)"index", Integer.TYPE);
        Parameter state = Parameter.arg((String)"state", AccumulatorState.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "deserialize", ParameterizedType.type(Void.TYPE), new Parameter[]{block, index, state});
        BytecodeBlock deserializerBody = method.getBody();
        Scope scope = method.getScope();
        if (fields.size() == 1) {
            StateField field = (StateField)Iterables.getOnlyElement(fields);
            Method setter = StateCompiler.getSetter(clazz, field);
            if (!field.isPrimitiveType()) {
                deserializerBody.append((BytecodeNode)new IfStatement().condition((BytecodeNode)block.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{index})).ifTrue((BytecodeNode)state.cast(setter.getDeclaringClass()).invoke(setter, new BytecodeExpression[]{BytecodeExpressions.constantNull(field.getType())})).ifFalse((BytecodeNode)state.cast(setter.getDeclaringClass()).invoke(setter, new BytecodeExpression[]{SqlTypeBytecodeExpression.constantType(binder, field.getSqlType()).getValue((BytecodeExpression)block, (BytecodeExpression)index)})));
            } else {
                deserializerBody.append((BytecodeNode)state.cast(setter.getDeclaringClass()).invoke(setter, new BytecodeExpression[]{SqlTypeBytecodeExpression.constantType(binder, field.getSqlType()).getValue((BytecodeExpression)block, (BytecodeExpression)index).cast(field.getType())}));
            }
        } else if (fields.size() > 1) {
            Variable row = scope.declareVariable("row", deserializerBody, SqlTypeBytecodeExpression.constantType(binder, StateCompiler.getSerializedType(fields)).cast(RowType.class).invoke("getObject", SqlRow.class, new BytecodeExpression[]{block, index}));
            Variable rawIndex = scope.declareVariable("rawIndex", deserializerBody, row.invoke("getRawIndex", Integer.TYPE, new BytecodeExpression[0]));
            Variable fieldBlock = scope.declareVariable(Block.class, "fieldBlock");
            int position = 0;
            for (StateField field : fields) {
                Method setter = StateCompiler.getSetter(clazz, field);
                deserializerBody.append((BytecodeNode)fieldBlock.set(row.invoke("getRawFieldBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)position)})));
                if (!field.isPrimitiveType()) {
                    deserializerBody.append((BytecodeNode)new IfStatement().condition((BytecodeNode)fieldBlock.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{rawIndex})).ifTrue((BytecodeNode)state.cast(setter.getDeclaringClass()).invoke(setter, new BytecodeExpression[]{BytecodeExpressions.constantNull(field.getType())})).ifFalse((BytecodeNode)state.cast(setter.getDeclaringClass()).invoke(setter, new BytecodeExpression[]{SqlTypeBytecodeExpression.constantType(binder, field.getSqlType()).getValue((BytecodeExpression)fieldBlock, (BytecodeExpression)rawIndex)})));
                } else {
                    deserializerBody.append((BytecodeNode)state.cast(setter.getDeclaringClass()).invoke(setter, new BytecodeExpression[]{SqlTypeBytecodeExpression.constantType(binder, field.getSqlType()).getValue((BytecodeExpression)fieldBlock, (BytecodeExpression)rawIndex).cast(field.getType())}));
                }
                ++position;
            }
        }
        deserializerBody.ret();
    }

    private static <T> void generateSerialize(ClassDefinition definition, CallSiteBinder binder, Class<T> clazz, List<StateField> fields) {
        Parameter state = Parameter.arg((String)"state", AccumulatorState.class);
        Parameter out = Parameter.arg((String)"out", BlockBuilder.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "serialize", ParameterizedType.type(Void.TYPE), new Parameter[]{state, out});
        Scope scope = method.getScope();
        BytecodeBlock serializerBody = method.getBody();
        if (fields.isEmpty()) {
            serializerBody.append((BytecodeNode)out.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop());
        } else if (fields.size() == 1) {
            Method getter = StateCompiler.getGetter(clazz, (StateField)Iterables.getOnlyElement(fields));
            SqlTypeBytecodeExpression sqlType = SqlTypeBytecodeExpression.constantType(binder, ((StateField)Iterables.getOnlyElement(fields)).getSqlType());
            Variable fieldValue = scope.declareVariable(getter.getReturnType(), "value");
            serializerBody.append((BytecodeNode)fieldValue.set(state.cast(getter.getDeclaringClass()).invoke(getter, new BytecodeExpression[0])));
            if (!((StateField)Iterables.getOnlyElement(fields)).isPrimitiveType()) {
                serializerBody.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.equal((BytecodeExpression)fieldValue, (BytecodeExpression)BytecodeExpressions.constantNull(getter.getReturnType()))).ifTrue((BytecodeNode)out.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop()).ifFalse((BytecodeNode)sqlType.writeValue((BytecodeExpression)out, (BytecodeExpression)fieldValue)));
            } else {
                serializerBody.append((BytecodeNode)sqlType.writeValue((BytecodeExpression)out, fieldValue.cast(((StateField)Iterables.getOnlyElement(fields)).getSqlType().getJavaType())));
            }
        } else {
            MethodDefinition serializeToRow = StateCompiler.generateSerializeToRow(definition, binder, clazz, fields);
            BytecodeExpression rowEntryBuilder = LambdaMetafactoryGenerator.generateMetafactory(RowValueBuilder.class, serializeToRow, (List<BytecodeExpression>)ImmutableList.of((Object)state));
            serializerBody.append((BytecodeNode)out.cast(RowBlockBuilder.class).invoke("buildEntry", Void.TYPE, new BytecodeExpression[]{rowEntryBuilder}));
        }
        serializerBody.ret();
    }

    private static MethodDefinition generateSerializeToRow(ClassDefinition definition, CallSiteBinder binder, Class<?> clazz, List<StateField> fields) {
        Parameter state = Parameter.arg((String)"state", AccumulatorState.class);
        Parameter fieldBuilders = Parameter.arg((String)"fieldBuilders", (ParameterizedType)ParameterizedType.type(List.class, (Class[])new Class[]{BlockBuilder.class}));
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PRIVATE, Access.STATIC}), "serialize", ParameterizedType.type(Void.TYPE), new Parameter[]{state, fieldBuilders});
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable fieldBuilder = scope.getOrCreateTempVariable(BlockBuilder.class);
        for (int i = 0; i < fields.size(); ++i) {
            StateField field = fields.get(i);
            Method getter = StateCompiler.getGetter(clazz, field);
            SqlTypeBytecodeExpression sqlType = SqlTypeBytecodeExpression.constantType(binder, field.getSqlType());
            Variable fieldValue = scope.getOrCreateTempVariable(getter.getReturnType());
            body.append((BytecodeNode)fieldValue.set(state.cast(getter.getDeclaringClass()).invoke(getter, new BytecodeExpression[0])));
            body.append((BytecodeNode)fieldBuilder.set(fieldBuilders.invoke("get", Object.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)i)}).cast(BlockBuilder.class)));
            if (!field.isPrimitiveType()) {
                body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.equal((BytecodeExpression)fieldValue, (BytecodeExpression)BytecodeExpressions.constantNull(getter.getReturnType()))).ifTrue((BytecodeNode)fieldBuilder.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop()).ifFalse((BytecodeNode)sqlType.writeValue((BytecodeExpression)fieldBuilder, (BytecodeExpression)fieldValue)));
            } else {
                body.append((BytecodeNode)sqlType.writeValue((BytecodeExpression)fieldBuilder, fieldValue.cast(field.getSqlType().getJavaType())));
            }
            scope.releaseTempVariableForReuse(fieldValue);
        }
        scope.releaseTempVariableForReuse(fieldBuilder);
        body.ret();
        return method;
    }

    private static Method getSetter(Class<?> clazz, StateField field) {
        try {
            return clazz.getMethod(field.getSetterName(), field.getType());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static Method getGetter(Class<?> clazz, StateField field) {
        try {
            return clazz.getMethod(field.getGetterName(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static AccumulatorStateFactory<InOut> generateInOutStateFactory(Type type) {
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ClassDefinition singleStateClassDefinition = StateCompiler.generateInOutSingleStateClass(type, callSiteBinder);
        ClassDefinition groupedStateClassDefinition = StateCompiler.generateInOutGroupedStateClass(type, callSiteBinder);
        DynamicClassLoader classLoader = new DynamicClassLoader(StateCompiler.class.getClassLoader(), callSiteBinder.getBindings());
        Class<InOut> singleStateClass = CompilerUtils.defineClass(singleStateClassDefinition, InOut.class, classLoader);
        Class<InOut> groupedStateClass = CompilerUtils.defineClass(groupedStateClassDefinition, InOut.class, classLoader);
        return StateCompiler.generateStateFactory(InOut.class, singleStateClass, groupedStateClass, classLoader);
    }

    private static ClassDefinition generateInOutSingleStateClass(Type type, CallSiteBinder callSiteBinder) {
        Function<Scope, BytecodeExpression> nullGetter;
        Optional<FieldDefinition> nullField;
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("SingleInOut"), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(InOut.class), ParameterizedType.type(InternalDataAccessor.class)});
        StateCompiler.estimatedSize(definition);
        MethodDefinition constructor = definition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        constructor.getBody().append((BytecodeNode)constructor.getThis()).invokeConstructor(Object.class, new Class[0]);
        FieldDefinition valueField = definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), "value", StateCompiler.inOutGetterReturnType(type));
        Function<Scope, BytecodeExpression> valueGetter = scope -> scope.getThis().getField(valueField);
        if (type.getJavaType().isPrimitive()) {
            nullField = Optional.of(definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), "valueIdNull", Boolean.TYPE));
            constructor.getBody().append((BytecodeNode)constructor.getThis().setField(nullField.get(), BytecodeExpressions.constantTrue()));
            nullGetter = scope -> scope.getThis().getField((FieldDefinition)nullField.get());
        } else {
            nullField = Optional.empty();
            nullGetter = scope -> BytecodeExpressions.isNull((BytecodeExpression)((BytecodeExpression)valueGetter.apply((Scope)scope)));
        }
        constructor.getBody().ret();
        StateCompiler.inOutSingleCopy(definition, valueField, nullField);
        Function<Scope, BytecodeNode> setNullGenerator = scope -> {
            Variable thisVariable = scope.getThis();
            BytecodeBlock bytecodeBlock = new BytecodeBlock();
            nullField.ifPresent(field -> bytecodeBlock.append((BytecodeNode)thisVariable.setField(field, BytecodeExpressions.constantTrue())));
            bytecodeBlock.append((BytecodeNode)thisVariable.setField(valueField, BytecodeExpressions.defaultValue((ParameterizedType)valueField.getType())));
            return bytecodeBlock;
        };
        BiFunction<Scope, BytecodeExpression, BytecodeNode> setValueGenerator = (scope, value) -> {
            Variable thisVariable = scope.getThis();
            BytecodeBlock bytecodeBlock = new BytecodeBlock();
            nullField.ifPresent(field -> bytecodeBlock.append((BytecodeNode)thisVariable.setField(field, BytecodeExpressions.constantFalse())));
            bytecodeBlock.append((BytecodeNode)thisVariable.setField(valueField, value));
            return bytecodeBlock;
        };
        StateCompiler.generateInOutMethods(type, definition, valueGetter, nullGetter, setNullGenerator, setValueGenerator, callSiteBinder);
        return definition;
    }

    private static ClassDefinition generateInOutGroupedStateClass(Type type, CallSiteBinder callSiteBinder) {
        Function<Scope, BytecodeExpression> nullGetter;
        Optional<FieldDefinition> nullField;
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("GroupedInOut"), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(InOut.class), ParameterizedType.type(GroupedAccumulatorState.class), ParameterizedType.type(InternalDataAccessor.class)});
        MethodDefinition constructor = definition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        constructor.getBody().append((BytecodeNode)constructor.getThis()).invokeConstructor(Object.class, new Class[0]);
        ImmutableList.Builder fieldDefinitions = ImmutableList.builder();
        FieldDefinition groupIdField = definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), "groupId", Integer.TYPE);
        Class<?> bigArrayType = StateCompiler.getBigArrayType(type.getJavaType());
        Class<?> valueElementType = StateCompiler.bigArrayElementType(bigArrayType);
        FieldDefinition valueField = definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "value", bigArrayType);
        fieldDefinitions.add((Object)valueField);
        constructor.getBody().append((BytecodeNode)constructor.getThis().setField(valueField, BytecodeExpressions.newInstance((ParameterizedType)valueField.getType(), (BytecodeExpression[])new BytecodeExpression[0])));
        Function<Scope, BytecodeExpression> valueGetter = scope -> scope.getThis().getField(valueField).invoke("get", valueElementType, new BytecodeExpression[]{scope.getThis().getField(groupIdField).cast(Long.TYPE)});
        if (type.getJavaType().isPrimitive()) {
            FieldDefinition valueIdNullDefinition = definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "valueIdNull", BooleanBigArray.class);
            nullField = Optional.of(valueIdNullDefinition);
            fieldDefinitions.add((Object)valueIdNullDefinition);
            constructor.getBody().append((BytecodeNode)constructor.getThis().setField(nullField.get(), BytecodeExpressions.newInstance(BooleanBigArray.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantTrue()})));
            nullGetter = scope -> scope.getThis().getField((FieldDefinition)nullField.get()).invoke("get", Boolean.TYPE, new BytecodeExpression[]{scope.getThis().getField(groupIdField).cast(Long.TYPE)});
        } else {
            nullField = Optional.empty();
            nullGetter = scope -> BytecodeExpressions.isNull((BytecodeExpression)((BytecodeExpression)valueGetter.apply((Scope)scope)));
        }
        constructor.getBody().ret();
        StateCompiler.estimatedSize(definition, (List<FieldDefinition>)fieldDefinitions.build());
        StateCompiler.inOutGroupedSetGroupId(definition, groupIdField);
        StateCompiler.inOutGroupedEnsureCapacity(definition, valueField, nullField);
        StateCompiler.inOutGroupedCopy(definition, valueField, nullField);
        Function<Scope, BytecodeNode> setNullGenerator = scope -> {
            Variable thisVariable = scope.getThis();
            BytecodeBlock bytecodeBlock = new BytecodeBlock();
            nullField.ifPresent(field -> bytecodeBlock.append((BytecodeNode)thisVariable.getField(field).invoke("set", Void.TYPE, new BytecodeExpression[]{thisVariable.getField(groupIdField).cast(Long.TYPE), BytecodeExpressions.constantTrue()})));
            bytecodeBlock.append((BytecodeNode)thisVariable.getField(valueField).invoke("set", Void.TYPE, new BytecodeExpression[]{thisVariable.getField(groupIdField).cast(Long.TYPE), BytecodeExpressions.defaultValue((Class)valueElementType)}));
            return bytecodeBlock;
        };
        BiFunction<Scope, BytecodeExpression, BytecodeNode> setValueGenerator = (scope, value) -> {
            Variable thisVariable = scope.getThis();
            BytecodeBlock bytecodeBlock = new BytecodeBlock();
            nullField.ifPresent(field -> bytecodeBlock.append((BytecodeNode)thisVariable.getField(field).invoke("set", Void.TYPE, new BytecodeExpression[]{thisVariable.getField(groupIdField).cast(Long.TYPE), BytecodeExpressions.constantFalse()})));
            bytecodeBlock.append((BytecodeNode)thisVariable.getField(valueField).invoke("set", Void.TYPE, new BytecodeExpression[]{thisVariable.getField(groupIdField).cast(Long.TYPE), value.cast(valueElementType)}));
            return bytecodeBlock;
        };
        StateCompiler.generateInOutMethods(type, definition, valueGetter, nullGetter, setNullGenerator, setValueGenerator, callSiteBinder);
        return definition;
    }

    private static void generateInOutMethods(Type type, ClassDefinition definition, Function<Scope, BytecodeExpression> valueGetter, Function<Scope, BytecodeExpression> nullGetter, Function<Scope, BytecodeNode> setNullGenerator, BiFunction<Scope, BytecodeExpression, BytecodeNode> setValueGenerator, CallSiteBinder callSiteBinder) {
        SqlTypeBytecodeExpression sqlType = SqlTypeBytecodeExpression.constantType(callSiteBinder, type);
        StateCompiler.generateInOutGetType(definition, sqlType);
        StateCompiler.generateInOutIsNull(definition, nullGetter);
        StateCompiler.generateInOutGetBlockBuilder(definition, sqlType, valueGetter);
        StateCompiler.generateInOutSetBlockPosition(definition, sqlType, setNullGenerator, setValueGenerator);
        StateCompiler.generateInOutSetInOut(definition, type, setNullGenerator, setValueGenerator);
        StateCompiler.generateInOutGetValue(definition, type, valueGetter);
    }

    private static void estimatedSize(ClassDefinition definition) {
        FieldDefinition instanceSize = StateCompiler.generateInstanceSize(definition);
        definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getEstimatedSize", ParameterizedType.type(Long.TYPE), new Parameter[0]).getBody().getStaticField(instanceSize).retLong();
    }

    private static void estimatedSize(ClassDefinition definition, List<FieldDefinition> fieldDefinitions) {
        FieldDefinition instanceSize = StateCompiler.generateInstanceSize(definition);
        MethodDefinition getEstimatedSize = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getEstimatedSize", ParameterizedType.type(Long.TYPE), new Parameter[0]);
        BytecodeBlock body = getEstimatedSize.getBody();
        Variable size = getEstimatedSize.getScope().declareVariable("size", body, BytecodeExpressions.getStatic((FieldDefinition)instanceSize));
        for (FieldDefinition field : fieldDefinitions) {
            body.append((BytecodeNode)size.set(BytecodeExpressions.add((BytecodeExpression)size, (BytecodeExpression)getEstimatedSize.getThis().getField(field).invoke("sizeOf", Long.TYPE, new BytecodeExpression[0]))));
        }
        body.append((BytecodeNode)size.ret());
    }

    private static void inOutSingleCopy(ClassDefinition definition, FieldDefinition valueField, Optional<FieldDefinition> nullField) {
        MethodDefinition copy = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "copy", ParameterizedType.type(AccumulatorState.class), new Parameter[0]);
        Variable thisVariable = copy.getThis();
        BytecodeBlock body = copy.getBody();
        Variable copyVariable = copy.getScope().declareVariable(definition.getType(), "copy");
        body.append((BytecodeNode)copyVariable.set(BytecodeExpressions.newInstance((ParameterizedType)definition.getType(), (BytecodeExpression[])new BytecodeExpression[0])));
        body.append((BytecodeNode)copyVariable.setField(valueField, thisVariable.getField(valueField)));
        nullField.ifPresent(field -> body.append((BytecodeNode)copyVariable.setField(field, thisVariable.getField(field))));
        body.append((BytecodeNode)copyVariable.ret());
    }

    private static void inOutGroupedSetGroupId(ClassDefinition definition, FieldDefinition groupIdField) {
        Parameter groupIdArg = Parameter.arg((String)"groupId", Integer.TYPE);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "setGroupId", ParameterizedType.type(Void.TYPE), new Parameter[]{groupIdArg});
        method.getBody().append((BytecodeNode)method.getThis().setField(groupIdField, (BytecodeExpression)groupIdArg)).ret();
    }

    private static void inOutGroupedEnsureCapacity(ClassDefinition definition, FieldDefinition valueField, Optional<FieldDefinition> nullField) {
        Parameter size = Parameter.arg((String)"size", Integer.TYPE);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "ensureCapacity", ParameterizedType.type(Void.TYPE), new Parameter[]{size});
        Variable thisVariable = method.getThis();
        BytecodeBlock body = method.getBody();
        body.append((BytecodeNode)thisVariable.getField(valueField).invoke("ensureCapacity", Void.TYPE, new BytecodeExpression[]{size.cast(Long.TYPE)}));
        nullField.ifPresent(field -> body.append((BytecodeNode)thisVariable.getField(field).invoke("ensureCapacity", Void.TYPE, new BytecodeExpression[]{size.cast(Long.TYPE)})));
        body.ret();
    }

    private static void inOutGroupedCopy(ClassDefinition definition, FieldDefinition valueField, Optional<FieldDefinition> nullField) {
        MethodDefinition copy = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "copy", ParameterizedType.type(AccumulatorState.class), new Parameter[0]);
        Variable thisVariable = copy.getThis();
        BytecodeBlock body = copy.getBody();
        Variable copyVariable = copy.getScope().declareVariable(definition.getType(), "copy");
        body.append((BytecodeNode)copyVariable.set(BytecodeExpressions.newInstance((ParameterizedType)definition.getType(), (BytecodeExpression[])new BytecodeExpression[0])));
        StateCompiler.copyBigArray(body, thisVariable, copyVariable, valueField);
        nullField.ifPresent(field -> StateCompiler.copyBigArray(body, thisVariable, copyVariable, field));
        body.append((BytecodeNode)copyVariable.ret());
    }

    private static void copyBigArray(BytecodeBlock body, Variable source, Variable destination, FieldDefinition bigArrayField) {
        body.append((BytecodeNode)destination.getField(bigArrayField).invoke("ensureCapacity", Void.TYPE, new BytecodeExpression[]{source.getField(bigArrayField).invoke("getCapacity", Long.TYPE, new BytecodeExpression[0])}));
        body.append((BytecodeNode)source.getField(bigArrayField).invoke("copyTo", Void.TYPE, new BytecodeExpression[]{BytecodeExpressions.constantLong((long)0L), destination.getField(bigArrayField), BytecodeExpressions.constantLong((long)0L), source.getField(bigArrayField).invoke("getCapacity", Long.TYPE, new BytecodeExpression[0])}));
    }

    private static void generateInOutGetType(ClassDefinition definition, SqlTypeBytecodeExpression sqlType) {
        definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getType", ParameterizedType.type(Type.class), new Parameter[0]).getBody().append((BytecodeNode)sqlType.ret());
    }

    private static void generateInOutIsNull(ClassDefinition definition, Function<Scope, BytecodeExpression> nullGetter) {
        MethodDefinition isNullMethod = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "isNull", ParameterizedType.type(Boolean.TYPE), new Parameter[0]);
        isNullMethod.getBody().append((BytecodeNode)nullGetter.apply(isNullMethod.getScope()).ret());
    }

    private static void generateInOutGetBlockBuilder(ClassDefinition definition, SqlTypeBytecodeExpression sqlType, Function<Scope, BytecodeExpression> valueGetter) {
        Parameter blockBuilderArg = Parameter.arg((String)"blockBuilder", BlockBuilder.class);
        MethodDefinition getBlockBuilderMethod = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "get", ParameterizedType.type(Void.TYPE), new Parameter[]{blockBuilderArg});
        Variable thisVariable = getBlockBuilderMethod.getThis();
        BytecodeBlock body = getBlockBuilderMethod.getBody();
        body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)thisVariable.invoke("isNull", Boolean.TYPE, new BytecodeExpression[0])).ifTrue((BytecodeNode)blockBuilderArg.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop()).ifFalse((BytecodeNode)sqlType.writeValue((BytecodeExpression)blockBuilderArg, valueGetter.apply(getBlockBuilderMethod.getScope()))));
        body.ret();
    }

    private static void generateInOutSetBlockPosition(ClassDefinition definition, SqlTypeBytecodeExpression sqlType, Function<Scope, BytecodeNode> setNullGenerator, BiFunction<Scope, BytecodeExpression, BytecodeNode> setValueGenerator) {
        Parameter blockArg = Parameter.arg((String)"block", Block.class);
        Parameter positionArg = Parameter.arg((String)"position", Integer.TYPE);
        MethodDefinition setBlockBuilderMethod = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "set", ParameterizedType.type(Void.TYPE), new Parameter[]{blockArg, positionArg});
        BytecodeBlock body = setBlockBuilderMethod.getBody();
        body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)blockArg.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{positionArg})).ifTrue(setNullGenerator.apply(setBlockBuilderMethod.getScope())).ifFalse(setValueGenerator.apply(setBlockBuilderMethod.getScope(), sqlType.getValue((BytecodeExpression)blockArg, (BytecodeExpression)positionArg))));
        body.ret();
    }

    private static void generateInOutSetInOut(ClassDefinition definition, Type type, Function<Scope, BytecodeNode> setNullGenerator, BiFunction<Scope, BytecodeExpression, BytecodeNode> setValueGenerator) {
        Parameter otherState = Parameter.arg((String)"otherState", InOut.class);
        MethodDefinition setter = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "set", ParameterizedType.type(Void.TYPE), new Parameter[]{otherState});
        BytecodeBlock body = setter.getBody();
        body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)otherState.invoke("isNull", Boolean.TYPE, new BytecodeExpression[0])).ifTrue(setNullGenerator.apply(setter.getScope())).ifFalse(setValueGenerator.apply(setter.getScope(), otherState.cast(InternalDataAccessor.class).invoke(StateCompiler.inOutGetterName(type), StateCompiler.inOutGetterReturnType(type), new BytecodeExpression[0]))));
        body.ret();
    }

    private static void generateInOutGetValue(ClassDefinition definition, Type type, Function<Scope, BytecodeExpression> valueGetter) {
        MethodDefinition getter = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), StateCompiler.inOutGetterName(type), ParameterizedType.type(StateCompiler.inOutGetterReturnType(type)), new Parameter[0]);
        getter.getBody().append((BytecodeNode)valueGetter.apply(getter.getScope()).ret());
    }

    private static Class<?> inOutGetterReturnType(Type type) {
        Class javaType = type.getJavaType();
        if (javaType.equals(Boolean.TYPE)) {
            return Boolean.TYPE;
        }
        if (javaType.equals(Long.TYPE)) {
            return Long.TYPE;
        }
        if (javaType.equals(Double.TYPE)) {
            return Double.TYPE;
        }
        return Object.class;
    }

    private static String inOutGetterName(Type type) {
        Class javaType = type.getJavaType();
        if (javaType.equals(Boolean.TYPE)) {
            return "getBooleanValue";
        }
        if (javaType.equals(Long.TYPE)) {
            return "getLongValue";
        }
        if (javaType.equals(Double.TYPE)) {
            return "getDoubleValue";
        }
        return "getObjectValue";
    }

    public static <T extends AccumulatorState> AccumulatorStateFactory<T> generateStateFactory(Class<T> clazz) {
        return StateCompiler.generateStateFactory(clazz, (Map<String, Type>)ImmutableMap.of());
    }

    @VisibleForTesting
    static <T extends AccumulatorState> AccumulatorStateFactory<T> generateStateFactory(Class<T> clazz, Map<String, Type> fieldTypes) {
        AccumulatorStateMetadata metadata = StateCompiler.getMetadataAnnotation(clazz);
        if (metadata != null && metadata.stateFactoryClass() != AccumulatorStateFactory.class) {
            try {
                return (AccumulatorStateFactory)metadata.stateFactoryClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        DynamicClassLoader classLoader = new DynamicClassLoader(clazz.getClassLoader(), StateCompiler.class.getClassLoader());
        Class<T> singleStateClass = StateCompiler.generateSingleStateClass(clazz, fieldTypes, classLoader);
        Class<T> groupedStateClass = StateCompiler.generateGroupedStateClass(clazz, fieldTypes, classLoader);
        return StateCompiler.generateStateFactory(clazz, singleStateClass, groupedStateClass, classLoader);
    }

    private static <T extends AccumulatorState> AccumulatorStateFactory<T> generateStateFactory(Class<T> clazz, Class<? extends T> singleStateClass, Class<? extends T> groupedStateClass, DynamicClassLoader classLoader) {
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(clazz.getSimpleName() + "Factory"), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(AccumulatorStateFactory.class)});
        definition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}));
        definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "createSingleState", ParameterizedType.type(AccumulatorState.class), new Parameter[0]).getBody().newObject(singleStateClass).dup().invokeConstructor(singleStateClass, new Class[0]).retObject();
        definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "createGroupedState", ParameterizedType.type(AccumulatorState.class), new Parameter[0]).getBody().newObject(groupedStateClass).dup().invokeConstructor(groupedStateClass, new Class[0]).retObject();
        Class<AccumulatorStateFactory> factoryClass = CompilerUtils.defineClass(definition, AccumulatorStateFactory.class, classLoader);
        try {
            return factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> Class<? extends T> generateSingleStateClass(Class<T> clazz, Map<String, Type> fieldTypes, DynamicClassLoader classLoader) {
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("Single" + clazz.getSimpleName()), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(clazz)});
        FieldDefinition instanceSize = StateCompiler.generateInstanceSize(definition);
        definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getEstimatedSize", ParameterizedType.type(Long.TYPE), new Parameter[0]).getBody().getStaticField(instanceSize).retLong();
        MethodDefinition constructor = definition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        constructor.getBody().append((BytecodeNode)constructor.getThis()).invokeConstructor(Object.class, new Class[0]);
        List<StateField> fields = StateCompiler.enumerateFields(clazz, fieldTypes);
        ArrayList<FieldDefinition> fieldDefinitions = new ArrayList<FieldDefinition>();
        for (StateField field : fields) {
            fieldDefinitions.add(StateCompiler.generateField(definition, constructor, field));
        }
        constructor.getBody().ret();
        StateCompiler.generateCopy(definition, fields, fieldDefinitions);
        return CompilerUtils.defineClass(definition, clazz, classLoader);
    }

    private static void generateCopy(ClassDefinition definition, List<StateField> fields, List<FieldDefinition> fieldDefinitions) {
        MethodDefinition copy = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "copy", ParameterizedType.type(AccumulatorState.class), new Parameter[0]);
        Variable thisVariable = copy.getThis();
        BytecodeBlock body = copy.getBody();
        ArrayList<BytecodeExpression> fieldCopyExpressions = new ArrayList<BytecodeExpression>();
        for (int i = 0; i < fields.size(); ++i) {
            Optional<BytecodeExpression> fieldCopy = StateCompiler.copyField(thisVariable, fieldDefinitions.get(i), fields.get(i).getType());
            if (fieldCopy.isEmpty()) {
                body.append((BytecodeNode)BytecodeExpressions.newInstance(UnsupportedOperationException.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantString((String)String.format("copy not supported for %s (cannot copy field of type %s)", definition.getName(), fields.get(i).getType()))})).throwObject();
                return;
            }
            fieldCopyExpressions.add(fieldCopy.get());
        }
        Variable instanceCopy = copy.getScope().declareVariable(definition.getType(), "instanceCopy");
        body.append((BytecodeNode)instanceCopy.set(BytecodeExpressions.newInstance((ParameterizedType)definition.getType(), (BytecodeExpression[])new BytecodeExpression[0])));
        for (int i = 0; i < fieldDefinitions.size(); ++i) {
            FieldDefinition fieldDefinition = fieldDefinitions.get(i);
            Class<?> type = fields.get(i).getType();
            if (type == Long.TYPE || type == Double.TYPE || type == Boolean.TYPE || type == Byte.TYPE || type == Integer.TYPE) {
                body.append((BytecodeNode)instanceCopy.setField(fieldDefinition, (BytecodeExpression)fieldCopyExpressions.get(i)));
                continue;
            }
            body.append((BytecodeNode)new IfStatement("if field value is null", new Object[0]).condition((BytecodeNode)BytecodeExpressions.isNull((BytecodeExpression)thisVariable.getField(fieldDefinition))).ifTrue((BytecodeNode)instanceCopy.setField(fieldDefinition, thisVariable.getField(fieldDefinition))).ifFalse((BytecodeNode)instanceCopy.setField(fieldDefinition, (BytecodeExpression)fieldCopyExpressions.get(i))));
        }
        copy.getBody().append((BytecodeNode)instanceCopy.ret());
    }

    private static Optional<BytecodeExpression> copyField(Variable thisVariable, FieldDefinition fieldDefinition, Class<?> type) {
        if (type == Long.TYPE || type == Double.TYPE || type == Boolean.TYPE || type == Byte.TYPE || type == Integer.TYPE) {
            return Optional.of(thisVariable.getField(fieldDefinition));
        }
        if (type == Block.class) {
            return Optional.of(thisVariable.getField(fieldDefinition).invoke("copyRegion", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)0), thisVariable.getField(fieldDefinition).invoke("getPositionCount", Integer.TYPE, new BytecodeExpression[0])}));
        }
        return Optional.empty();
    }

    private static FieldDefinition generateInstanceSize(ClassDefinition definition) {
        FieldDefinition instanceSize = definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.STATIC, Access.FINAL}), "INSTANCE_SIZE", Long.TYPE);
        definition.getClassInitializer().getBody().append((BytecodeNode)BytecodeExpressions.setStatic((FieldDefinition)instanceSize, (BytecodeExpression)BytecodeExpressions.invokeStatic(SizeOf.class, (String)"instanceSize", Integer.TYPE, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantClass((ParameterizedType)definition.getType())}).cast(Long.TYPE)));
        return instanceSize;
    }

    private static <T> Class<? extends T> generateGroupedStateClass(Class<T> clazz, Map<String, Type> fieldTypes, DynamicClassLoader classLoader) {
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("Grouped" + clazz.getSimpleName()), ParameterizedType.type(AbstractGroupedAccumulatorState.class), new ParameterizedType[]{ParameterizedType.type(clazz)});
        List<StateField> fields = StateCompiler.enumerateFields(clazz, fieldTypes);
        MethodDefinition constructor = definition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        constructor.getBody().append((BytecodeNode)constructor.getThis()).invokeConstructor(AbstractGroupedAccumulatorState.class, new Class[0]);
        MethodDefinition ensureCapacity = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "ensureCapacity", ParameterizedType.type(Void.TYPE), new Parameter[]{Parameter.arg((String)"size", Integer.TYPE)});
        ArrayList<FieldDefinition> fieldDefinitions = new ArrayList<FieldDefinition>();
        for (StateField field : fields) {
            fieldDefinitions.add(StateCompiler.generateGroupedField(definition, constructor, ensureCapacity, field));
        }
        constructor.getBody().ret();
        ensureCapacity.getBody().ret();
        StateCompiler.estimatedSize(definition, fieldDefinitions);
        return CompilerUtils.defineClass(definition, clazz, classLoader);
    }

    private static FieldDefinition generateField(ClassDefinition definition, MethodDefinition constructor, StateField stateField) {
        FieldDefinition field = definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, stateField.getName()) + "Value", stateField.getType());
        MethodDefinition getter = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), stateField.getGetterName(), ParameterizedType.type(stateField.getType()), new Parameter[0]);
        getter.getBody().append((BytecodeNode)getter.getThis().getField(field).ret());
        Parameter value = Parameter.arg((String)"value", stateField.getType());
        MethodDefinition setter = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), stateField.getSetterName(), ParameterizedType.type(Void.TYPE), new Parameter[]{value});
        setter.getBody().append((BytecodeNode)setter.getThis().setField(field, (BytecodeExpression)value)).ret();
        constructor.getBody().append((BytecodeNode)constructor.getThis().setField(field, stateField.initialValueExpression()));
        return field;
    }

    private static FieldDefinition generateGroupedField(ClassDefinition definition, MethodDefinition constructor, MethodDefinition ensureCapacity, StateField stateField) {
        Class<?> bigArrayType = StateCompiler.getBigArrayType(stateField.getType());
        FieldDefinition field = definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, stateField.getName()) + "Values", bigArrayType);
        MethodDefinition getter = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), stateField.getGetterName(), ParameterizedType.type(stateField.getType()), new Parameter[0]);
        getter.getBody().append((BytecodeNode)getter.getThis().getField(field).invoke("get", stateField.getType(), new BytecodeExpression[]{getter.getThis().invoke("getGroupId", Integer.TYPE, new BytecodeExpression[0]).cast(Long.TYPE)}).ret());
        Parameter value = Parameter.arg((String)"value", stateField.getType());
        MethodDefinition setter = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), stateField.getSetterName(), ParameterizedType.type(Void.TYPE), new Parameter[]{value});
        setter.getBody().append((BytecodeNode)setter.getThis().getField(field).invoke("set", Void.TYPE, new BytecodeExpression[]{setter.getThis().invoke("getGroupId", Integer.TYPE, new BytecodeExpression[0]).cast(Long.TYPE), value})).ret();
        Scope ensureCapacityScope = ensureCapacity.getScope();
        ensureCapacity.getBody().append((BytecodeNode)ensureCapacity.getThis().getField(field).invoke("ensureCapacity", Void.TYPE, new BytecodeExpression[]{ensureCapacityScope.getVariable("size").cast(Long.TYPE)}));
        constructor.getBody().append((BytecodeNode)constructor.getThis().setField(field, BytecodeExpressions.newInstance((ParameterizedType)field.getType(), (BytecodeExpression[])new BytecodeExpression[]{stateField.initialValueExpression()})));
        return field;
    }

    private static List<StateField> enumerateFields(Class<?> clazz, Map<String, Type> fieldTypes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Method method : clazz.getMethods()) {
            String name;
            Class<?> type;
            if (method.isDefault() || method.getName().equals("getEstimatedSize")) continue;
            if (method.getName().startsWith("get")) {
                type = method.getReturnType();
                name = method.getName().substring(3);
                builder.add((Object)new StateField(name, type, StateCompiler.getInitialValue(method), method.getName(), Optional.ofNullable(fieldTypes.get(name))));
            }
            if (!method.getName().startsWith("is")) continue;
            type = method.getReturnType();
            Preconditions.checkArgument((type == Boolean.TYPE ? 1 : 0) != 0, (Object)"Only boolean is support for 'is' methods");
            name = method.getName().substring(2);
            builder.add((Object)new StateField(name, type, StateCompiler.getInitialValue(method), method.getName(), Optional.of(BooleanType.BOOLEAN)));
        }
        Ordering<StateField> ordering = new Ordering<StateField>(){

            public int compare(StateField left, StateField right) {
                return left.getName().compareTo(right.getName());
            }
        };
        List fields = ordering.sortedCopy((Iterable)builder.build());
        StateCompiler.checkInterface(clazz, fields);
        return fields;
    }

    private static Object getInitialValue(Method method) {
        Constable value = null;
        for (Annotation annotation : method.getAnnotations()) {
            if (annotation instanceof InitialLongValue) {
                Preconditions.checkArgument((value == null ? 1 : 0) != 0, (String)"%s has multiple initialValue annotations", (Object)method.getName());
                Preconditions.checkArgument((method.getReturnType() == Long.TYPE ? 1 : 0) != 0, (String)"%s does not return a long, but is annotated with @InitialLongValue", (Object)method.getName());
                value = ((InitialLongValue)annotation).value();
                continue;
            }
            if (annotation instanceof InitialDoubleValue) {
                Preconditions.checkArgument((value == null ? 1 : 0) != 0, (String)"%s has multiple initialValue annotations", (Object)method.getName());
                Preconditions.checkArgument((method.getReturnType() == Double.TYPE ? 1 : 0) != 0, (String)"%s does not return a double, but is annotated with @InitialDoubleValue", (Object)method.getName());
                value = ((InitialDoubleValue)annotation).value();
                continue;
            }
            if (!(annotation instanceof InitialBooleanValue)) continue;
            Preconditions.checkArgument((value == null ? 1 : 0) != 0, (String)"%s has multiple initialValue annotations", (Object)method.getName());
            Preconditions.checkArgument((method.getReturnType() == Boolean.TYPE ? 1 : 0) != 0, (String)"%s does not return a boolean, but is annotated with @InitialBooleanValue", (Object)method.getName());
            value = Boolean.valueOf(((InitialBooleanValue)annotation).value());
        }
        return value;
    }

    private static void checkInterface(Class<?> clazz, List<StateField> fields) {
        Preconditions.checkArgument((boolean)clazz.isInterface(), (Object)(clazz.getName() + " is not an interface"));
        HashSet<String> setters = new HashSet<String>();
        HashSet<String> getters = new HashSet<String>();
        HashSet<String> isGetters = new HashSet<String>();
        HashMap fieldTypes = new HashMap();
        for (StateField field : fields) {
            fieldTypes.put(field.getName(), field.getType());
        }
        for (Method method : clazz.getMethods()) {
            String name;
            if (Modifier.isStatic(method.getModifiers()) || method.isDefault()) continue;
            if (method.getName().equals("copy")) {
                Preconditions.checkArgument((method.getParameterTypes().length == 0 ? 1 : 0) != 0, (Object)"copy may not have parameters");
                continue;
            }
            if (method.getName().equals("getEstimatedSize")) {
                Preconditions.checkArgument((boolean)method.getReturnType().equals(Long.TYPE), (Object)"getEstimatedSize must return long");
                Preconditions.checkArgument((method.getParameterTypes().length == 0 ? 1 : 0) != 0, (Object)"getEstimatedSize may not have parameters");
                continue;
            }
            if (method.getName().startsWith("get")) {
                name = method.getName().substring(3);
                Preconditions.checkArgument((boolean)((Class)fieldTypes.get(name)).equals(method.getReturnType()), (String)"Expected %s to return type %s, but found %s", (Object)method.getName(), fieldTypes.get(name), method.getReturnType());
                Preconditions.checkArgument((method.getParameterTypes().length == 0 ? 1 : 0) != 0, (String)"Expected %s to have zero parameters", (Object)method.getName());
                getters.add(name);
                continue;
            }
            if (method.getName().startsWith("is")) {
                name = method.getName().substring(2);
                Preconditions.checkArgument((fieldTypes.get(name) == Boolean.TYPE ? 1 : 0) != 0, (String)"Expected %s to have type boolean, but found %s", (Object)name, fieldTypes.get(name));
                Preconditions.checkArgument((method.getParameterTypes().length == 0 ? 1 : 0) != 0, (String)"Expected %s to have zero parameters", (Object)method.getName());
                Preconditions.checkArgument((method.getReturnType() == Boolean.TYPE ? 1 : 0) != 0, (String)"Expected %s to return boolean", (Object)method.getName());
                isGetters.add(name);
                continue;
            }
            if (method.getName().startsWith("set")) {
                name = method.getName().substring(3);
                Preconditions.checkArgument((method.getParameterTypes().length == 1 ? 1 : 0) != 0, (Object)"Expected setter to have one parameter");
                Preconditions.checkArgument((boolean)((Class)fieldTypes.get(name)).equals(method.getParameterTypes()[0]), (String)"Expected %s to accept type %s, but found %s", (Object)method.getName(), fieldTypes.get(name), method.getParameterTypes()[0]);
                Preconditions.checkArgument((StateCompiler.getInitialValue(method) == null ? 1 : 0) != 0, (Object)"initial value annotation not allowed on setter");
                Preconditions.checkArgument((boolean)method.getReturnType().equals(Void.TYPE), (String)"%s may not return a value", (Object)method.getName());
                setters.add(name);
                continue;
            }
            throw new IllegalArgumentException("Cannot generate implementation for method: " + method.getName());
        }
        Preconditions.checkArgument((getters.size() + isGetters.size() == setters.size() && setters.size() == fields.size() ? 1 : 0) != 0, (Object)"Wrong number of getters/setters");
    }

    private static final class StateField {
        private final String name;
        private final String getterName;
        private final Class<?> type;
        private final Object initialValue;
        private final Optional<Type> sqlType;

        private StateField(String name, Class<?> type, Object initialValue, String getterName, Optional<Type> sqlType) {
            this.name = Objects.requireNonNull(name, "name is null");
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"name is empty");
            this.type = Objects.requireNonNull(type, "type is null");
            this.getterName = Objects.requireNonNull(getterName, "getterName is null");
            this.initialValue = initialValue;
            Objects.requireNonNull(sqlType, "sqlType is null");
            if (sqlType.isPresent()) {
                Preconditions.checkArgument((type.isAssignableFrom(sqlType.get().getJavaType()) || type == Byte.TYPE && TinyintType.TINYINT.equals((Object)sqlType.get()) || type == Integer.TYPE && IntegerType.INTEGER.equals((Object)sqlType.get()) ? 1 : 0) != 0, (String)"Stack type (%s) and provided sql type (%s) are incompatible", (Object)type.getName(), (Object)sqlType.get().getDisplayName());
            } else {
                sqlType = StateField.sqlTypeFromStackType(type);
            }
            this.sqlType = sqlType;
        }

        private static Optional<Type> sqlTypeFromStackType(Class<?> stackType) {
            if (stackType == Long.TYPE) {
                return Optional.of(BigintType.BIGINT);
            }
            if (stackType == Double.TYPE) {
                return Optional.of(DoubleType.DOUBLE);
            }
            if (stackType == Boolean.TYPE) {
                return Optional.of(BooleanType.BOOLEAN);
            }
            if (stackType == Byte.TYPE) {
                return Optional.of(TinyintType.TINYINT);
            }
            if (stackType == Integer.TYPE) {
                return Optional.of(IntegerType.INTEGER);
            }
            if (stackType == Slice.class) {
                return Optional.of(VarbinaryType.VARBINARY);
            }
            return Optional.empty();
        }

        String getGetterName() {
            return this.getterName;
        }

        String getSetterName() {
            return "set" + this.getName();
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        Type getSqlType() {
            return this.sqlType.orElseThrow(() -> new IllegalArgumentException("Unsupported type: " + String.valueOf(this.type)));
        }

        boolean isPrimitiveType() {
            Class<?> type = this.getType();
            return type == Long.TYPE || type == Double.TYPE || type == Boolean.TYPE || type == Byte.TYPE || type == Integer.TYPE;
        }

        public BytecodeExpression initialValueExpression() {
            Object object = this.initialValue;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, Boolean.class}, (Object)object, n)) {
                case -1 -> BytecodeExpressions.defaultValue(this.type);
                case 0 -> {
                    Number number = (Number)object;
                    yield BytecodeExpressions.constantNumber((Number)number);
                }
                case 1 -> BytecodeExpressions.constantBoolean((boolean)((Boolean)this.initialValue));
                default -> throw new IllegalArgumentException("Unsupported initial value type: " + String.valueOf(this.initialValue.getClass()));
            };
        }
    }
}

