/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.exchange;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.operator.DriverContext;
import io.trino.operator.LocalPlannerAware;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.exchange.LocalExchange;
import io.trino.operator.exchange.LocalExchangeSink;
import io.trino.spi.Page;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Objects;
import java.util.function.Function;

public class LocalExchangeSinkOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final LocalExchangeSink sink;
    private final Function<Page, Page> pagePreprocessor;
    private ListenableFuture<Void> isBlocked = NOT_BLOCKED;

    LocalExchangeSinkOperator(OperatorContext operatorContext, LocalExchangeSink sink, Function<Page, Page> pagePreprocessor) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.sink = Objects.requireNonNull(sink, "sink is null");
        this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
        operatorContext.setFinishedFuture(sink.isFinished());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.sink.finish();
    }

    @Override
    public boolean isFinished() {
        return this.sink.isFinished().isDone();
    }

    @Override
    public ListenableFuture<Void> isBlocked() {
        if (this.isBlocked.isDone()) {
            this.isBlocked = this.sink.waitForWriting();
            if (this.isBlocked.isDone()) {
                this.isBlocked = NOT_BLOCKED;
            }
        }
        return this.isBlocked;
    }

    @Override
    public boolean needsInput() {
        return !this.isFinished() && this.isBlocked().isDone();
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        page = this.pagePreprocessor.apply(page);
        this.operatorContext.recordOutput(page.getSizeInBytes(), page.getPositionCount());
        this.sink.addPage(page);
    }

    @Override
    public Page getOutput() {
        return null;
    }

    @Override
    public void close() {
        this.finish();
    }

    public static class LocalExchangeSinkOperatorFactory
    implements OperatorFactory,
    LocalPlannerAware {
        private final int operatorId;
        private final LocalExchange.LocalExchangeSinkFactory sinkFactory;
        private final PlanNodeId planNodeId;
        private final Function<Page, Page> pagePreprocessor;
        private boolean closed;

        public LocalExchangeSinkOperatorFactory(LocalExchange.LocalExchangeSinkFactory sinkFactory, int operatorId, PlanNodeId planNodeId, Function<Page, Page> pagePreprocessor) {
            this.sinkFactory = Objects.requireNonNull(sinkFactory, "sinkFactory is null");
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, LocalExchangeSinkOperator.class.getSimpleName());
            return new LocalExchangeSinkOperator(operatorContext, this.sinkFactory.createSink(), this.pagePreprocessor);
        }

        @Override
        public void noMoreOperators() {
            if (!this.closed) {
                this.closed = true;
                this.sinkFactory.close();
            }
        }

        @Override
        public OperatorFactory duplicate() {
            return new LocalExchangeSinkOperatorFactory(this.sinkFactory.duplicate(), this.operatorId, this.planNodeId, this.pagePreprocessor);
        }

        @Override
        public void localPlannerComplete() {
            this.sinkFactory.noMoreSinkFactories();
        }
    }
}

