/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.exchange;

import com.google.common.util.concurrent.ListenableFuture;
import io.trino.operator.exchange.LocalExchangeMemoryManager;
import io.trino.operator.exchange.LocalExchangeSource;
import io.trino.operator.exchange.LocalExchanger;
import io.trino.spi.Page;
import java.util.Objects;

public class PassthroughExchanger
implements LocalExchanger {
    private final LocalExchangeSource localExchangeSource;
    private final LocalExchangeMemoryManager bufferMemoryManager;

    public PassthroughExchanger(LocalExchangeSource localExchangeSource, LocalExchangeMemoryManager bufferMemoryManager) {
        this.localExchangeSource = Objects.requireNonNull(localExchangeSource, "localExchangeSource is null");
        this.bufferMemoryManager = Objects.requireNonNull(bufferMemoryManager, "bufferMemoryManager is null");
    }

    @Override
    public void accept(Page page) {
        this.bufferMemoryManager.updateMemoryUsage(page.getRetainedSizeInBytes());
        this.localExchangeSource.addPage(page);
    }

    @Override
    public ListenableFuture<Void> waitForWriting() {
        return this.bufferMemoryManager.getNotFullFuture();
    }

    @Override
    public void finish() {
        this.localExchangeSource.finish();
    }
}

