/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.function;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.operator.PagesIndex;
import io.trino.operator.WorkProcessor;
import io.trino.operator.function.TableFunctionPartition;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.function.table.TableFunctionDataProcessor;
import io.trino.spi.function.table.TableFunctionProcessorState;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class RegularTableFunctionPartition
implements TableFunctionPartition {
    private final PagesIndex pagesIndex;
    private final int partitionStart;
    private final int partitionEnd;
    private final Iterator<Page> sortedPages;
    private final TableFunctionDataProcessor tableFunction;
    private final int properChannelsCount;
    private final int passThroughSourcesCount;
    private final int[][] requiredChannels;
    private final int[] endOfData;
    private final PassThroughColumnProvider[] passThroughProviders;
    private int processedPositions;

    public RegularTableFunctionPartition(PagesIndex pagesIndex, int partitionStart, int partitionEnd, TableFunctionDataProcessor tableFunction, int properChannelsCount, int passThroughSourcesCount, List<List<Integer>> requiredChannels, Optional<Map<Integer, Integer>> markerChannels, List<PassThroughColumnSpecification> passThroughSpecifications) {
        Preconditions.checkArgument((pagesIndex.getPositionCount() != 0 ? 1 : 0) != 0, (Object)"PagesIndex is empty for regular table function partition");
        this.pagesIndex = pagesIndex;
        this.partitionStart = partitionStart;
        this.partitionEnd = partitionEnd;
        this.sortedPages = pagesIndex.getSortedPages(partitionStart, partitionEnd);
        this.tableFunction = Objects.requireNonNull(tableFunction, "tableFunction is null");
        this.properChannelsCount = properChannelsCount;
        this.passThroughSourcesCount = passThroughSourcesCount;
        this.requiredChannels = (int[][])requiredChannels.stream().map(Ints::toArray).toArray(x$0 -> new int[x$0][]);
        this.endOfData = this.findEndOfData(markerChannels, requiredChannels, passThroughSpecifications);
        for (List<Integer> channels : requiredChannels) {
            Preconditions.checkState((channels.stream().mapToInt(channel -> this.endOfData[channel]).distinct().count() <= 1L ? 1 : 0) != 0, (Object)"end-of-data position is inconsistent within a table function source");
        }
        this.passThroughProviders = new PassThroughColumnProvider[passThroughSpecifications.size()];
        for (int i = 0; i < passThroughSpecifications.size(); ++i) {
            this.passThroughProviders[i] = this.createColumnProvider(passThroughSpecifications.get(i));
        }
    }

    @Override
    public WorkProcessor<Page> toOutputPages() {
        return WorkProcessor.create(new WorkProcessor.Process<Page>(){
            List<Optional<Page>> inputPages;
            {
                this.inputPages = RegularTableFunctionPartition.this.prepareInputPages();
            }

            @Override
            public WorkProcessor.ProcessState<Page> process() {
                boolean functionGotNoData;
                TableFunctionProcessorState state = RegularTableFunctionPartition.this.tableFunction.process(this.inputPages);
                boolean bl = functionGotNoData = this.inputPages == null;
                if (state == TableFunctionProcessorState.Finished.FINISHED) {
                    return WorkProcessor.ProcessState.finished();
                }
                if (state instanceof TableFunctionProcessorState.Blocked) {
                    TableFunctionProcessorState.Blocked blocked = (TableFunctionProcessorState.Blocked)state;
                    return WorkProcessor.ProcessState.blocked((ListenableFuture<Void>)MoreFutures.toListenableFuture((CompletableFuture)blocked.getFuture()));
                }
                TableFunctionProcessorState.Processed processed = (TableFunctionProcessorState.Processed)state;
                if (processed.isUsedInput()) {
                    this.inputPages = RegularTableFunctionPartition.this.prepareInputPages();
                }
                if (processed.getResult() != null) {
                    return WorkProcessor.ProcessState.ofResult(RegularTableFunctionPartition.this.appendPassThroughColumns(processed.getResult()));
                }
                if (functionGotNoData) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "When function got no input, it should either produce output or return Blocked state");
                }
                return WorkProcessor.ProcessState.blocked((ListenableFuture<Void>)Futures.immediateFuture(null));
            }
        });
    }

    private List<Optional<Page>> prepareInputPages() {
        if (!this.sortedPages.hasNext()) {
            return null;
        }
        Page inputPage = this.sortedPages.next();
        ImmutableList.Builder sourcePages = ImmutableList.builder();
        for (int[] channelsForSource : this.requiredChannels) {
            if (channelsForSource.length == 0) {
                sourcePages.add(Optional.of(new Page(inputPage.getPositionCount())));
                continue;
            }
            int endOfDataForSource = this.endOfData[channelsForSource[0]];
            if (endOfDataForSource <= this.processedPositions) {
                sourcePages.add(Optional.empty());
                continue;
            }
            Block[] sourceBlocks = new Block[channelsForSource.length];
            if (endOfDataForSource < this.processedPositions + inputPage.getPositionCount()) {
                for (i = 0; i < channelsForSource.length; ++i) {
                    inputChannel = channelsForSource[i];
                    sourceBlocks[i] = inputPage.getBlock(inputChannel).getRegion(0, endOfDataForSource - this.processedPositions);
                }
            } else {
                for (i = 0; i < channelsForSource.length; ++i) {
                    inputChannel = channelsForSource[i];
                    sourceBlocks[i] = inputPage.getBlock(inputChannel);
                }
            }
            sourcePages.add(Optional.of(new Page(sourceBlocks)));
        }
        this.processedPositions += inputPage.getPositionCount();
        return sourcePages.build();
    }

    private Page appendPassThroughColumns(Page page) {
        int channel;
        if (page.getChannelCount() != this.properChannelsCount + this.passThroughSourcesCount) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format("Table function returned a page containing %s channels. Expected channel number: %s (%s proper columns, %s pass-through index columns)", page.getChannelCount(), this.properChannelsCount + this.passThroughSourcesCount, this.properChannelsCount, this.passThroughSourcesCount));
        }
        Block[] resultBlocks = new Block[this.properChannelsCount + this.passThroughProviders.length];
        for (channel = 0; channel < this.properChannelsCount; ++channel) {
            resultBlocks[channel] = page.getBlock(channel);
        }
        channel = this.properChannelsCount;
        for (PassThroughColumnProvider provider : this.passThroughProviders) {
            resultBlocks[channel] = provider.getPassThroughColumn(page);
            ++channel;
        }
        return new Page(page.getPositionCount(), resultBlocks);
    }

    private int[] findEndOfData(Optional<Map<Integer, Integer>> markerChannels, List<List<Integer>> requiredChannels, List<PassThroughColumnSpecification> passThroughSpecifications) {
        ImmutableSet referencedChannels = ImmutableSet.builder().addAll((Iterable)requiredChannels.stream().flatMap(Collection::stream).collect(ImmutableList.toImmutableList())).addAll((Iterable)passThroughSpecifications.stream().map(PassThroughColumnSpecification::inputChannel).collect(ImmutableList.toImmutableList())).build();
        if (referencedChannels.isEmpty()) {
            return null;
        }
        int maxInputChannel = referencedChannels.stream().mapToInt(Integer::intValue).max().orElseThrow();
        int[] result = new int[maxInputChannel + 1];
        Arrays.fill(result, -1);
        if (markerChannels.isEmpty()) {
            referencedChannels.stream().forEach(channel -> {
                result[channel.intValue()] = this.partitionEnd - this.partitionStart;
            });
            return result;
        }
        ImmutableMap.Builder endOfDataPerMarkerBuilder = ImmutableMap.builder();
        UnmodifiableIterator unmodifiableIterator = ImmutableSet.copyOf(markerChannels.orElseThrow().values()).iterator();
        while (unmodifiableIterator.hasNext()) {
            int markerChannel = (Integer)unmodifiableIterator.next();
            endOfDataPerMarkerBuilder.put((Object)markerChannel, (Object)this.findFirstNullPosition(markerChannel));
        }
        ImmutableMap endOfDataPerMarker = endOfDataPerMarkerBuilder.buildOrThrow();
        referencedChannels.stream().forEach(arg_0 -> this.lambda$findEndOfData$3(result, (Map)endOfDataPerMarker, markerChannels, arg_0));
        return result;
    }

    private int findFirstNullPosition(int markerChannel) {
        if (this.pagesIndex.isNull(markerChannel, this.partitionStart)) {
            return this.partitionStart;
        }
        if (!this.pagesIndex.isNull(markerChannel, this.partitionEnd - 1)) {
            return this.partitionEnd;
        }
        int start = this.partitionStart;
        int end = this.partitionEnd;
        while (end - start > 1) {
            int mid = start + end >>> 1;
            if (this.pagesIndex.isNull(markerChannel, mid)) {
                end = mid;
                continue;
            }
            start = mid;
        }
        return end;
    }

    private PassThroughColumnProvider createColumnProvider(PassThroughColumnSpecification specification) {
        if (specification.isPartitioningColumn()) {
            return new PartitioningColumnProvider(this.pagesIndex.getSingleValueBlock(specification.inputChannel(), this.partitionStart));
        }
        return new NonPartitioningColumnProvider(specification.inputChannel(), specification.indexChannel());
    }

    private /* synthetic */ void lambda$findEndOfData$3(int[] result, Map endOfDataPerMarker, Optional markerChannels, Integer channel) {
        result[channel.intValue()] = (Integer)endOfDataPerMarker.get(((Map)markerChannels.orElseThrow()).get(channel)) - this.partitionStart;
    }

    private static sealed interface PassThroughColumnProvider
    permits PartitioningColumnProvider, NonPartitioningColumnProvider {
        public Block getPassThroughColumn(Page var1);
    }

    public record PassThroughColumnSpecification(boolean isPartitioningColumn, int inputChannel, int indexChannel) {
    }

    private record PartitioningColumnProvider(Block partitioningValue) implements PassThroughColumnProvider
    {
        private PartitioningColumnProvider {
            Objects.requireNonNull(partitioningValue, "partitioningValue is null");
        }

        @Override
        public Block getPassThroughColumn(Page page) {
            return RunLengthEncodedBlock.create((Block)this.partitioningValue, (int)page.getPositionCount());
        }
    }

    private final class NonPartitioningColumnProvider
    implements PassThroughColumnProvider {
        private final int inputChannel;
        private final Type type;
        private final int indexChannel;

        public NonPartitioningColumnProvider(int inputChannel, int indexChannel) {
            this.inputChannel = inputChannel;
            this.type = RegularTableFunctionPartition.this.pagesIndex.getType(inputChannel);
            this.indexChannel = indexChannel;
        }

        @Override
        public Block getPassThroughColumn(Page page) {
            Block indexes = page.getBlock(this.indexChannel);
            BlockBuilder builder = this.type.createBlockBuilder(null, page.getPositionCount());
            for (int position = 0; position < page.getPositionCount(); ++position) {
                if (indexes.isNull(position)) {
                    builder.appendNull();
                    continue;
                }
                long index = BigintType.BIGINT.getLong(indexes, position);
                if (index < 0L || index >= (long)RegularTableFunctionPartition.this.endOfData[this.inputChannel] || index >= (long)RegularTableFunctionPartition.this.processedPositions) {
                    int end = Math.min(RegularTableFunctionPartition.this.endOfData[this.inputChannel], RegularTableFunctionPartition.this.processedPositions) - 1;
                    if (end >= 0) {
                        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format("Index of a pass-through row: %s out of processed portion of partition [0, %s]", index, end));
                    }
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Index of a pass-through row must be null when no input data from the partition was processed. Actual: " + index);
                }
                long absoluteIndex = (long)RegularTableFunctionPartition.this.partitionStart + index;
                RegularTableFunctionPartition.this.pagesIndex.appendTo(this.inputChannel, Math.toIntExact(absoluteIndex), builder);
            }
            return builder.build();
        }
    }
}

