/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.block.Block;
import io.trino.spi.block.BufferedArrayValueBuilder;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;
import it.unimi.dsi.fastutil.ints.IntArrayList;

@ScalarFunction(value="array_sort")
@Description(value="Sorts the given array in ascending order according to the natural ordering of its elements.")
public final class ArraySortFunction {
    public static final String NAME = "array_sort";
    private final BufferedArrayValueBuilder arrayValueBuilder;
    private static final int INITIAL_LENGTH = 128;
    private final IntArrayList positions = new IntArrayList(128);

    @TypeParameter(value="E")
    public ArraySortFunction(@TypeParameter(value="E") Type elementType) {
        this.arrayValueBuilder = BufferedArrayValueBuilder.createBuffered((ArrayType)new ArrayType(elementType));
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block sort(@OperatorDependency(operator=OperatorType.COMPARISON_UNORDERED_LAST, argumentTypes={"E", "E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionComparison comparisonOperator, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block block) {
        int arrayLength = block.getPositionCount();
        this.positions.clear();
        for (int i = 0; i < arrayLength; ++i) {
            this.positions.add(i);
        }
        this.positions.subList(0, arrayLength).sort((left, right) -> {
            boolean nullLeft = block.isNull(left);
            boolean nullRight = block.isNull(right);
            if (nullLeft && nullRight) {
                return 0;
            }
            if (nullLeft) {
                return 1;
            }
            if (nullRight) {
                return -1;
            }
            return (int)comparisonOperator.compare(block, left, block, right);
        });
        return this.arrayValueBuilder.build(arrayLength, elementBuilder -> {
            for (int i = 0; i < arrayLength; ++i) {
                type.appendTo(block, this.positions.getInt(i), elementBuilder);
            }
        });
    }
}

