/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import java.util.Map;
import java.util.function.Supplier;
import org.tartarus.snowball.SnowballStemmer;
import org.tartarus.snowball.ext.ArmenianStemmer;
import org.tartarus.snowball.ext.BasqueStemmer;
import org.tartarus.snowball.ext.CatalanStemmer;
import org.tartarus.snowball.ext.DanishStemmer;
import org.tartarus.snowball.ext.DutchStemmer;
import org.tartarus.snowball.ext.EnglishStemmer;
import org.tartarus.snowball.ext.FinnishStemmer;
import org.tartarus.snowball.ext.FrenchStemmer;
import org.tartarus.snowball.ext.GermanStemmer;
import org.tartarus.snowball.ext.HungarianStemmer;
import org.tartarus.snowball.ext.IrishStemmer;
import org.tartarus.snowball.ext.ItalianStemmer;
import org.tartarus.snowball.ext.LithuanianStemmer;
import org.tartarus.snowball.ext.NorwegianStemmer;
import org.tartarus.snowball.ext.PortugueseStemmer;
import org.tartarus.snowball.ext.RomanianStemmer;
import org.tartarus.snowball.ext.RussianStemmer;
import org.tartarus.snowball.ext.SpanishStemmer;
import org.tartarus.snowball.ext.SwedishStemmer;
import org.tartarus.snowball.ext.TurkishStemmer;

public final class WordStemFunction {
    private static final Map<Slice, Supplier<SnowballStemmer>> STEMMERS = ImmutableMap.builder().put((Object)Slices.utf8Slice((String)"ca"), CatalanStemmer::new).put((Object)Slices.utf8Slice((String)"da"), DanishStemmer::new).put((Object)Slices.utf8Slice((String)"de"), GermanStemmer::new).put((Object)Slices.utf8Slice((String)"en"), EnglishStemmer::new).put((Object)Slices.utf8Slice((String)"es"), SpanishStemmer::new).put((Object)Slices.utf8Slice((String)"eu"), BasqueStemmer::new).put((Object)Slices.utf8Slice((String)"fi"), FinnishStemmer::new).put((Object)Slices.utf8Slice((String)"fr"), FrenchStemmer::new).put((Object)Slices.utf8Slice((String)"hu"), HungarianStemmer::new).put((Object)Slices.utf8Slice((String)"hy"), ArmenianStemmer::new).put((Object)Slices.utf8Slice((String)"ir"), IrishStemmer::new).put((Object)Slices.utf8Slice((String)"it"), ItalianStemmer::new).put((Object)Slices.utf8Slice((String)"lt"), LithuanianStemmer::new).put((Object)Slices.utf8Slice((String)"nl"), DutchStemmer::new).put((Object)Slices.utf8Slice((String)"no"), NorwegianStemmer::new).put((Object)Slices.utf8Slice((String)"pt"), PortugueseStemmer::new).put((Object)Slices.utf8Slice((String)"ro"), RomanianStemmer::new).put((Object)Slices.utf8Slice((String)"ru"), RussianStemmer::new).put((Object)Slices.utf8Slice((String)"sv"), SwedishStemmer::new).put((Object)Slices.utf8Slice((String)"tr"), TurkishStemmer::new).buildOrThrow();

    private WordStemFunction() {
    }

    @Description(value="Returns the stem of a word in the English language")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice wordStem(@SqlType(value="varchar(x)") Slice slice) {
        return WordStemFunction.wordStem(slice, (SnowballStemmer)new EnglishStemmer());
    }

    @Description(value="Returns the stem of a word in the given language")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice wordStem(@SqlType(value="varchar(x)") Slice slice, @SqlType(value="varchar(2)") Slice language) {
        Supplier<SnowballStemmer> stemmer = STEMMERS.get(language);
        if (stemmer == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Unknown stemmer language: " + language.toStringUtf8());
        }
        return WordStemFunction.wordStem(slice, stemmer.get());
    }

    private static Slice wordStem(Slice slice, SnowballStemmer stemmer) {
        stemmer.setCurrent(slice.toStringUtf8());
        return stemmer.stem() ? Slices.utf8Slice((String)stemmer.getCurrent()) : slice;
    }
}

