/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.json;

import com.fasterxml.jackson.databind.node.NullNode;
import io.trino.json.JsonEmptySequenceNode;
import io.trino.json.ir.TypedValue;
import io.trino.spi.block.Block;
import io.trino.spi.block.SqlRow;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.analyzer.ExpressionAnalyzer;
import io.trino.type.Json2016Type;

public final class ParameterUtil {
    private ParameterUtil() {
    }

    public static Object[] getParametersArray(Type parametersRowType, SqlRow parametersRow) {
        if (ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE.equals((Object)parametersRowType)) {
            return new Object[0];
        }
        RowType rowType = (RowType)parametersRowType;
        int rawIndex = parametersRow.getRawIndex();
        Object[] array = new Object[rowType.getFields().size()];
        for (int i = 0; i < rowType.getFields().size(); ++i) {
            Type type = ((RowType.Field)rowType.getFields().get(i)).getType();
            Object value = TypeUtils.readNativeValue((Type)type, (Block)parametersRow.getRawFieldBlock(i), (int)rawIndex);
            if (type.equals((Object)Json2016Type.JSON_2016)) {
                if (value == null) {
                    array[i] = JsonEmptySequenceNode.EMPTY_SEQUENCE;
                    continue;
                }
                array[i] = value;
                continue;
            }
            array[i] = value == null ? NullNode.getInstance() : TypedValue.fromValueAsObject(type, value);
        }
        return array;
    }
}

