/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamp;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.operator.scalar.SequenceFunction;
import io.trino.operator.scalar.timestamp.DateDiff;
import io.trino.operator.scalar.timestamp.TimestampOperators;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.TimestampType;

@ScalarFunction(value="sequence")
public final class SequenceIntervalYearToMonth {
    private static final TimestampType SHORT_TYPE = TimestampType.createTimestampType((int)0);
    private static final TimestampType LONG_TYPE = TimestampType.createTimestampType((int)7);
    private static final Slice MONTH = Slices.utf8Slice((String)"month");

    private SequenceIntervalYearToMonth() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="array(timestamp(p))")
    public static Block sequence(@SqlType(value="timestamp(p)") long start, @SqlType(value="timestamp(p)") long stop, @SqlType(value="interval year to month") long step) {
        SequenceFunction.checkValidStep(start, stop, step);
        int length = SequenceFunction.checkMaxEntry(DateDiff.diff(MONTH, start, stop) / step + 1L);
        BlockBuilder blockBuilder = SHORT_TYPE.createFixedSizeBlockBuilder(length);
        long offset = 0L;
        for (int i = 0; i < length; ++i) {
            long value = TimestampOperators.TimestampPlusIntervalYearToMonth.add(start, offset);
            SHORT_TYPE.writeLong(blockBuilder, value);
            offset += step;
        }
        return blockBuilder.build();
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="array(timestamp(p))")
    public static Block sequence(ConnectorSession session, @SqlType(value="timestamp(p)") LongTimestamp start, @SqlType(value="timestamp(p)") LongTimestamp stop, @SqlType(value="interval year to month") long step) {
        SequenceFunction.checkValidStep(start.getEpochMicros(), stop.getEpochMicros(), step);
        int length = SequenceFunction.checkMaxEntry(DateDiff.diff(MONTH, start, stop) / step + 1L);
        BlockBuilder blockBuilder = LONG_TYPE.createFixedSizeBlockBuilder(length);
        long offset = 0L;
        for (int i = 0; i < length; ++i) {
            LongTimestamp value = TimestampOperators.TimestampPlusIntervalYearToMonth.add(start, offset);
            LONG_TYPE.writeObject(blockBuilder, (Object)value);
            offset += step;
        }
        return blockBuilder.build();
    }
}

