/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.server.QueryStateInfo;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.resourcegroups.ResourceGroupState;
import io.trino.spi.resourcegroups.SchedulingPolicy;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public record ResourceGroupInfo(ResourceGroupId id, ResourceGroupState state, SchedulingPolicy schedulingPolicy, int schedulingWeight, DataSize softMemoryLimit, int softConcurrencyLimit, int hardConcurrencyLimit, int maxQueuedQueries, DataSize memoryUsage, Duration cpuUsage, int numQueuedQueries, int numRunningQueries, int numEligibleSubGroups, Optional<List<ResourceGroupInfo>> subGroups, Optional<List<QueryStateInfo>> runningQueries) {
    public ResourceGroupInfo {
        Objects.requireNonNull(id, "id is null");
        Objects.requireNonNull(state, "state is null");
        Objects.requireNonNull(schedulingPolicy, "schedulingPolicy is null");
        Objects.requireNonNull(softMemoryLimit, "softMemoryLimit is null");
        Objects.requireNonNull(memoryUsage, "memoryUsage is null");
        Objects.requireNonNull(cpuUsage, "cpuUsage is null");
        subGroups = subGroups.map(ImmutableList::copyOf);
        runningQueries = runningQueries.map(ImmutableList::copyOf);
    }
}

