/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.ui;

import com.google.inject.Inject;
import io.trino.server.ExternalUriInfo;
import io.trino.server.ServletSecurityUtils;
import io.trino.server.security.ResourceSecurity;
import io.trino.server.security.oauth2.OAuth2Client;
import io.trino.server.ui.AuthInfo;
import io.trino.server.ui.FormWebUiAuthenticationFilter;
import io.trino.server.ui.OAuthIdTokenCookie;
import io.trino.server.ui.OAuthWebUiCookie;
import io.trino.spi.security.Identity;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;

@Path(value="")
@ResourceSecurity(value=ResourceSecurity.AccessType.WEB_UI)
public class OAuth2WebUiPreviewResource {
    private final OAuth2Client oAuth2Client;

    @Inject
    public OAuth2WebUiPreviewResource(OAuth2Client oAuth2Client) {
        this.oAuth2Client = Objects.requireNonNull(oAuth2Client, "oAuth2Client is null");
    }

    @GET
    @Path(value="/ui/preview/auth/info")
    @Produces(value={"application/json"})
    public AuthInfo getAuthInfo(ContainerRequestContext request) {
        Optional<String> username = ServletSecurityUtils.authenticatedIdentity(request).map(Identity::getUser);
        return new AuthInfo("oauth2", false, username.isPresent(), username);
    }

    @GET
    @Path(value="/ui/preview/auth/logout")
    @Produces(value={"application/json"})
    public Response logout(@Context HttpHeaders httpHeaders, @BeanParam ExternalUriInfo uriInfo, @Context SecurityContext securityContext) {
        Optional<String> idToken = OAuthIdTokenCookie.read(httpHeaders.getCookies());
        URI callbackUri = uriInfo.absolutePath("/ui/logout/logout.html");
        return Response.seeOther((URI)this.oAuth2Client.getLogoutEndpoint(idToken, callbackUri).orElse(callbackUri)).cookie(OAuthIdTokenCookie.delete(httpHeaders.getCookies())).cookie(FormWebUiAuthenticationFilter.getDeleteCookies(httpHeaders.getCookies(), securityContext.isSecure())).cookie(OAuthWebUiCookie.delete(httpHeaders.getCookies())).build();
    }
}

