/*
 * Decompiled with CFR 0.152.
 */
package io.trino.split;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.trino.annotation.NotThreadSafe;
import io.trino.metadata.Split;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.split.SplitSource;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

@NotThreadSafe
public class ConnectorAwareSplitSource
implements SplitSource {
    private final CatalogHandle catalogHandle;
    private final String sourceToString;
    @Nullable
    private ConnectorSplitSource source;
    private boolean finished;
    private Optional<Optional<List<Object>>> tableExecuteSplitsInfo = Optional.empty();

    public ConnectorAwareSplitSource(CatalogHandle catalogHandle, ConnectorSplitSource source) {
        this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        this.source = Objects.requireNonNull(source, "source is null");
        this.sourceToString = source.toString();
    }

    @Override
    public CatalogHandle getCatalogHandle() {
        return this.catalogHandle;
    }

    @Override
    public ListenableFuture<SplitSource.SplitBatch> getNextBatch(int maxSize) {
        Preconditions.checkState((this.source != null ? 1 : 0) != 0, (Object)"Already finished or closed");
        ListenableFuture nextBatch = MoreFutures.toListenableFuture((CompletableFuture)this.source.getNextBatch(maxSize));
        return Futures.transform((ListenableFuture)nextBatch, splitBatch -> {
            List connectorSplits = splitBatch.getSplits();
            ImmutableList.Builder result = ImmutableList.builderWithExpectedSize((int)connectorSplits.size());
            for (ConnectorSplit connectorSplit : connectorSplits) {
                result.add((Object)new Split(this.catalogHandle, connectorSplit));
            }
            boolean noMoreSplits = splitBatch.isNoMoreSplits();
            if (noMoreSplits) {
                this.finished = true;
                this.tableExecuteSplitsInfo = Optional.of(this.source.getTableExecuteSplitsInfo());
                this.closeSource();
            }
            return new SplitSource.SplitBatch((List<Split>)result.build(), noMoreSplits);
        }, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public void close() {
        this.closeSource();
    }

    private void closeSource() {
        if (this.source != null) {
            try {
                this.source.close();
            }
            finally {
                this.source = null;
            }
        }
    }

    @Override
    public boolean isFinished() {
        if (!this.finished) {
            Preconditions.checkState((this.source != null ? 1 : 0) != 0, (Object)"Already closed");
            if (this.source.isFinished()) {
                this.finished = true;
                this.tableExecuteSplitsInfo = Optional.of(this.source.getTableExecuteSplitsInfo());
                this.closeSource();
            }
        }
        return this.finished;
    }

    @Override
    public Optional<List<Object>> getTableExecuteSplitsInfo() {
        return this.tableExecuteSplitsInfo.orElseThrow(() -> new IllegalStateException("Not finished yet"));
    }

    public String toString() {
        return String.valueOf(this.catalogHandle) + ":" + String.valueOf(MoreObjects.firstNonNull((Object)this.source, (Object)this.sourceToString));
    }
}

