/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.DefaultTraversalVisitor;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FieldReference;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import java.util.Set;

public final class ConstantExpressionVerifier {
    private ConstantExpressionVerifier() {
    }

    public static void verifyExpressionIsConstant(Set<NodeRef<Expression>> columnReferences, Expression expression) {
        new ConstantExpressionVerifierVisitor(columnReferences, expression).process((Node)expression, null);
    }

    private static class ConstantExpressionVerifierVisitor
    extends DefaultTraversalVisitor<Void> {
        private final Set<NodeRef<Expression>> columnReferences;
        private final Expression expression;

        public ConstantExpressionVerifierVisitor(Set<NodeRef<Expression>> columnReferences, Expression expression) {
            this.columnReferences = columnReferences;
            this.expression = expression;
        }

        protected Void visitDereferenceExpression(DereferenceExpression node, Void context) {
            if (this.columnReferences.contains(NodeRef.of((Node)node))) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_CONSTANT, (Node)this.expression, "Constant expression cannot contain column references", new Object[0]);
            }
            this.process((Node)node.getBase(), context);
            return null;
        }

        protected Void visitIdentifier(Identifier node, Void context) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_CONSTANT, (Node)this.expression, "Constant expression cannot contain column references", new Object[0]);
        }

        protected Void visitFieldReference(FieldReference node, Void context) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_CONSTANT, (Node)this.expression, "Constant expression cannot contain column references", new Object[0]);
        }
    }
}

