/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer.rule;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import io.trino.sql.InterpretedFunctionInvoker;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Switch;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.ir.optimizer.IrOptimizerRule;
import io.trino.sql.planner.Symbol;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class EvaluateSwitch
implements IrOptimizerRule {
    private final Metadata metadata;
    private final InterpretedFunctionInvoker functionInvoker;

    public EvaluateSwitch(PlannerContext context) {
        this.metadata = context.getMetadata();
        this.functionInvoker = new InterpretedFunctionInvoker(context.getFunctionManager());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Optional<Expression> apply(Expression expression, Session session, Map<Symbol, Expression> bindings) {
        Object defaultValue;
        if (!(expression instanceof Switch)) return Optional.empty();
        Switch switch_ = (Switch)expression;
        Object object = switch_.operand();
        Expression operand = object;
        Object whenClauses = object = switch_.whenClauses();
        try {
            defaultValue = object = switch_.defaultValue();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (!(operand instanceof Constant)) {
            return Optional.empty();
        }
        Constant constantOperand = (Constant)operand;
        if (constantOperand.value() == null) {
            return Optional.of(defaultValue);
        }
        ConnectorSession connectorSession = session.toConnectorSession();
        ResolvedFunction equals = this.metadata.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)operand.type(), (Object)operand.type()));
        Iterator iterator = whenClauses.iterator();
        while (iterator.hasNext()) {
            WhenClause whenClause = (WhenClause)iterator.next();
            Expression expression2 = whenClause.getOperand();
            if (!(expression2 instanceof Constant)) {
                return Optional.empty();
            }
            Constant candidate = (Constant)expression2;
            if (!Boolean.TRUE.equals(this.functionInvoker.invoke(equals, connectorSession, Arrays.asList(constantOperand.value(), candidate.value())))) continue;
            return Optional.of(whenClause.getResult());
        }
        return Optional.of(defaultValue);
    }
}

