/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.cost.TaskCountEstimator;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableProperties;
import io.trino.spi.connector.ConnectorBucketNodeMap;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.TableScanNode;
import java.util.Objects;
import java.util.Optional;

public class DetermineTableScanNodePartitioning
implements Rule<TableScanNode> {
    private static final Pattern<TableScanNode> PATTERN = Patterns.tableScan().matching(tableScan -> tableScan.getUseConnectorNodePartitioning().isEmpty());
    private final Metadata metadata;
    private final NodePartitioningManager nodePartitioningManager;
    private final TaskCountEstimator taskCountEstimator;

    public DetermineTableScanNodePartitioning(Metadata metadata, NodePartitioningManager nodePartitioningManager, TaskCountEstimator taskCountEstimator) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
        this.taskCountEstimator = Objects.requireNonNull(taskCountEstimator, "taskCountEstimator is null");
    }

    @Override
    public Pattern<TableScanNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(TableScanNode node, Captures captures, Rule.Context context) {
        return Rule.Result.ofPlanNode(DetermineTableScanNodePartitioning.setUseConnectorNodePartitioning(this.metadata, this.nodePartitioningManager, this.taskCountEstimator, context.getSession(), node));
    }

    public static TableScanNode setUseConnectorNodePartitioning(Metadata metadata, NodePartitioningManager nodePartitioningManager, TaskCountEstimator taskCountEstimator, Session session, TableScanNode node) {
        int numberOfTasks;
        TableProperties properties = metadata.getTableProperties(session, node.getTable());
        if (properties.getTablePartitioning().isEmpty()) {
            return node.withUseConnectorNodePartitioning(false);
        }
        TableProperties.TablePartitioning partitioning = properties.getTablePartitioning().get();
        Optional<ConnectorBucketNodeMap> bucketNodeMap = nodePartitioningManager.getConnectorBucketNodeMap(session, partitioning.partitioningHandle());
        if (bucketNodeMap.map(ConnectorBucketNodeMap::hasFixedMapping).orElse(false).booleanValue()) {
            return node.withUseConnectorNodePartitioning(true);
        }
        if (!SystemSessionProperties.isUseTableScanNodePartitioning(session)) {
            return node.withUseConnectorNodePartitioning(false);
        }
        int numberOfBuckets = bucketNodeMap.map(ConnectorBucketNodeMap::getBucketCount).orElseGet(() -> nodePartitioningManager.getNodeCount(session, partitioning.partitioningHandle()));
        return node.withUseConnectorNodePartitioning((double)numberOfBuckets / (double)(numberOfTasks = Math.max(taskCountEstimator.estimateSourceDistributedTaskCount(session), 1)) >= SystemSessionProperties.getTableScanNodePartitioningMinBucketToTaskRatio(session));
    }
}

